/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.events;

import com.bwanms.client.gui.fault.ColorSchema;
import com.bwanms.client.gui.fault.events.EventManagerConfigHelper;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.util.fault.EventUtil;
import java.awt.Color;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventRowProvider
extends EntityManagerRowProviderBase {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer("com.bwanms.faultConstants");
    private EventManagerConfigHelper helper;
    private boolean isHistoryContext = false;

    public EventRowProvider(List<String> attributes) {
        super(attributes);
    }

    public EventRowProvider(List<String> attributes, EventManagerConfigHelper helper) {
        super(attributes);
        this.helper = helper;
    }

    public EventRowProvider(List<String> attributes, EventManagerConfigHelper helper, boolean isHistoryContext) {
        super(attributes);
        this.helper = helper;
        this.isHistoryContext = isHistoryContext;
    }

    @Override
    public List<String> getDisplayValues(EntityManagerRow entityRow) {
        List<String> ret = super.getDisplayValues(entityRow);
        Event event = (Event)entityRow.getEntity();
        if (!this.isHistoryContext && !this.helper.getChkSeverities()[event.getEventSeverity()]) {
            return null;
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            String prop = this.helper.getProperty(i);
            if (Event.Property.eventSeverity.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.translateEventSeverity(event, i18n));
                continue;
            }
            if (Event.Property.receiveTime.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.formatTimestamp(event.getReceiveTime()));
                continue;
            }
            if (Event.Property.eventTime.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.formatTimestamp(event.getEventTime()));
                continue;
            }
            if (Event.Property.equipmentType.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.translateEquipmentType(event, i18n));
                continue;
            }
            if (Event.Property.managedObject.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), event.getManagedObject());
                continue;
            }
            if (Event.Property.moAlias.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), event.getMoAlias());
                continue;
            }
            if (Event.Property.eventCategory.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.translateEventCategory(event, i18n));
                continue;
            }
            if (Event.Property.eventName.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.unescapeString(event.getEventName()));
                continue;
            }
            if (Event.Property.eventType.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.translateEventType(event, i18n));
                continue;
            }
            if (Event.Property.ackedBy.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.unescapeString(event.getAckedBy()));
                continue;
            }
            if (Event.Property.ackTime.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.formatTimestamp(event.getAckTime()));
                continue;
            }
            if (Event.Property.clearedBy.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.unescapeString(event.getClearedBy()));
                continue;
            }
            if (Event.Property.clearTime.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.formatTimestamp(event.getClearTime()));
                continue;
            }
            if (Event.Property.lastUpdateTime.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.formatTimestamp(event.getLastUpdateTime()));
                continue;
            }
            if (Event.Property.equipmentName.name().equals(prop)) {
                ret.set(this.attributes.indexOf(prop), EventUtil.unescapeString(event.getEquipmentName()));
                continue;
            }
            if (!Event.Property.locationName.name().equals(prop)) continue;
            ret.set(this.attributes.indexOf(prop), EventUtil.unescapeString(event.getLocationName()));
        }
        return ret;
    }

    @Override
    protected String readEntityId(Serializable entity) {
        return String.valueOf(((Event)entity).getId());
    }

    public Color getRowColor(EntityManagerRow entityRow, int column) {
        Event event = (Event)entityRow.getEntity();
        ColorSchema colorSchema = ColorSchema.getActiveSchema();
        Color color = colorSchema.other();
        if (event.getEventCategory() == EventCategory.Alarm.value()) {
            String prop = this.helper.getProperty(column);
            if ((EventUtil.isCleared(event) || EventUtil.isClearingEvent(event)) && !Event.Property.eventSeverity.name().equals(prop)) {
                return Color.WHITE;
            }
            Severity severity = Severity.fromValue(event.getEventSeverity());
            switch (severity) {
                case Cleared: {
                    color = colorSchema.cleared();
                    break;
                }
                case Indeterminate: {
                    color = colorSchema.indeterminate();
                    break;
                }
                case Warning: {
                    color = colorSchema.warning();
                    break;
                }
                case Minor: {
                    color = colorSchema.minor();
                    break;
                }
                case Major: {
                    color = colorSchema.major();
                    break;
                }
                case Critical: {
                    color = colorSchema.critical();
                }
            }
        }
        return color;
    }
}

