/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.events;

import com.bwanms.backend.services.EventManagerService;
import com.bwanms.client.gui.fault.events.EventAbstractView;
import com.bwanms.client.gui.fault.events.EventMonitorManagerConfig;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.gui.manager.generic.EventManagerRowTableModel;
import com.bwanms.model.Settings;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.EventFilter;
import com.bwanms.model.fault.EventQueryResult;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.platform.UIEventThread;
import com.bwanms.util.ExecutorUtils;
import com.bwanms.util.fault.EventUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class EventMonitorView
extends EventAbstractView {
    private static Logger logger = Logger.getLogger(EventMonitorView.class);
    private static int POLLING_INTERVAL = 2000;
    private ScheduledExecutorService refreshDaemon;
    private AtomicBoolean frozen;
    private AtomicBoolean resultViewFilled;
    private final EventManagerService service = ServiceRegistry.getEventManagerService();
    private final EntityManagerRowProvider rowCreator = this.config.getEntityRowProvider();
    private long lastRemoveTime = -1L;
    private long lastUpdateTime = -1L;
    private EventQueryResult eventResult;
    private List<Event> listEvents;
    private int[] countersTotal;

    public EventMonitorView(EventMonitorManagerConfig config) {
        super(config);
        this.frozen = new AtomicBoolean(false);
        this.resultViewFilled = new AtomicBoolean(true);
        this.refreshDaemon = Executors.newSingleThreadScheduledExecutor();
    }

    public void initUI() {
        this.form.getTglFreeze().setVisible(true);
        this.form.getBtnRefresh().setVisible(false);
        this.form.getPnlTimeCriteriaPanel().setVisible(false);
        this.form.getChkNow().setVisible(false);
        this.form.getTglFreeze().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                EventMonitorView.this.frozen.set(EventMonitorView.this.form.getTglFreeze().isSelected());
            }
        });
        this.refreshDaemon.scheduleWithFixedDelay(new AutoRefreshTask(), 0L, POLLING_INTERVAL, TimeUnit.MILLISECONDS);
    }

    public void performQuery() {
        try {
            long startTime = System.currentTimeMillis();
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
            logger.debug((Object)("[" + Thread.currentThread().getName() + "] AUTO-REFRESH STARTED"));
            if (this.lastUpdateTime == -1L) {
                this.getEvents(this.sqlExpression, 0L);
                this.insertEntireList();
                this.lastRemoveTime = this.eventResult.getLastRemoveTime();
            } else {
                if (this.filterHasChanged) {
                    this.getEvents(this.sqlExpression, 0L);
                    this.insertEntireList();
                    this.filterHasChanged = false;
                } else {
                    this.getEvents(this.sqlExpression, this.lastUpdateTime);
                    if (this.lastRemoveTime == this.eventResult.getLastRemoveTime()) {
                        this.updateList();
                    } else if (this.lastRemoveTime == this.eventResult.getOldRemoveTime()) {
                        this.updateList();
                    } else {
                        this.getEvents(this.sqlExpression, 0L);
                        this.insertEntireList();
                    }
                }
                this.lastRemoveTime = this.eventResult.getLastRemoveTime();
            }
            this.form.setCounters(this.counters, this.countersTotal);
            logger.debug((Object)("[" + Thread.currentThread().getName() + "] AUTO-REFRESH END (" + (System.currentTimeMillis() - startTime) + ")----------; lastRemoveTime=" + formatter.format(new Date(this.lastRemoveTime)) + "; eventResultOldRemoveTime=" + formatter.format(new Date(this.eventResult.getOldRemoveTime())) + "; eventResultLastRemoveTime=" + formatter.format(new Date(this.eventResult.getLastRemoveTime()))));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug((Object)e, (Throwable)e);
        }
    }

    private void getEvents(String sqlExpression, long lastUpdateTime) {
        try {
            this.eventResult = this.service.getEvents(sqlExpression, lastUpdateTime);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            logger.debug((Object)e, (Throwable)e);
            return;
        }
        this.listEvents = this.eventResult.getEvents();
        logger.debug((Object)("AUTO-REFRESH fetched listEvents... " + (this.listEvents == null ? 0 : this.listEvents.size())));
        this.countersTotal = this.eventResult.getCounters();
        logger.debug((Object)"AUTO-REFRESH fetched counters...");
        if (lastUpdateTime == 0L) {
            this.counters = new int[]{0, 0, 0, 0, 0, 0, 0};
        }
    }

    private void updateOnlyChangedList() {
        boolean isEntityChanged = true;
        int listPosition = this.listEvents.size() - 1;
        while (isEntityChanged && listPosition >= 0) {
            Event event = this.listEvents.get(listPosition);
            this.setLastUpdateTime(event);
            EntityManagerRow managerRow = ((EventManagerRowTableModel)this.resultView.getTableModel()).findRowByID(event.getId());
            if (managerRow != null) {
                this.resultView.entityChanged(this.rowCreator.createRow(event));
                --listPosition;
                continue;
            }
            this.resultView.entityAdded(this.rowCreator.createRow(event));
            this.updateCounters(event, 1);
            --listPosition;
        }
    }

    private void updateList() {
        boolean isEntityChanged = true;
        int listPosition = this.listEvents.size() - 1;
        while (isEntityChanged && listPosition >= 0) {
            Event event = this.listEvents.get(listPosition);
            this.setLastUpdateTime(event);
            EntityManagerRow managerRow = ((EventManagerRowTableModel)this.resultView.getTableModel()).findRowByID(event.getId());
            if (EventUtil.isDeleted(event)) {
                if (managerRow != null) {
                    this.resultView.entityRemoved(event);
                    this.updateCounters(event, -1);
                }
                --listPosition;
                continue;
            }
            if (managerRow != null) {
                this.resultView.entityChanged(this.rowCreator.createRow(event));
                --listPosition;
                continue;
            }
            this.resultView.entityAdded(this.rowCreator.createRow(event));
            this.updateCounters(event, 1);
            --listPosition;
        }
    }

    private void insertEntireList() {
        final ArrayList<EntityManagerRow> result = new ArrayList<EntityManagerRow>();
        for (Event event : this.listEvents) {
            if (EventUtil.isDeleted(event)) continue;
            this.setLastUpdateTime(event);
            result.add(this.rowCreator.createRow(event));
            this.updateCounters(event, 1);
        }
        logger.debug((Object)("AUTO-REFRESH FINISHED Query : " + this.listEvents.size() + " records"));
        this.resultViewFilled.set(false);
        UIEventThread.syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    EventMonitorView.this.resultView.setEntityQueryResults(new EntityQueryResults(result));
                    logger.debug((Object)"AUTO-REFRESH RELEASE");
                }
                catch (Exception e) {
                    logger.debug((Object)e, (Throwable)e);
                }
                finally {
                    EventMonitorView.this.resultViewFilled.set(true);
                }
            }
        });
    }

    private void setLastUpdateTime(Event event) {
        if (this.lastUpdateTime < event.getLastUpdateTime()) {
            this.lastUpdateTime = event.getLastUpdateTime();
        }
    }

    public synchronized void cleanup() {
        this.frozen.set(true);
        ExecutorUtils.shutdownAndWait("AUTO-REFRESH", this.refreshDaemon, 2);
        super.cleanup();
    }

    protected void loadSettings() {
        try {
            EventFilter savedFilter;
            Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
            String filterID = settings.getProperty("EventMonitorFilter", null);
            if (filterID != null && (savedFilter = ServiceRegistry.getEntityManagerService().get(EventFilter.class, Long.parseLong(filterID))) != null) {
                this.eventFilter = savedFilter;
                ArrayList<EventFilter> eventFilterList = new ArrayList<EventFilter>();
                eventFilterList.add(savedFilter);
                this.form.getSelectorFilters().setValue(eventFilterList);
                this.filterHasChanged = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    protected void saveSettings() {
        try {
            Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
            if (this.eventFilter != null) {
                long filterID = this.eventFilter.getId();
                settings.setProperty("EventMonitorFilter", String.valueOf(filterID));
            } else {
                settings.setProperty("EventMonitorFilter", null);
            }
            ServiceRegistry.getSettingsService().updateSettings(settings);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private class AutoRefreshTask
    implements Runnable {
        private AutoRefreshTask() {
        }

        public void run() {
            if (EventMonitorView.this.form.isShowing() && !EventMonitorView.this.frozen.get()) {
                EventMonitorView.this.performQuery();
            }
        }
    }
}

