/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.events;

import com.bwanms.client.gui.fault.ColorSchema;
import com.bwanms.client.gui.fault.events.EventHistoryManagerConfig;
import com.bwanms.client.gui.fault.events.EventManagerConfigHelper;
import com.bwanms.client.gui.fault.events.EventMonitorManagerConfig;
import com.bwanms.client.gui.fault.events.FaultPanel;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EventHistoryQueryResults;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerResultView;
import com.bwanms.gui.manager.generic.EntityManagerRowTableModel;
import com.bwanms.gui.manager.generic.EventManagerRowTableModel;
import com.bwanms.model.Settings;
import com.bwanms.model.fault.Event;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.EventCellRenderer;
import com.bwanms.ui.platform.UIBackgroundJob;
import com.bwanms.ui.platform.UIEventThread;
import com.bwanms.util.TableUtil;
import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManagerResultsView
extends EntityManagerResultView {
    private EventManagerRowTableModel eventTableModel;
    private boolean isHistoryScreen;
    private boolean isOpenAlarmsScreen;
    private int totalResultsCount;
    private EventManagerConfigHelper helper;
    private int[] counters;

    public EventManagerResultsView(EntityManagerRowTableModel tableModel, List<EntityManagerColumn> columns, boolean isHistoryScreen, boolean isOpenAlarmsScreen) {
        this(tableModel, columns, false);
        this.isOpenAlarmsScreen = isOpenAlarmsScreen;
    }

    public EventManagerResultsView(EntityManagerRowTableModel tableModel, List<EntityManagerColumn> columns, boolean isHistoryScreen) {
        super(tableModel, columns);
        this.eventTableModel = (EventManagerRowTableModel)this.tableModel;
        this.totalResultsCount = 0;
        this.isHistoryScreen = isHistoryScreen;
        this.helper = isHistoryScreen ? EventHistoryManagerConfig.getHelper() : EventMonitorManagerConfig.getHelper();
    }

    public EventManagerResultsView(EntityManagerRowTableModel tableModel, List<EntityManagerColumn> columns) {
        super(tableModel, columns);
        this.eventTableModel = (EventManagerRowTableModel)this.tableModel;
        this.totalResultsCount = 0;
    }

    @Override
    protected void replaceData(EntityQueryResults data) {
        this.eventTableModel.replaceData(data.getData());
        this.sortedColumn = -1;
    }

    @Override
    public void setEntityQueryResults(EntityQueryResults data) {
        List<EntityManagerRow> oldSelection = this.getSelection();
        if (null == data) {
            this.eventTableModel.clear();
            this.sortedColumn = -1;
        } else {
            this.replaceData(data);
            if (this.isHistoryScreen) {
                this.updateCounters(data);
                JTable table = this.form.getResultTable();
                table.scrollRectToVisible(table.getCellRect(0, 0, true));
            }
            this.totalResultsCount = data.getResultSetSize();
        }
        this.fireSelectionChanged();
        this.updateSelection(oldSelection);
        this.updateResultsDescription(this.totalResultsCount);
    }

    private void updateCounters(EntityQueryResults data) {
        final int[] counters = ((EventHistoryQueryResults)data).getCounters();
        final int[] countersTotal = ((EventHistoryQueryResults)data).getCountersTotal();
        for (int i = 0; i < countersTotal.length; ++i) {
            if (counters[i] <= countersTotal[i]) continue;
            countersTotal[i] = counters[i];
        }
        UIEventThread.asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ((FaultPanel)EventManagerResultsView.this.form.getParent().getParent()).setCounters(counters, countersTotal);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    protected void configure() {
        super.configure();
        this.configureResultsTable(this.form.getResultTable());
    }

    private void configureResultsTable(JTable table) {
        table.setDoubleBuffered(true);
        table.setSelectionBackground(ColorSchema.getActiveSchema().selected());
        table.setSelectionForeground(Color.WHITE);
        table.setDefaultRenderer(Object.class, new EventCellRenderer((EntityManagerRowTableModel)table.getModel()));
        table.setAutoResizeMode(0);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            TableUtil.autoResizeColumnPreffredWidth(table, i, true);
        }
        if (!this.isOpenAlarmsScreen) {
            table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                public void columnAdded(TableColumnModelEvent e) {
                }

                public void columnMarginChanged(ChangeEvent e) {
                }

                public void columnRemoved(TableColumnModelEvent e) {
                }

                public void columnSelectionChanged(ListSelectionEvent e) {
                }

                public void columnMoved(TableColumnModelEvent e) {
                    if (e.getFromIndex() == e.getToIndex()) {
                        return;
                    }
                    TableColumnModel model = (TableColumnModel)e.getSource();
                    Enumeration<TableColumn> tableOrder = model.getColumns();
                    int i = 0;
                    while (tableOrder.hasMoreElements()) {
                        TableColumn col = tableOrder.nextElement();
                        EventManagerResultsView.this.helper.put(i, (String)col.getHeaderValue());
                        ++i;
                    }
                    EventManagerResultsView.this.persistColumnOrder();
                }
            });
        }
    }

    private void persistColumnOrder() {
        Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
        StringBuffer columnOrder = new StringBuffer();
        for (int i = 0; i < this.helper.getColumns().size(); ++i) {
            columnOrder.append(this.helper.getName(i)).append(",");
        }
        settings.setProperty(this.isHistoryScreen ? "EventHistoryColumnOrder" : "EventMonitorColumnOrder", columnOrder.toString());
        ServiceRegistry.getSettingsService().updateSettings(settings);
    }

    @Override
    protected void updateResultsDescription(final Integer totalResultCount) {
        new UIBackgroundJob(){

            public void run() {
                EventManagerResultsView.this.form.getLblResultDescription().setText(i18n.translateString("ResultsDescriptionTotal", EventManagerResultsView.this.isHistoryScreen ? totalResultCount.intValue() : EventManagerResultsView.this.form.getResultTable().getRowCount()));
            }
        }.schedule();
    }

    public void updateSelection(List<EntityManagerRow> oldSelection) {
        for (EntityManagerRow oldRow : oldSelection) {
            int index = this.eventTableModel.getRows().indexOf(oldRow);
            this.form.getResultTable().getSelectionModel().addSelectionInterval(index, index);
        }
    }

    @Override
    public void entityRemoved(Serializable entity) {
        List<EntityManagerRow> oldSelection = this.getSelection();
        Event event = (Event)entity;
        EntityManagerRow row = this.eventTableModel.findRowByID(event.getId());
        boolean counted = false;
        if (null != row) {
            int indexRows = this.eventTableModel.getRows().indexOf(row);
            int indexVisibleRows = this.eventTableModel.getVisibleRows().indexOf(row);
            if (indexRows >= 0 && this.eventTableModel.getDisplayData() != null) {
                this.eventTableModel.getRows().remove(indexRows);
                this.eventTableModel.getDisplayData().remove(indexRows);
                this.eventTableModel.getMap().remove(event.getId());
                --this.totalResultsCount;
                this.updateResultsDescription(this.totalResultsCount);
                counted = true;
            }
            if (indexVisibleRows >= 0 && this.eventTableModel.getVisibleDisplayData() != null) {
                this.eventTableModel.getVisibleRows().remove(indexVisibleRows);
                this.eventTableModel.getVisibleDisplayData().remove(indexVisibleRows);
                this.eventTableModel.fireTableRowsDeleted(indexVisibleRows, indexVisibleRows);
                if (!counted) {
                    --this.totalResultsCount;
                    this.updateResultsDescription(this.totalResultsCount);
                }
            }
        }
        this.updateSelection(oldSelection);
        this.eventTableModel.fireTableDataChanged();
    }

    @Override
    public void entityChanged(EntityManagerRow entity) {
        List<EntityManagerRow> oldSelection = this.getSelection();
        for (int i = 0; i < this.eventTableModel.getRowCount(); ++i) {
            EntityManagerRow row = this.eventTableModel.getRowAt(i);
            if (row == null || !entity.getId().equals(row.getId())) continue;
            this.eventTableModel.updateRowAt(i, entity);
            this.eventTableModel.fireTableRowsUpdated(i, i);
            this.sortedColumn = -1;
            break;
        }
        this.fireSelectionChanged();
        this.updateSelection(oldSelection);
    }

    @Override
    public void entityAdded(EntityManagerRow entity) {
        this.eventTableModel.addData(entity);
        ++this.totalResultsCount;
        this.sortedColumn = -1;
        this.updateResultsDescription(this.totalResultsCount);
    }

    public int[] getCounters() {
        return this.counters;
    }
}

