/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.events;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.model.fault.EventFilter;
import com.bwanms.model.fault.constants.Severity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManagerConfigHelper
implements Serializable {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(EventManagerConfigHelper.class);
    private String[] colNames;
    private String[] propNames;
    private Map<Integer, String> mapIdxToName = new TreeMap<Integer, String>();
    private Map<String, String> mapNameToAttr = new HashMap<String, String>();
    private EventFilter currentFilter;
    private boolean[] chkSeverities = new boolean[Severity.values().length - 1];

    public EventManagerConfigHelper(String[] colNames, String[] propNames) {
        this.colNames = colNames;
        this.propNames = propNames;
        for (int i = 0; i < colNames.length; ++i) {
            String name = i18n.translateString(colNames[i]);
            this.mapIdxToName.put(i, name);
            this.mapNameToAttr.put(name, propNames[i]);
        }
    }

    public String getProperty(int idx) {
        return this.mapNameToAttr.get(this.mapIdxToName.get(idx));
    }

    public String getName(int idx) {
        return this.mapIdxToName.get(idx);
    }

    public void put(Integer idx, String name) {
        this.mapIdxToName.put(idx, name);
    }

    public Vector<EntityManagerColumn> getColumns() {
        Vector<EntityManagerColumn> columns = new Vector<EntityManagerColumn>(this.colNames.length);
        for (Integer idx : this.mapIdxToName.keySet()) {
            String name = this.mapIdxToName.get(idx);
            columns.add(new EntityManagerColumn(name, this.mapNameToAttr.get(name), name, new EntityManagerRowDisplayComparator(idx)));
        }
        return columns;
    }

    public EventFilter getCurrentFilter() {
        return this.currentFilter;
    }

    public void setCurrentFilter(EventFilter currentFilter) {
        this.currentFilter = currentFilter;
    }

    public boolean[] getChkSeverities() {
        return this.chkSeverities;
    }

    public void setChkSeverities(int index, boolean value) {
        this.chkSeverities[index] = value;
    }
}

