/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.events;

import au.com.bytecode.opencsv.CSVWriter;
import com.bwanms.client.gui.fault.events.EventAbstractView;
import com.bwanms.client.gui.fault.events.EventDetailsEditorContainer;
import com.bwanms.ddi.ConfigLaunchNotSupportedException;
import com.bwanms.ddi.CutThroughNotSupportedException;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.locationmanager.LocationMapEditorContainer;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.model.Equipment;
import com.bwanms.model.Location;
import com.bwanms.model.fault.Event;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.platform.UIBackgroundJob;
import com.bwanms.util.ConfigLauncherPluginUtil;
import com.bwanms.util.CutThroughPluginUtil;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.fault.EventUtil;
import java.awt.Color;
import java.awt.Frame;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JTable;
import jpdf.attribute.AlignmentFactorHorizontal;
import jpdf.attribute.BackgroundColorOnPage;
import jpdf.attribute.ColumnHeaders;
import jpdf.attribute.ContentHeadersOnEveryPage;
import jpdf.attribute.OffsetTop;
import jpdf.attribute.PageContentFrame;
import jpdf.attribute.PageFootNotes;
import jpdf.attribute.PageFrame;
import jpdf.attribute.PageHeadNotes;
import jpdf.attribute.RowHeaders;
import jpdf.attribute.SelectedRows;
import jpdf.attribute.SizeColumnsToFitData;
import jpdf.attribute.SizeToFitPageWidth;
import jpdf.attribute.SplitColumns;
import jpdf.attribute.UseBackgroundColor;
import jpdf.attribute.WrapToFitPage;
import jpdf.gui.PrintInfoHolder;
import jpdf.gui.dialog.PrintDialog;
import jpdf.gui.dialog.PrintDialogPreferences;
import jpdf.gui.dialog.factory.AbstractSetupPrintDialogFactory;
import jpdf.gui.dialog.factory.SetupContentPrintDialogFactory;
import jpdf.gui.preview.PreviewPrintableFrame;
import jpdf.manage.BasicPrintJobObserver;
import jpdf.manage.PrintCustomizationFacade;
import jpdf.manage.PrintJobObserver;
import jpdf.manage.PrintManager;
import jpdf.manage.ResourceAdministrator;
import jpdf.printable.AttributeSetPrintable;
import jpdf.printer.TableComponentPrinter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManagerAction
extends ManagerAction {
    private static final Logger logger = Logger.getLogger(EventManagerAction.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(EventManagerAction.class);
    private static final Internationalizer i18nConstants = Internationalizer.getInternationalizer("com.bwanms.faultConstants");
    private static boolean printEnvInitialized = false;

    public EventManagerAction(String name, int category) {
        this.name = name;
        this.category = category;
    }

    @Override
    public void performAction(ManagerView manager) {
        if ("EventDetails".equals(this.name)) {
            this.performEventDetails((EventAbstractView)manager);
        } else if ("EventAdvisor".equals(this.name)) {
            this.performEventAdvisor((EventAbstractView)manager);
        } else if ("Ack".equals(this.name)) {
            this.performAck((EventAbstractView)manager);
        } else if ("UnAck".equals(this.name)) {
            this.performUnAck((EventAbstractView)manager);
        } else if ("Clear".equals(this.name)) {
            this.performClear((EventAbstractView)manager);
        } else if ("ClearingEvent".equals(this.name)) {
            this.performClearingEvent((EventAbstractView)manager);
        } else if ("EquipmentDetails".equals(this.name)) {
            this.performEquipmentDetails((EventAbstractView)manager);
        } else if ("CutThrough".equals(this.name)) {
            this.performCutThrough((EventAbstractView)manager);
        } else if ("TopologyMap".equals(this.name)) {
            this.performTopologyMap((EventAbstractView)manager);
        } else if ("Export".equals(this.name)) {
            this.performExport((EventAbstractView)manager);
        } else if ("PrintPreview".equals(this.name)) {
            this.performPrintPreview((EventAbstractView)manager);
        } else if ("Print".equals(this.name)) {
            this.performPrint((EventAbstractView)manager);
        }
    }

    @Override
    public boolean isEnabled(List<Serializable> selection) {
        int selectionSize;
        int n = selectionSize = null != selection ? selection.size() : 0;
        if ("EventDetails".equals(this.name)) {
            return selectionSize == 1;
        }
        if ("EventAdvisor".equals(this.name)) {
            return selectionSize == 1;
        }
        if ("Ack".equals(this.name)) {
            if (selectionSize == 1) {
                Event event = (Event)selection.get(0);
                return !EventUtil.isAcked(event);
            }
            return selectionSize > 1;
        }
        if ("UnAck".equals(this.name)) {
            if (selectionSize == 1) {
                Event event = (Event)selection.get(0);
                return EventUtil.isAcked(event);
            }
            return selectionSize > 1;
        }
        if ("Clear".equals(this.name)) {
            if (selectionSize == 1) {
                Event event = (Event)selection.get(0);
                if (!EventUtil.isAlarm(event)) {
                    return false;
                }
                if (EventUtil.isClearingEvent(event)) {
                    return false;
                }
                return !EventUtil.isCleared(event);
            }
            return selectionSize > 1;
        }
        if ("ClearingEvent".equals(this.name)) {
            if (selectionSize != 1) {
                return false;
            }
            Event event = (Event)selection.get(0);
            return event != null && EventUtil.isClearedByCorrelation(event);
        }
        if ("EquipmentDetails".equals(this.name)) {
            long equipmentId;
            if (selectionSize != 1) {
                return false;
            }
            Event event = (Event)selection.get(0);
            if (event != null && (equipmentId = event.getEquipmentId()) > 0L) {
                try {
                    Equipment equipment = ServiceRegistry.getEntityManagerService().get(Equipment.class, equipmentId);
                    if (equipment != null) {
                        return ConfigLauncherPluginUtil.isConfigLaunchSupported(equipment.getClass());
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Disabled Equipment Details action due to abnormal server behavior - " + e.getMessage()));
                }
            }
            return false;
        }
        if ("CutThrough".equals(this.name)) {
            long equipmentId;
            if (selectionSize != 1) {
                return false;
            }
            Event event = (Event)selection.get(0);
            if (event != null && (equipmentId = event.getEquipmentId()) > 0L) {
                try {
                    Equipment equipment = ServiceRegistry.getEntityManagerService().get(Equipment.class, equipmentId);
                    if (equipment != null) {
                        return CutThroughPluginUtil.isCutThroughSupported(equipment.getClass());
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Disabled Equipment Details action due to abnormal server behavior - " + e.getMessage()));
                }
            }
            return false;
        }
        if ("TopologyMap".equals(this.name)) {
            long equipmentId;
            if (selectionSize != 1) {
                return false;
            }
            Event event = (Event)selection.get(0);
            if (event != null && (equipmentId = event.getEquipmentId()) > 0L) {
                try {
                    Equipment equipment = ServiceRegistry.getEntityManagerService().get(Equipment.class, equipmentId);
                    if (equipment != null) {
                        return true;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Disabled Equipment Details action due to abnormal server behavior - " + e.getMessage()));
                }
            }
            return false;
        }
        if ("Export".equals(this.name)) {
            return selectionSize >= 1;
        }
        if ("PrintPreview".equals(this.name)) {
            return true;
        }
        if ("Print".equals(this.name)) {
            return true;
        }
        return true;
    }

    @Override
    public Internationalizer getI18n() {
        return i18n;
    }

    private void performEventDetails(EventAbstractView manager) {
        List<Serializable> selection = manager.getSelection();
        try {
            Event event = (Event)selection.get(0);
            if (event == null) {
                MessageBox.Error.quickShow(manager.getUI(), i18n.translateString("CannotDisplayNullEvent"));
                return;
            }
            if (event != null) {
                new EventDetailsEditorContainer(event);
            }
        }
        catch (Exception e) {
            logger.debug((Object)e);
            MessageBox.Error.quickShow(manager.getUI(), i18n.translateString("CannotFetchEventDetails"));
        }
    }

    private void performEventAdvisor(EventAbstractView manager) {
        List<Serializable> selection = manager.getSelection();
        try {
            Event event = (Event)selection.get(0);
            if (event == null) {
                MessageBox.Error.quickShow(manager.getUI(), i18n.translateString("CannotDisplayNullEvent"));
                return;
            }
            event = ServiceRegistry.getEventManagerService().getEventDetails(event.getId());
            if (event != null) {
                MessageBox.Info.showOption(manager.getUI(), event.getEventAdvisor(), i18n.translateString("EventAdvisor"));
            } else {
                MessageBox.Error.quickShow(manager.getUI(), i18n.translateString("CannotFetchEventDetails"));
            }
        }
        catch (Exception e) {
            logger.debug((Object)e);
            MessageBox.Error.quickShow(manager.getUI(), e.getMessage());
        }
    }

    private void performAck(final EventAbstractView manager) {
        final List<Serializable> selection = manager.getSelection();
        new UIBackgroundJob(){

            public void run() {
                try {
                    LinkedList<Event> newSelection = new LinkedList<Event>();
                    for (Event event : selection) {
                        if (EventUtil.isAcked(event)) continue;
                        newSelection.add(event);
                    }
                    long time1 = System.currentTimeMillis();
                    if (newSelection.size() > 0) {
                        ArrayList<Event> batch = new ArrayList<Event>(100);
                        int cnt = 0;
                        for (Event event : newSelection) {
                            if (cnt == 100) {
                                ServiceRegistry.getEventManagerService().ackEvents(batch, Security.getSecurity().getCurrentUserId(), true);
                                batch.clear();
                                cnt = 0;
                                continue;
                            }
                            batch.add(event);
                            ++cnt;
                        }
                        if (cnt > 0) {
                            ServiceRegistry.getEventManagerService().ackEvents(batch, Security.getSecurity().getCurrentUserId(), true);
                            batch.clear();
                        }
                        long time2 = System.currentTimeMillis();
                        logger.info((Object)String.format("ACK %d / %d events in %d millis", newSelection.size(), selection.size(), time2 - time1));
                    }
                }
                catch (Exception e) {
                    MessageBox.Error.quickShow(manager.getUI(), e.getMessage());
                }
            }
        }.schedule();
    }

    private void performUnAck(final EventAbstractView manager) {
        final List<Serializable> selection = manager.getSelection();
        new UIBackgroundJob(){

            public void run() {
                try {
                    LinkedList<Event> newSelection = new LinkedList<Event>();
                    for (Event event : selection) {
                        if (!EventUtil.isAcked(event)) continue;
                        newSelection.add(event);
                    }
                    long time1 = System.currentTimeMillis();
                    if (newSelection.size() > 0) {
                        ServiceRegistry.getEventManagerService().ackEvents(newSelection, Security.getSecurity().getCurrentUserId(), false);
                        long time2 = System.currentTimeMillis();
                        logger.info((Object)String.format("UNACK %d / %d events in %d millis", newSelection.size(), selection.size(), time2 - time1));
                    }
                }
                catch (Exception e) {
                    MessageBox.Error.quickShow(manager.getUI(), e.getMessage());
                }
            }
        }.schedule();
    }

    private void performClear(final EventAbstractView manager) {
        final List<Serializable> selection = manager.getSelection();
        new UIBackgroundJob(){

            public void run() {
                try {
                    LinkedList<Event> newSelection = new LinkedList<Event>();
                    for (Event event : selection) {
                        if (!EventUtil.isAlarm(event) || EventUtil.isClearingEvent(event) || EventUtil.isCleared(event)) continue;
                        newSelection.add(event);
                    }
                    long time1 = System.currentTimeMillis();
                    if (newSelection.size() > 0) {
                        ServiceRegistry.getEventManagerService().clearEvents(newSelection, Security.getSecurity().getCurrentUserId());
                        long time2 = System.currentTimeMillis();
                        logger.info((Object)String.format("CLEAR %d / %d events in %d millis", newSelection.size(), selection.size(), time2 - time1));
                    }
                }
                catch (Exception e) {
                    MessageBox.Error.quickShow(manager.getUI(), e.getMessage());
                }
            }
        }.schedule();
    }

    private void performEquipmentDetails(EventAbstractView manager) {
        List<Serializable> selection = manager.getSelection();
        Event event = (Event)selection.get(0);
        if (event == null) {
            MessageBox.Error.quickShow(manager.getUI(), i18n.translateString("CannotLaunchEquipmentDetails"));
            return;
        }
        long equipmentId = event.getEquipmentId();
        if (equipmentId > 0L) {
            Equipment equipment = ServiceRegistry.getEntityManagerService().get(Equipment.class, equipmentId);
            if (equipment != null && equipment.isReachable()) {
                try {
                    ConfigLauncherPluginUtil.performConfigLaunch(equipment, event.getMoType(), event.getMoInstance());
                }
                catch (ConfigLaunchNotSupportedException e) {
                    e.printStackTrace();
                }
            } else {
                MessageBox.Alert.quickShow(manager.getUI(), i18n.translateString("EquipmentNotReachable"));
            }
        }
    }

    private void performCutThrough(EventAbstractView manager) {
        List<Serializable> selection = manager.getSelection();
        Event event = (Event)selection.get(0);
        if (event == null) {
            MessageBox.Error.quickShow(manager.getUI(), i18n.translateString("CannotLaunchCutThrough"));
            return;
        }
        long equipmentId = event.getEquipmentId();
        if (equipmentId > 0L) {
            Equipment equipment = ServiceRegistry.getEntityManagerService().get(Equipment.class, equipmentId);
            if (equipment != null && equipment.isReachable()) {
                try {
                    CutThroughPluginUtil.performCutThrough(equipment);
                }
                catch (CutThroughNotSupportedException e) {
                    e.printStackTrace();
                }
            } else {
                MessageBox.Alert.quickShow(manager.getUI(), i18n.translateString("EquipmentNotReachable"));
            }
        }
    }

    private void performClearingEvent(EventAbstractView manager) {
        List<Serializable> selection = manager.getSelection();
        Event event = (Event)selection.get(0);
        if (event == null) {
            MessageBox.Error.quickShow(manager.getUI(), i18n.translateString("CannotDisplayNullEvent"));
            return;
        }
        if (EventUtil.isClearedByCorrelation(event)) {
            Event correlationEvent = null;
            try {
                long id = event.getCorrelationEventId();
                if (id > 0L) {
                    correlationEvent = ServiceRegistry.getEventManagerService().getEventDetails(event.getCorrelationEventId());
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            if (correlationEvent != null) {
                try {
                    new EventDetailsEditorContainer(correlationEvent);
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
        } else {
            MessageBox.Info.quickShow(null, i18n.translateString("NotACorrelatedEvent"));
            return;
        }
    }

    private void performTopologyMap(EventAbstractView manager) {
        List<Serializable> selection = manager.getSelection();
        Event event = (Event)selection.get(0);
        if (event == null) {
            MessageBox.Error.quickShow(manager.getUI(), i18n.translateString("CannotLaunchTopologyMap"));
            return;
        }
        long equipmentId = event.getEquipmentId();
        if (equipmentId > 0L) {
            Equipment equipment = ServiceRegistry.getEntityManagerService().get(Equipment.class, equipmentId);
            if (equipment == null || !equipment.isReachable()) {
                MessageBox.Error.quickShow(manager.getUI(), i18n.translateString("EquipmentNullOrNotReachable"));
                return;
            }
            Location location = equipment.getLocation();
            if (location != null) {
                LocationMapEditorContainer container = null;
                try {
                    container = new LocationMapEditorContainer(location);
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                container.setFormLauncher(null);
            } else {
                MessageBox.Alert.quickShow(manager.getUI(), i18n.translateString("EquipmentHasNoLocation"));
            }
        } else {
            MessageBox.Alert.quickShow(manager.getUI(), i18n.translateString("EquipmentNotFound"));
        }
    }

    private void performExport(EventAbstractView manager) {
        List<Serializable> selection = manager.getSelection();
        File exportFile = FormUtil.getExportFile(manager.getUI(), i18n.translateString("ExportEventTitle"), "csv", i18n.translateString("ExportEventFilterDescr", "*.csv"));
        if (exportFile != null) {
            boolean overwriteExistingFile = false;
            if (exportFile.exists() && !(overwriteExistingFile = MessageBox.WarnConfirm.showResult(manager.getUI(), i18n.translateString("ExportFileReplacingConfirmation", exportFile.getAbsolutePath()), i18n.translateString("ExportEventTitle")))) {
                logger.info((Object)i18n.translateString("ExportFileReplacingRejected", exportFile.getAbsolutePath()));
                return;
            }
            if (!selection.isEmpty()) {
                try {
                    CSVWriter csvOut = new CSVWriter((Writer)new FileWriter(exportFile), ',', '\"', '\\', "\r\n");
                    String[] headLine = EventUtil.tableHeaderForExport(i18n);
                    csvOut.writeNext(headLine);
                    for (Event event : selection) {
                        String[] line = EventUtil.toStringArrayForExport(event, i18nConstants);
                        csvOut.writeNext(line);
                    }
                    csvOut.close();
                }
                catch (IOException e) {
                    MessageBox.Alert.quickShow(manager.getUI(), i18n.translateString("CannotExportToCSV"));
                    e.printStackTrace();
                }
            }
        }
    }

    private void performPrintPreview(EventAbstractView manager) {
        JTable table = manager.getResultView().getForm().getResultTable();
        TableComponentPrinter TABLE_PRINTER = new TableComponentPrinter(table, manager.getTitle(), true, true);
        float HEAD_NOTE_FONT_SIZE = 12.0f;
        float FOOT_NOTE_FONT_SIZE = 10.0f;
        PrintRequestAttributeSet theAttributeSet = null;
        String theDateAndTimeMarker = null;
        String thePageAndCountMarker = null;
        try {
            if (!printEnvInitialized) {
                PrintManager.initializeEnvironment();
                printEnvInitialized = true;
            }
        }
        catch (Throwable e) {
            MessageBox.Error.quickShow(manager.getUI(), e.getMessage());
            return;
        }
        PrintManager.preloadPrintServiceMediaOnThread();
        PrintCustomizationFacade.addPrintJobObserver((PrintJobObserver)new BasicPrintJobObserver());
        ResourceAdministrator.setTimeStyle((int)3);
        PrintDialogPreferences.setToUsePrintServiceSelectionIcons((boolean)true);
        PrintDialogPreferences.setToIncludeBannerPageController((boolean)false);
        theAttributeSet = PrintManager.getDefaultPrintAttributes();
        theDateAndTimeMarker = "[-d-] [-t-]";
        thePageAndCountMarker = "Page [-p-] of [-n-]";
        theAttributeSet.add(new JobName("Preview Table Example", null));
        theAttributeSet.add((Attribute)new PageHeadNotes("", "[-T-]", "", Color.BLUE, 12.0f));
        theAttributeSet.add((Attribute)new PageFootNotes(theDateAndTimeMarker, "", thePageAndCountMarker, Color.BLUE, 10.0f));
        theAttributeSet.add((Attribute)new AlignmentFactorHorizontal(0.5f));
        theAttributeSet.add((Attribute)new OffsetTop(0.1f, true));
        theAttributeSet.add((Attribute)PageFrame.FALSE);
        theAttributeSet.add((Attribute)PageContentFrame.FALSE);
        theAttributeSet.add((Attribute)UseBackgroundColor.FALSE);
        theAttributeSet.add((Attribute)BackgroundColorOnPage.FALSE);
        theAttributeSet.add((Attribute)ColumnHeaders.TRUE);
        theAttributeSet.add((Attribute)RowHeaders.FALSE);
        theAttributeSet.add((Attribute)SplitColumns.FALSE);
        theAttributeSet.add((Attribute)ContentHeadersOnEveryPage.TRUE);
        theAttributeSet.add((Attribute)SelectedRows.TRUE);
        theAttributeSet.add((Attribute)SizeColumnsToFitData.TRUE);
        theAttributeSet.add((Attribute)WrapToFitPage.FALSE);
        theAttributeSet.add((Attribute)SizeToFitPageWidth.FALSE);
        theAttributeSet.add(OrientationRequested.LANDSCAPE);
        PreviewPrintableFrame previewWindow = null;
        int theWindowState = 0;
        if (previewWindow == null || !previewWindow.isDisplayable()) {
            PreviewPrintableFrame.setZoomToFit((boolean)true);
            previewWindow = new PreviewPrintableFrame((AttributeSetPrintable)TABLE_PRINTER);
            previewWindow.setDialogFactory((AbstractSetupPrintDialogFactory)new SetupContentPrintDialogFactory());
            previewWindow.setSize(640, 480);
            previewWindow.sizeToFit();
            previewWindow.show();
        } else {
            theWindowState = previewWindow.getExtendedState();
            previewWindow.toFront();
        }
    }

    private void performPrint(EventAbstractView manager) {
        JTable table = manager.getResultView().getForm().getResultTable();
        TableComponentPrinter TABLE_PRINTER = new TableComponentPrinter(table, manager.getTitle(), true, true);
        float HEAD_NOTE_FONT_SIZE = 12.0f;
        float FOOT_NOTE_FONT_SIZE = 10.0f;
        PrintRequestAttributeSet theAttributeSet = null;
        String theDateAndTimeMarker = null;
        String thePageAndCountMarker = null;
        try {
            if (!printEnvInitialized) {
                PrintManager.initializeEnvironment();
                printEnvInitialized = true;
            }
        }
        catch (Throwable e) {
            MessageBox.Error.quickShow(manager.getUI(), e.getMessage());
            return;
        }
        PrintManager.preloadPrintServiceMediaOnThread();
        PrintCustomizationFacade.addPrintJobObserver((PrintJobObserver)new BasicPrintJobObserver());
        ResourceAdministrator.setTimeStyle((int)3);
        PrintDialogPreferences.setToUsePrintServiceSelectionIcons((boolean)true);
        PrintDialogPreferences.setToIncludeBannerPageController((boolean)false);
        theAttributeSet = PrintManager.getDefaultPrintAttributes();
        theDateAndTimeMarker = "[-d-] [-t-]";
        thePageAndCountMarker = "Page [-p-] of [-n-]";
        theAttributeSet.add(new JobName("Preview Table Example", null));
        theAttributeSet.add((Attribute)new PageHeadNotes("", "[-T-]", "", Color.BLUE, 12.0f));
        theAttributeSet.add((Attribute)new PageFootNotes(theDateAndTimeMarker, "", thePageAndCountMarker, Color.BLUE, 10.0f));
        theAttributeSet.add((Attribute)new AlignmentFactorHorizontal(0.5f));
        theAttributeSet.add((Attribute)new OffsetTop(0.1f, true));
        theAttributeSet.add((Attribute)PageFrame.FALSE);
        theAttributeSet.add((Attribute)PageContentFrame.FALSE);
        theAttributeSet.add((Attribute)UseBackgroundColor.FALSE);
        theAttributeSet.add((Attribute)BackgroundColorOnPage.FALSE);
        theAttributeSet.add((Attribute)ColumnHeaders.TRUE);
        theAttributeSet.add((Attribute)RowHeaders.FALSE);
        theAttributeSet.add((Attribute)SplitColumns.FALSE);
        theAttributeSet.add((Attribute)ContentHeadersOnEveryPage.TRUE);
        theAttributeSet.add((Attribute)SelectedRows.TRUE);
        theAttributeSet.add((Attribute)SizeColumnsToFitData.TRUE);
        theAttributeSet.add((Attribute)WrapToFitPage.FALSE);
        theAttributeSet.add((Attribute)SizeToFitPageWidth.TRUE);
        theAttributeSet.add(OrientationRequested.LANDSCAPE);
        Frame theOwnerFrame = null;
        PrintService thePrintService = PrintManager.getDefaultPrintService();
        PrintDialog theDialog = null;
        theDialog = new PrintDialog(theOwnerFrame, Locale.getDefault(), theAttributeSet, thePrintService, (DocFlavor)DocFlavor.SERVICE_FORMATTED.PRINTABLE, false);
        theDialog.show();
        thePrintService = theDialog.getSelectedPrintService();
        if (thePrintService != null) {
            PrintManager.printPrintable((Printable)TABLE_PRINTER, (PrintInfoHolder)theDialog.getPrintInfoHolder(), (boolean)true);
        }
    }
}

