/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.events;

import com.bwanms.client.gui.fault.events.EventAbstractView;
import com.bwanms.client.gui.fault.events.EventHistoryEntityQuerySort;
import com.bwanms.client.gui.fault.events.EventHistoryManagerConfig;
import com.bwanms.client.gui.fault.events.EventHistoryQueryFilter;
import com.bwanms.client.gui.fault.events.EventHistorySortView;
import com.bwanms.client.gui.fault.events.FaultPanel;
import com.bwanms.client.gui.fault.filters.EvtFilterTimeCriteriaPanel;
import com.bwanms.gui.manager.ManagerMediator;
import com.bwanms.gui.manager.NavigatorViewListener;
import com.bwanms.gui.manager.generic.EntityManagerNavigatorView;
import com.bwanms.gui.manager.generic.EntityManagerResultForm;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.model.Settings;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.EventFilter;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.SortableHeaderRenderer;
import com.bwanms.ui.platform.UIBackgroundJob;
import com.bwanms.util.FormUtil;
import com.bwanms.util.MessageBox;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import org.apache.log4j.Logger;

public class EventHistoryView
extends EventAbstractView
implements NavigatorViewListener {
    private static Logger logger = Logger.getLogger(EventHistoryView.class);
    private SortableHeaderRenderer resultViewHeaderRenderer;
    private EventHistorySortView sortView;
    private List<Event.Property> defaultOrderByEventProperty = new ArrayList<Event.Property>(Arrays.asList(Event.Property.receiveTime, Event.Property.id));
    private List<Boolean> defaultOrderByDesc = new ArrayList<Boolean>(Arrays.asList(true, true));
    public static Set<Event.Property> columnsForSorting = new HashSet<Event.Property>(Arrays.asList(Event.Property.receiveTime, Event.Property.eventSeverity, Event.Property.locationName, Event.Property.equipmentName, Event.Property.managedObject, Event.Property.moAlias, Event.Property.sourceIPAddress, Event.Property.eventName));

    public EventHistoryView(final EventHistoryManagerConfig config) {
        super(config);
        this.filterView = new EventHistoryManagerConfig.EventHistoryFilterView(config.getEntityRowProvider());
        EntityManagerResultForm eform = (EntityManagerResultForm)this.resultView.getUI();
        final JTable resultTable = eform.getResultTable();
        final JTableHeader theader = resultTable.getTableHeader();
        this.resultViewHeaderRenderer = new SortableHeaderRenderer(theader.getDefaultRenderer());
        this.resultViewHeaderRenderer.setSortingStatus(2, -1);
        theader.setDefaultRenderer(this.resultViewHeaderRenderer);
        this.sortView = new EventHistorySortView();
        this.sortView.setSort(new EventHistoryEntityQuerySort(this.defaultOrderByEventProperty, this.defaultOrderByDesc));
        this.mediator = new ManagerMediator(config.getQueryStrategy(), config.getManagerCacheStrategy(), this.resultView, this.filterView, this.navigatorView, this.sortView);
        this.navigatorView.addNavigatorViewListener(this);
        theader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                if (EventHistoryView.this.form.getBtnRefresh().isEnabled()) {
                    int column = theader.columnAtPoint(new Point(arg0.getX(), arg0.getY()));
                    column = resultTable.getColumnModel().getColumn(column).getModelIndex();
                    String colAttr = config.getColumns().get(column).getAttribute();
                    Event.Property evtProp = Event.Property.valueOf(colAttr);
                    if (column >= 0 && columnsForSorting.contains((Object)evtProp)) {
                        int nextStatus = EventHistoryView.this.resultViewHeaderRenderer.getNextAscSortingStatus(column);
                        if (nextStatus == 0) {
                            EventHistoryView.this.resultViewHeaderRenderer.setSortingStatus(column, nextStatus);
                            nextStatus = EventHistoryView.this.resultViewHeaderRenderer.getNextAscSortingStatus(column);
                        }
                        EventHistoryView.this.resultViewHeaderRenderer.cancelSorting();
                        EventHistoryView.this.resultViewHeaderRenderer.setSortingStatus(column, nextStatus);
                        EventHistoryEntityQuerySort srtQuery = (EventHistoryEntityQuerySort)EventHistoryView.this.sortView.getSort();
                        List<Event.Property> sortEvtProp = srtQuery.getSortByEventProperties();
                        sortEvtProp.clear();
                        List<Boolean> sortDesc = srtQuery.getSortByDesc();
                        sortDesc.clear();
                        sortEvtProp.add(evtProp);
                        sortDesc.add(nextStatus == -1);
                        if (evtProp.equals((Object)Event.Property.receiveTime)) {
                            sortEvtProp.add(Event.Property.id);
                            sortDesc.add(nextStatus == -1);
                        } else {
                            sortEvtProp.add(Event.Property.receiveTime);
                            sortDesc.add(true);
                            sortEvtProp.add(Event.Property.id);
                            sortDesc.add(true);
                        }
                        theader.repaint();
                        EventHistoryView.this.saveSettings();
                        EventHistoryView.this.performQuery();
                    }
                }
            }
        });
    }

    public void initUI() {
        this.form.getTglFreeze().setVisible(false);
        this.form.getBtnSeverities().setVisible(false);
        this.form.getBtnRefresh().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                EntityManagerResultForm eform = (EntityManagerResultForm)EventHistoryView.this.resultView.getUI();
                JTableHeader theader = eform.getResultTable().getTableHeader();
                theader.repaint();
                EventHistoryView.this.saveSettings();
                EventHistoryView.this.performQuery();
            }
        });
        this.performQuery();
    }

    public void pageChanged(final int pageNumber) {
        new UIBackgroundJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    EventHistoryView.this.queryDisabled(false);
                    EventHistoryView.this.mediator.pageChanged(pageNumber);
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                    MessageBox.Error.quickShow(EventHistoryView.this.form, EventAbstractView.i18n.translateString("ErrorOccured.PleaseRefresh"));
                }
                finally {
                    EventHistoryView.this.queryDisabled(true);
                }
            }
        }.schedule();
    }

    public void pageSizeChanged(int pageSize) {
        this.mediator.setPageSize(pageSize);
    }

    public void performQuery() {
        if (null != this.filterView) {
            try {
                this.filterView.prepareFilter();
            }
            catch (InvalidFilterValueException ifve) {
                String message = i18n.translateString("InvalidValue", ifve.getMessage());
                MessageBox.Error.quickShow(this.form, message);
                return;
            }
        }
        new UIBackgroundJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    long toDate;
                    long fromDate;
                    EventHistoryView.this.queryDisabled(false);
                    ((EventHistoryQueryFilter)EventHistoryView.this.filterView.getFilter()).setFilter(EventHistoryManagerConfig.getHelper().getCurrentFilter());
                    EvtFilterTimeCriteriaPanel pnlTimeCriteria = EventHistoryView.this.form.getPnlTimeCriteriaPanel();
                    if (EventHistoryView.this.form.getChkNow().isSelected()) {
                        FaultPanel.setDateForNow(pnlTimeCriteria.getDateChooserFrom(), pnlTimeCriteria.getDateChooserTo(), false);
                    }
                    if ((fromDate = pnlTimeCriteria.getDateChooserFrom().getDate().getTime()) > (toDate = pnlTimeCriteria.getDateChooserTo().getDate().getTime())) {
                        MessageBox.Error.showOption((JFrame)SwingUtilities.getWindowAncestor(EventHistoryView.this.form), EventAbstractView.i18n.translateString("FromDateOlderThanToDate"));
                        return;
                    }
                    ((EventHistoryQueryFilter)EventHistoryView.this.filterView.getFilter()).setFromDate(fromDate);
                    ((EventHistoryQueryFilter)EventHistoryView.this.filterView.getFilter()).setToDate(toDate);
                    EventHistoryView.this.mediator.performQuery();
                }
                catch (Throwable t) {
                    logger.error((Object)t, t);
                    MessageBox.Error.quickShow(EventHistoryView.this.form, EventAbstractView.i18n.translateString("ErrorOccured.PleaseRefresh"));
                }
                finally {
                    EventHistoryView.this.queryDisabled(true);
                }
            }
        }.schedule();
    }

    private void queryDisabled(boolean value) {
        this.form.getBtnRefresh().setEnabled(value);
        this.form.getSelectorFilters().selectorEnabled(value);
        ((EntityManagerNavigatorView)this.navigatorView).enableButtons(value);
    }

    protected void loadSettings() {
        try {
            EventFilter savedFilter;
            String filterID;
            Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
            String isNowString = settings.getProperty("IsNow:" + EventHistoryView.class.getName(), null);
            boolean isNow = false;
            isNow = isNowString != null ? Boolean.parseBoolean(isNowString) : true;
            FormUtil.setEnabled((Container)this.form.getPnlTimeCriteriaPanel().getDateChooserTo(), !isNow);
            this.form.getChkNow().setSelected(isNow);
            if (!isNow) {
                String fromDate = settings.getProperty("FromDate:" + EventHistoryView.class.getName(), null);
                String toDate = settings.getProperty("ToDate:" + EventHistoryView.class.getName(), null);
                if (fromDate != null) {
                    this.form.getPnlTimeCriteriaPanel().getDateChooserFrom().setDate(new Date(Long.parseLong(fromDate)));
                }
                if (toDate != null) {
                    this.form.getPnlTimeCriteriaPanel().getDateChooserTo().setDate(new Date(Long.parseLong(toDate)));
                }
            }
            if (null != this.navigatorView) {
                String pageSizeStr = settings.getProperty("NavigatorPageSize:" + Event.class.getName(), null);
                this.navigatorView.setPageSize(null != pageSizeStr ? Integer.parseInt(pageSizeStr) : this.config.getPageSize());
            }
            if ((filterID = settings.getProperty("EventHistoryFilter", null)) != null && (savedFilter = ServiceRegistry.getEntityManagerService().get(EventFilter.class, Long.parseLong(filterID))) != null) {
                this.eventFilter = savedFilter;
                ArrayList<EventFilter> eventFilterList = new ArrayList<EventFilter>();
                eventFilterList.add(savedFilter);
                this.form.getSelectorFilters().setValue(eventFilterList);
                this.filterHasChanged = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    protected void saveSettings() {
        try {
            Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
            long fromDate = this.form.getPnlTimeCriteriaPanel().getDateChooserFrom().getDate().getTime();
            long toDate = this.form.getPnlTimeCriteriaPanel().getDateChooserTo().getDate().getTime();
            boolean isNow = this.form.getChkNow().isSelected();
            settings.setProperty("FromDate:" + EventHistoryView.class.getName(), String.valueOf(fromDate));
            settings.setProperty("ToDate:" + EventHistoryView.class.getName(), String.valueOf(toDate));
            settings.setProperty("IsNow:" + EventHistoryView.class.getName(), String.valueOf(isNow));
            if (null != this.navigatorView) {
                settings.setProperty("NavigatorPageSize:" + Event.class.getName(), String.valueOf(this.navigatorView.getPageSize()));
            }
            if (this.eventFilter != null) {
                long filterID = this.eventFilter.getId();
                settings.setProperty("EventHistoryFilter", String.valueOf(filterID));
            } else {
                settings.setProperty("EventHistoryFilter", null);
            }
            ServiceRegistry.getSettingsService().updateSettings(settings);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }
}

