/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.events;

import com.bwanms.client.gui.fault.events.EventDetailPanel;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextAreaBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.ReadOnlyBinder;
import com.bwanms.mediation.snmp.SNMPTrapAgentEvent;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.AdministrativeState;
import com.bwanms.model.fault.constants.AlarmStatus;
import com.bwanms.model.fault.constants.AvailabilityStatus;
import com.bwanms.model.fault.constants.ControlStatus;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.EventFilterConstantsProvider;
import com.bwanms.model.fault.constants.EventProtocol;
import com.bwanms.model.fault.constants.GenericTrap;
import com.bwanms.model.fault.constants.LifecycleStatus;
import com.bwanms.model.fault.constants.OperationalState;
import com.bwanms.model.fault.constants.ProceduralStatus;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.model.fault.constants.StandbyStatus;
import com.bwanms.model.fault.constants.UnknownStatus;
import com.bwanms.model.fault.constants.UsageState;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.OctetString;
import com.bwanms.util.fault.EventUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDetailsView
extends AbstractBindedEditorView<Event> {
    private static final Internationalizer i18nConstants = Internationalizer.getInternationalizer("com.bwanms.faultConstants");
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(EventDetailsView.class);
    private EventDetailPanel panel = new EventDetailPanel();
    private static final long _1_DAY_HOURS = 24L;
    private static final long _1_HOUR_MINS = 60L;
    private static final long _1_MIN_SECS = 60L;
    private static final long _1_DAY_MINS = 1440L;
    private static final long _1_DAY_SECS = 86400L;
    private static final long _1_HOUR_SECS = 3600L;

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EventDetails");
    }

    @Override
    public void fillUI(Event entity) {
        this.panel.getTxtEquipmentName().setText(EventUtil.unescapeString(entity.getEquipmentName()));
        this.panel.getTxtEquipmentLocation().setText(EventUtil.unescapeString(entity.getLocationName()));
        this.panel.getTxtEquipmentType().setText(EventUtil.translateEquipmentType(entity, i18nConstants));
        this.panel.getTxtEventCategory().setText(EventUtil.translateEventCategory(entity, i18nConstants));
        this.panel.getTxtEventType().setText(EventUtil.translateEventType(entity, i18nConstants));
        Severity severity = Severity.fromValue(entity.getEventSeverity());
        if (EventUtil.isAlarm(entity)) {
            this.panel.getTxtEventSeverity().setText(EventUtil.translateEventSeverity(entity, i18nConstants));
            this.panel.getTxtEventSeverity().setBackground(EventUtil.getSeverityColor(severity));
            severity = Severity.fromValue(entity.getObjectSeverity());
            this.panel.getTxtObjectSeverity().setText(EventUtil.translateObjectSeverity(entity, i18nConstants));
            this.panel.getTxtObjectSeverity().setBackground(EventUtil.getSeverityColor(severity));
        } else {
            this.panel.getTxtEventSeverity().setText(EventUtil.translateEventSeverity(entity, i18nConstants));
            this.panel.getTxtEventSeverity().setBackground(EventUtil.getSeverityColor(severity));
        }
        this.panel.getTxtEventName().setText(EventUtil.unescapeString(entity.getEventName()));
        this.panel.getTxtEventDescription().setText(entity.getEventDescription());
        Serializable eventCause = entity.getEventCause();
        this.panel.getTxtReceivedTime().setText(EventUtil.formatTimestamp(entity.getReceiveTime()));
        this.panel.getTxtEventTime().setText(EventUtil.formatTimestamp(entity.getEventTime()));
        this.panel.getTxtLastUpdateTime().setText(EventUtil.formatTimestamp(entity.getLastUpdateTime()));
        this.panel.getTxtAckBy().setText(EventUtil.unescapeString(entity.getAckedBy()));
        this.panel.getTxtClearBy().setText(EventUtil.unescapeString(entity.getClearedBy()));
        this.panel.getTxtAckTime().setText(EventUtil.formatTimestamp(entity.getAckTime()));
        this.panel.getTxtClearTime().setText(EventUtil.formatTimestamp(entity.getClearTime()));
        EventCategory eventCategory = EventCategory.fromValue(entity.getEventCategory());
        switch (eventCategory) {
            case Alarm: {
                long correlationEventId;
                this.panel.getTxtAlarmInfoEventSeverity().setText(EventUtil.translateEventSeverity(entity, i18nConstants));
                severity = Severity.fromValue(entity.getEventSeverity());
                this.panel.getTxtAlarmInfoEventSeverity().setBackground(EventUtil.getSeverityColor(severity));
                this.panel.getTxtAlarmInfoObjectSeverity().setText(EventUtil.translateObjectSeverity(entity, i18nConstants));
                severity = Severity.fromValue(entity.getObjectSeverity());
                this.panel.getTxtAlarmInfoObjectSeverity().setBackground(EventUtil.getSeverityColor(severity));
                this.panel.getTxtAlarmProbableCause().setText(EventUtil.translateProbableCause(entity, i18nConstants));
                this.panel.getTxtAlarmInfoClearTime().setText(EventUtil.formatTimestamp(entity.getClearTime()));
                this.panel.getTxtAlarmInfoClearBy().setText(EventUtil.unescapeString(entity.getClearedBy()));
                if (EventUtil.isClearedByCorrelation(entity) && (correlationEventId = entity.getCorrelationEventId()) > 0L) {
                    try {
                        Event correlationEvent = ServiceRegistry.getEventManagerService().getEventDetails(correlationEventId);
                        if (correlationEvent != null) {
                            this.panel.getTxtClearCause().setText(EventUtil.unescapeString(correlationEvent.getEventName()));
                        } else {
                            this.panel.getTxtClearCause().setText("");
                        }
                        this.panel.setCorrelationEventId(entity.getCorrelationEventId());
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                    }
                }
                this.panel.getPnlAlarmInfo().setEnabled(true);
                this.panel.getPnlAlarmInfo().setVisible(true);
                break;
            }
            case StateChange: {
                this.panel.getTxtAdministrativeState().setText(i18nConstants.translateString(AdministrativeState.fromValue(entity.getAdministrativeState()).toString()));
                this.panel.getTxtOperationalState().setText(i18nConstants.translateString(OperationalState.fromValue(entity.getOperationalState()).toString()));
                this.panel.getTxtUsageState().setText(i18nConstants.translateString(UsageState.fromValue(entity.getUsageState()).toString()));
                this.panel.getTxtAlarmStatus().setText(i18nConstants.translateString(AlarmStatus.fromValue(entity.getAlarmStatus()).toString()));
                this.panel.getTxtProceduralStatus().setText(i18nConstants.translateString(ProceduralStatus.fromValue(entity.getProceduralStatus()).toString()));
                this.panel.getTxtAvailabilityStatus().setText(i18nConstants.translateString(AvailabilityStatus.fromValue(entity.getAvailabilityStatus()).toString()));
                this.panel.getTxtControlStatus().setText(i18nConstants.translateString(ControlStatus.fromValue(entity.getControlStatus()).toString()));
                this.panel.getTxtStandbyStatus().setText(i18nConstants.translateString(StandbyStatus.fromValue(entity.getStandbyStatus()).toString()));
                this.panel.getTxtLifecycleStatus().setText(i18nConstants.translateString(LifecycleStatus.fromValue(entity.getLifecycleStatus()).toString()));
                this.panel.getTxtUnknownStatus().setText(i18nConstants.translateString(UnknownStatus.fromValue(entity.getUnknownStatus()).toString()));
                this.panel.getPnlStateChangeInfo().setEnabled(true);
                this.panel.getPnlStateChangeInfo().setVisible(true);
                break;
            }
            case ConfigChange: {
                this.panel.getPnlConfigChangeInfo().setEnabled(true);
                this.panel.getPnlConfigChangeInfo().setVisible(true);
                break;
            }
            case SysEvent: {
                this.panel.getPnlSysEventInfo().setEnabled(true);
                this.panel.getPnlSysEventInfo().setVisible(true);
                break;
            }
        }
        this.panel.getTxtProtocol().setText(i18nConstants.translateString(EventProtocol.fromValue(new Integer(entity.getProtocol())).toString()));
        if (eventCause != null) {
            SNMPTrapAgentEvent trap = (SNMPTrapAgentEvent)eventCause;
            if (trap instanceof SNMPTrapV1AgentEvent) {
                SNMPTrapV1AgentEvent trapV1 = (SNMPTrapV1AgentEvent)trap;
                this.panel.getTxtSnmpVersion().setText("SNMP V1");
                this.panel.getLblOID().setText(i18n.translateString("SNMPEnterpriseOID"));
                this.panel.getTxtSnmpOid().setText(trapV1.getEnterpriseOID());
                int genericTrap = trapV1.getGeneric();
                this.panel.getTxtSnmpGeneric().setText(String.format("%d - %s", genericTrap, i18nConstants.translateString(GenericTrap.fromValue(genericTrap).toString())));
                if (genericTrap == GenericTrap.EnterpriseSpecific.value()) {
                    int specificTrap = trapV1.getSpecific();
                    Enum<?> trapConst = null;
                    IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
                    IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.eventFilterConstantsProvider");
                    for (IConfigurationElement element : extensionPoint.getConfigurationElements()) {
                        String className = element.getAttribute("class");
                        try {
                            Class<?> clazz = Class.forName(className);
                            EventFilterConstantsProvider constProvider = (EventFilterConstantsProvider)clazz.newInstance();
                            trapConst = constProvider.findTrapType(entity.getEventOID());
                            if (trapConst == null) continue;
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (trapConst != null) {
                        this.panel.getTxtSnmpSpecific().setText(String.format("%d - %s", specificTrap, i18nConstants.translateString(trapConst.toString())));
                    } else {
                        this.panel.getTxtSnmpSpecific().setText(String.valueOf(specificTrap));
                    }
                } else {
                    this.panel.getTxtSnmpSpecific().setText("");
                }
            } else {
                this.panel.getTxtSnmpVersion().setText("SNMP V2C");
                this.panel.getLblOID().setText(i18n.translateString("SNMPTrapOID"));
                this.panel.getTxtSnmpOid().setText(trap.getSnmpTrapOID());
            }
            this.panel.getTxtSnmpSystemUpTime().setText(this.sysUpTime(trap.getAgentEventTimestamp()));
            JTable table = this.panel.getTblVarBindings();
            DefaultTableModel tblModel = (DefaultTableModel)table.getModel();
            VarBindList varBinds = ((SNMPTrapAgentEvent)eventCause).getVarBindList();
            for (VarBind varBind : varBinds) {
                Object value = varBind.getVariable();
                if (varBind.getType() == -128) {
                    tblModel.addRow(new Object[]{varBind.getName(), varBind.getOID(), value != null ? OctetString.toDisplayString(value.toString()) : ""});
                    continue;
                }
                tblModel.addRow(new Object[]{varBind.getName(), varBind.getOID(), value != null ? value.toString() : ""});
            }
            this.panel.getTxtEventAdvisor().setText(entity.getEventAdvisor());
        }
        this.setCaretPosition();
    }

    private void setCaretPosition() {
        this.panel.getTxtEventDescription().setCaretPosition(0);
        this.panel.getTxtEventName().setCaretPosition(0);
        this.panel.getTxtEventAdvisor().setCaretPosition(0);
        this.panel.getTxtProposedRepair().setCaretPosition(0);
        this.panel.getTxtGeneralNotes().setCaretPosition(0);
    }

    @Override
    public List<InvalidValue> configureEntity(Event entity) {
        return super.configureEntity(entity);
    }

    @Override
    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add(new ReadOnlyBinder(this.getUI(), this.entity).add(new JTextFieldBinding("txtManagedObject", "managedObject")).add(new JTextFieldBinding("txtAlias", "moAlias")).add(new JTextFieldBinding("txtSourceIpAddress", "sourceIPAddress")).add(new JTextAreaBinding("txtProposedRepair", "proposedRepairAction")));
        binders.add(new DefaultBinder(this.getUI(), this.entity).add(new JTextAreaBinding("txtGeneralNotes", "eventNotes")));
        return binders;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.fm.event_details";
    }

    @Override
    public String getApplicationPermission() {
        return null;
    }

    private String sysUpTime(long timeTicks) {
        long upTimeSeconds = timeTicks / 100L;
        long days = upTimeSeconds / 86400L;
        long hours = (upTimeSeconds %= 86400L) / 3600L;
        long minutes = (upTimeSeconds %= 3600L) / 60L;
        return String.format("%d day%s %d hour%s %d minute%s %d second%s", days, days == 1L ? "" : "s", hours, hours == 1L ? "" : "s", minutes, minutes == 1L ? "" : "s", upTimeSeconds %= 60L, upTimeSeconds == 1L ? "" : "s");
    }
}

