/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.events;

import com.bwanms.client.gui.fault.events.EventDetailsView;
import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.OperationalEvent;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDetailsEditorContainer
extends EntityEditorContainer<Event> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(EventDetailsEditorContainer.class);

    @Override
    protected Event loadEntity(Event entity) throws ServiceException {
        return ServiceRegistry.getEventManagerService().getEventDetails(entity.getId());
    }

    @Override
    protected void saveEntity() throws ServiceException {
        ServiceRegistry.getEventManagerService().updateEvent((Event)this.entity);
    }

    public EventDetailsEditorContainer(Event entity) throws ServiceException {
        super(entity);
    }

    @Override
    protected String getEntityClass() {
        return i18n.translateString(OperationalEvent.class.getName());
    }

    @Override
    public String getEntityId() {
        return String.valueOf(((Event)this.getEntity()).getId());
    }

    @Override
    protected String getEntityName() {
        return this.getEntity() != null ? ((Event)this.getEntity()).getEventName() : "";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("EventDetails");
    }

    @Override
    protected EditorView<Event> initView() {
        return new EventDetailsView();
    }
}

