/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.events;

import com.bwanms.client.gui.fault.events.EventHistoryManagerConfig;
import com.bwanms.client.gui.fault.events.EventManagerConfigHelper;
import com.bwanms.client.gui.fault.events.EventManagerResultsView;
import com.bwanms.client.gui.fault.events.EventMonitorManagerConfig;
import com.bwanms.client.gui.fault.events.FaultPanel;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.help.HelpAction;
import com.bwanms.gui.manager.ManagerMediator;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.NavigatorView;
import com.bwanms.gui.manager.ResultsViewListener;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EventManagerRowTableModel;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerActionAdapter;
import com.bwanms.gui.manager.generic.ManagerFilterView;
import com.bwanms.gui.selectors.SelectorListOneElementComponent;
import com.bwanms.model.Settings;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.EventFilter;
import com.bwanms.model.fault.EvtFilterEventCategory;
import com.bwanms.model.fault.EvtFilterSeverity;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.fault.FilterUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventAbstractView
implements ManagerView,
ResultsViewListener {
    protected static final Internationalizer i18n = Internationalizer.getInternationalizer(EventAbstractView.class);
    protected FaultPanel form;
    protected ManagerMediator mediator;
    protected EntityManagerConfig config;
    private HashMap<String, ManagerActionAdapter> declaredActions;
    protected EventManagerResultsView resultView;
    protected ManagerFilterView filterView;
    protected NavigatorView navigatorView;
    protected EventFilter eventFilter;
    protected String sqlExpression;
    protected boolean filterHasChanged = false;
    protected int[] counters;
    private boolean isInitialized = false;

    public EventAbstractView(EntityManagerConfig config) {
        this.config = config;
        this.resultView = (EventManagerResultsView)config.getResultsView();
        this.resultView.addResultsAreaListener(this);
        this.navigatorView = config.getNavigatorView();
    }

    @Override
    public List<EntityManagerRow> getData() {
        return null;
    }

    @Override
    public List<Serializable> getSelection() {
        List<EntityManagerRow> selectionRows = this.getSelectionData();
        if (null != selectionRows) {
            ArrayList<Serializable> selection = new ArrayList<Serializable>(selectionRows.size());
            for (EntityManagerRow row : selectionRows) {
                selection.add(row.getEntity());
            }
            return selection;
        }
        return null;
    }

    @Override
    public List<EntityManagerRow> getSelectionData() {
        return this.resultView.getSelection();
    }

    @Override
    public abstract void performQuery();

    @Override
    public void cleanup() {
        if (null != this.mediator) {
            this.mediator.close();
        }
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public String getTitle() {
        return this.config.getTitle();
    }

    @Override
    public JComponent getUI() {
        this.prepareActions();
        if (this.form == null) {
            JComponent navigatorForm = this.navigatorView != null ? this.navigatorView.getUI() : null;
            JComponent filterForm = this.filterView != null ? this.filterView.getUI() : null;
            this.form = new FaultPanel(i18n, filterForm, this.resultView.getUI(), navigatorForm);
            this.initializeSeverityListener();
            final SelectorListOneElementComponent selectorFilters = this.form.getSelectorFilters();
            selectorFilters.addPropertyChangeListener("value", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    boolean eventHistoryContext = EventAbstractView.this.config instanceof EventHistoryManagerConfig;
                    String filterString = "";
                    if (selectorFilters.getValue() == null) {
                        EventAbstractView.this.eventFilter = null;
                    } else if (!selectorFilters.getSelectorView().getSelection().isEmpty()) {
                        EventAbstractView.this.eventFilter = (EventFilter)selectorFilters.getSelectorView().getSelection().get(0);
                    }
                    EventAbstractView.this.filterHasChanged = true;
                    EventAbstractView.this.sqlExpression = EventAbstractView.this.eventFilter != null ? ((filterString = FilterUtil.formatFilter(EventAbstractView.this.eventFilter, eventHistoryContext)) != null ? " (" + filterString + ") " : null) : null;
                    selectorFilters.getListSelectedValues().setToolTipText(FilterUtil.formatFilterToolTip(EventAbstractView.this.eventFilter, eventHistoryContext));
                    if (eventHistoryContext) {
                        EventAbstractView.this.setSeveritiesInHelper(EventHistoryManagerConfig.getHelper());
                        EventAbstractView.this.performQuery();
                    } else {
                        if (EventAbstractView.this.eventFilter != null) {
                            Set<EvtFilterEventCategory> categories = EventAbstractView.this.eventFilter.getEventCategories();
                            Set<EvtFilterSeverity> severities = EventAbstractView.this.eventFilter.getSeverities();
                            if (categories == null || categories.isEmpty()) {
                                EventAbstractView.this.form.enableSeverities(true);
                            } else if (severities == null || severities.isEmpty()) {
                                EventAbstractView.this.form.enableSeverities(true);
                            } else {
                                EventAbstractView.this.form.enableSeverities(severities.iterator());
                            }
                        } else {
                            EventAbstractView.this.form.enableSeverities(true);
                        }
                        EventAbstractView.this.setSeveritiesInHelper(EventMonitorManagerConfig.getHelper());
                        EventAbstractView.this.saveSettings();
                    }
                    if (eventHistoryContext) {
                        EventHistoryManagerConfig.getHelper().setCurrentFilter(EventAbstractView.this.eventFilter);
                    } else {
                        EventMonitorManagerConfig.getHelper().setCurrentFilter(EventAbstractView.this.eventFilter);
                    }
                }
            });
            this.loadSettings();
            this.form.getBtnHelp().setAction(new HelpAction(this.config.getHelpTopic()));
            this.form.getBtnHelp().setText("");
        }
        this.addActionsMenu();
        if (!this.isInitialized) {
            this.initUI();
            this.isInitialized = true;
        }
        return this.form;
    }

    protected void addActionsMenu() {
        Vector<JMenuItem> menuItems = new Vector<JMenuItem>();
        int category = 0;
        for (ManagerAction action : this.config.getDeclaredActions()) {
            String name;
            if (0 == category) {
                category = action.getCategory();
            } else if (category != action.getCategory()) {
                category = action.getCategory();
                menuItems.add(null);
            }
            if ((name = action.getName()) == null) continue;
            menuItems.add(new JMenuItem(this.declaredActions.get(action.getName())));
        }
        this.resultView.updateContextMenu(menuItems);
        this.resultView.setDefaultActionListener(this.declaredActions.get("##Default##"));
    }

    private void initializeSeverityListener() {
        if (this.config instanceof EventMonitorManagerConfig) {
            EventManagerConfigHelper helper = EventMonitorManagerConfig.getHelper();
            this.setSeveritiesInHelper(helper);
        } else {
            EventManagerConfigHelper helper = EventHistoryManagerConfig.getHelper();
            this.setSeveritiesInHelper(helper);
        }
        this.setActionListener(this.form.getChkCritical(), Severity.Critical.value());
        this.setActionListener(this.form.getChkMajor(), Severity.Major.value());
        this.setActionListener(this.form.getChkMinor(), Severity.Minor.value());
        this.setActionListener(this.form.getChkWarning(), Severity.Warning.value());
        this.setActionListener(this.form.getChkIndeterminate(), Severity.Indeterminate.value());
        this.setActionListener(this.form.getChkCleared(), Severity.Cleared.value());
        this.setActionListener(this.form.getChkOther(), Severity.Other.value());
    }

    private void setActionListener(final JCheckBoxMenuItem chkBox, final int value) {
        chkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (EventAbstractView.this.config instanceof EventMonitorManagerConfig) {
                    EventMonitorManagerConfig.getHelper().setChkSeverities(value, chkBox.isSelected());
                } else if (EventAbstractView.this.config instanceof EventHistoryManagerConfig) {
                    EventHistoryManagerConfig.getHelper().setChkSeverities(value, chkBox.isSelected());
                    EventAbstractView.this.form.setCountersChkBoxes(EventAbstractView.this.resultView.getCounters(), chkBox);
                }
                EventAbstractView.this.notifyQuery();
            }
        });
    }

    private void setSeveritiesInHelper(EventManagerConfigHelper helper) {
        helper.setChkSeverities(Severity.Critical.value(), this.form.getChkCritical().isSelected());
        helper.setChkSeverities(Severity.Major.value(), this.form.getChkMajor().isSelected());
        helper.setChkSeverities(Severity.Minor.value(), this.form.getChkMinor().isSelected());
        helper.setChkSeverities(Severity.Warning.value(), this.form.getChkWarning().isSelected());
        helper.setChkSeverities(Severity.Indeterminate.value(), this.form.getChkIndeterminate().isSelected());
        helper.setChkSeverities(Severity.Cleared.value(), this.form.getChkCleared().isSelected());
        helper.setChkSeverities(Severity.Other.value(), this.form.getChkOther().isSelected());
    }

    private void notifyQuery() {
        this.filterHasChanged = true;
        EventManagerRowTableModel model = (EventManagerRowTableModel)this.resultView.getTableModel();
        if (this.config instanceof EventHistoryManagerConfig) {
            model.fireSeveritySelectionChanged(model.getRows());
        }
    }

    public abstract void initUI();

    protected void prepareActions() {
        List<ManagerAction> declaredManagerActions = this.config.getDeclaredActions();
        this.declaredActions = new HashMap();
        for (ManagerAction managerAction : declaredManagerActions) {
            this.declaredActions.put(managerAction.getName(), new ManagerActionAdapter(managerAction, this));
        }
        if (null != this.config.getDefaultAction()) {
            this.declaredActions.put("##Default##", new ManagerActionAdapter(this.config.getDefaultAction(), this));
        }
    }

    public void updateCounters(Event event, int i) {
        switch (Severity.fromValue(event.getEventSeverity())) {
            case Critical: {
                this.counters[6] = this.counters[6] + i;
                break;
            }
            case Major: {
                this.counters[5] = this.counters[5] + i;
                break;
            }
            case Minor: {
                this.counters[4] = this.counters[4] + i;
                break;
            }
            case Warning: {
                this.counters[3] = this.counters[3] + i;
                break;
            }
            case Indeterminate: {
                this.counters[2] = this.counters[2] + i;
                break;
            }
            case Cleared: {
                this.counters[1] = this.counters[1] + i;
                break;
            }
            default: {
                this.counters[0] = this.counters[0] + i;
            }
        }
    }

    public EntityManagerConfig getConfig() {
        return this.config;
    }

    @Override
    public void selectionChanged(List<EntityManagerRow> selection) {
        if (this.declaredActions != null) {
            ArrayList<Serializable> selectedEntities = null;
            if (null != selection) {
                selectedEntities = new ArrayList<Serializable>(selection.size());
                for (EntityManagerRow row : selection) {
                    try {
                        selectedEntities.add(row.getEntity());
                    }
                    catch (NullPointerException npe) {}
                }
            }
            for (ManagerActionAdapter action : this.declaredActions.values()) {
                action.selectionChanged(selectedEntities);
            }
        }
    }

    public EventManagerResultsView getResultView() {
        return this.resultView;
    }

    protected abstract void loadSettings();

    protected abstract void saveSettings();

    public static void loadColumnOrder(EventManagerConfigHelper helper, boolean isMonitor) {
        Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
        String property = settings.getProperty(isMonitor ? "EventMonitorColumnOrder" : "EventHistoryColumnOrder", null);
        if (property != null) {
            String[] columnOrder = property.split(",");
            for (int i = 0; i < columnOrder.length; ++i) {
                helper.put(i, columnOrder[i]);
            }
        }
    }
}

