/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.commands;

import com.bwanms.client.gui.fault.commands.CommandsEditorPanel;
import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.model.fault.Command;
import com.bwanms.model.fault.CommandArg;
import com.bwanms.ui.components.ListItem;
import com.bwanms.util.FormUtil;
import com.bwanms.util.fault.CommandUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandsView
extends AbstractBindedEditorView<Command> {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(CommandsView.class);
    private CommandsEditorPanel panel = new CommandsEditorPanel();

    @Override
    public String getApplicationPermission() {
        return null;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.fm.script_command_editor";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("CommandEditor");
    }

    @Override
    public JComponent getUI() {
        return this.panel;
    }

    @Override
    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add(new DefaultBinder(this.getUI(), this.entity).add(new JTextFieldBinding("txtCommandName", "name", i18n.translateString("CommandName"))));
        binders.add(new DefaultBinder(this.getUI(), this.entity).add(new JTextFieldBinding("txtScriptName", "scriptName", i18n.translateString("ScriptName"))));
        binders.add(new DefaultBinder(this.getUI(), this.entity).add(new JTextFieldBinding("txtScriptPath", "scriptPath", i18n.translateString("ScriptPath"))));
        return binders;
    }

    @Override
    public List<InvalidValue> configureEntity(Command entity) {
        entity.setName(FormUtil.getText(this.panel.getTxtCommandName()));
        entity.setDescription(FormUtil.getText(this.panel.getTxtDescription()));
        entity.setScriptName(FormUtil.getText(this.panel.getTxtScriptName()));
        entity.setScriptPath(FormUtil.getText(this.panel.getTxtScriptPath()));
        entity.getCommandArg().clear();
        for (int i = 0; i < this.panel.getListCommandArgsModel().size(); ++i) {
            ListItem listItem = (ListItem)this.panel.getListCommandArgsModel().get(i);
            CommandArg cmdArg = (CommandArg)listItem.getValue();
            cmdArg.setCommand(entity);
            entity.getCommandArg().add(cmdArg);
        }
        return super.configureEntity(entity);
    }

    @Override
    public void fillUI(Command entity) {
        this.panel.getTxtCommandName().setText(entity.getName());
        this.panel.getTxtDescription().setText(entity.getDescription());
        this.panel.getTxtScriptName().setText(entity.getScriptName());
        this.panel.getTxtScriptPath().setText(entity.getScriptPath());
        for (CommandArg arg : entity.getCommandArg()) {
            if (arg.getTextQualifier() == null) {
                this.panel.getListCommandArgsModel().addElement(new ListItem(arg, arg.getArgOption() + " " + CommandUtil.getArgValue(arg)));
                continue;
            }
            this.panel.getListCommandArgsModel().addElement(new ListItem(arg, arg.getArgOption() + " " + arg.getTextQualifier() + CommandUtil.getArgValue(arg) + arg.getTextQualifier()));
        }
        super.fillUI(entity);
    }
}

