/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.commands;

import com.bwanms.client.gui.fault.commands.CommandsEditorContainer;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.DefaultRowCreator;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.SimpleEntityQueryStrategy;
import com.bwanms.model.fault.Command;
import com.bwanms.security.Security;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandsManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(CommandsManagerConfig.class);
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(CommandsManagerConfig.class);
    public static final Internationalizer i18nTask = Internationalizer.getInternationalizer("com.bwanms.tasks");
    private static String[] columnNames = new String[]{"Name", "Description"};
    private static String[] columnAttribNames = new String[]{"name", "description"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public CommandsManagerConfig() {
        for (int i = 0; i < columnNames.length; ++i) {
            this.columns.add(new EntityManagerColumn(columnNames[i], columnAttribNames[i], i18n.translateString(columnNames[i]), new EntityManagerRowDisplayComparator(i)));
        }
        this.filterCriteria = new Vector();
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false));
        this.entityRowProvider = new CommandManagerRowProvider(CommandsManagerConfig.getColumnAttributeNames(this.columns));
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new CommandManagerAction("New", 1));
        this.defaultAction = new CommandManagerAction("Edit", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new CommandManagerAction("Delete", 1));
    }

    @Override
    protected String getBaseName() {
        return Command.class.getName();
    }

    @Override
    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    @Override
    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    @Override
    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    @Override
    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    @Override
    public String getHelpTopic() {
        return "bwanms.fm.script_command_manager";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("CommandsManager");
    }

    @Override
    public EntityQueryStrategy getQueryStrategy() {
        return new SimpleEntityQueryStrategy();
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        if (this.declaredActions.get(0).getName().equals("New")) {
            this.declaredActions.clear();
        }
        this.defaultAction = new CommandManagerAction("Select", 1, selectorListener);
        this.declaredActions.add(this.defaultAction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandManagerRowProvider
    extends DefaultRowCreator {
        public CommandManagerRowProvider(List<String> attributes) {
            super(attributes);
        }

        @Override
        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List<String> ret = super.getDisplayValues(entityRow);
            return ret;
        }

        @Override
        public String readEntityId(Serializable entity) {
            return String.valueOf(((Command)entity).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public CommandManagerAction(String name, int category) {
            this(name, category, null);
        }

        public CommandManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.name = name;
            this.category = category;
            this.selectorListener = selectorListener;
        }

        @Override
        public void performAction(final ManagerView manager) {
            final List<Serializable> selection = manager.getSelection();
            if ("New".equals(this.name)) {
                try {
                    Command command = new Command();
                    new CommandsEditorContainer(command, (EntityChangeListener<Serializable>)((EntityChangeListener)((Object)manager)));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("Edit".equals(this.name) && 1 == selection.size()) {
                Command command = (Command)selection.get(0);
                try {
                    new CommandsEditorContainer(command, (EntityChangeListener<Serializable>)((EntityChangeListener)((Object)manager)));
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow(manager.getUI(), ex.getMessage());
                }
            } else if ("Delete".equals(this.name) && !selection.isEmpty()) {
                if (!MessageBox.WarnConfirm.showResult(manager.getUI(), null, i18n.translateString("DeleteConfirmationTitle"))) {
                    return;
                }
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("DeleteTitle");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selection.size();
                    }

                    public void run() {
                        long progress = 0L;
                        EntityManagerService commandService = ServiceRegistry.getEntityManagerService();
                        EntityChangeListener listener = null;
                        if (manager instanceof EntityChangeListener) {
                            listener = (EntityChangeListener)((Object)manager);
                        }
                        for (Serializable row : selection) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            Command command = (Command)row;
                            String commandId = command.getName();
                            String message = i18n.translateString("DeletingCommand", commandId);
                            this.monitor.updateProgress(progress, message);
                            try {
                                commandService.delete(command);
                                ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), "EntityDelete", "ScriptCommandManager", command.getName(), command.getClass().getName());
                                if (listener != null) {
                                    listener.entityRemoved(row);
                                }
                                this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", commandId));
                                log.debug((Object)("Deleted command: " + commandId));
                            }
                            catch (ServerValidationException e) {
                                this.monitor.logMessage(i18n.translateString("DeletingError", commandId, e.getInvalidValues().get(0).getMessage()));
                                log.debug((Object)"Failed to delete command.", (Throwable)e);
                            }
                            catch (ServiceException e) {
                                this.monitor.logMessage(e.getMessage());
                                log.debug((Object)"Failed to delete command.", (Throwable)e);
                            }
                            catch (Exception e) {
                                this.monitor.logMessage(i18n.translateString("DeletingError", commandId, e.getMessage()));
                                log.debug((Object)"Failed to delete command.", (Throwable)e);
                            }
                            this.monitor.updateProgress(++progress, message);
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog(manager.getUI(), deleteOperation);
            } else if ("Select".equals(this.name) && 1 == selection.size()) {
                this.selectorListener.entitiesSelected(manager.getSelection());
            }
        }

        @Override
        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (!this.name.equals("New")) {
                if (this.name.equals("Edit")) {
                    return 1 == selectionSize;
                }
                if (this.name.equals("Delete")) {
                    return selectionSize > 0;
                }
                if (this.name.equals("Select")) {
                    return 1 == selectionSize;
                }
            }
            return true;
        }
    }
}

