/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault.commands;

import com.bwanms.client.gui.fault.commands.CommandsView;
import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.model.Contact;
import com.bwanms.model.fault.Command;
import com.bwanms.security.Security;
import com.bwanms.services.EntityAlreadyExistsException;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.ServerValidationException;
import java.io.Serializable;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandsEditorContainer
extends EntityEditorContainer<Command> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(CommandsEditorContainer.class);

    public CommandsEditorContainer(Command entity, EntityChangeListener<Serializable> listener) throws ServiceException {
        super(entity, listener);
    }

    @Override
    protected String getEntityClass() {
        return i18n.translateString(Contact.class.getName());
    }

    @Override
    protected Command loadEntity(Command entity) throws ServiceException {
        return super.loadEntity(entity);
    }

    @Override
    public String getEntityId() {
        return String.valueOf(((Command)this.getEntity()).getId());
    }

    @Override
    protected String getEntityName() {
        return this.getEntity() != null ? ((Command)this.getEntity()).getName() : "null";
    }

    @Override
    public String getTitle() {
        return i18n.translateString("CommandsEditor");
    }

    @Override
    protected EditorView<Command> initView() {
        return new CommandsView();
    }

    @Override
    protected void saveEntity() throws ServiceException {
        try {
            super.saveEntity();
            ServiceRegistry.getAuditLogsService().addAuditLogEntryInCurrentSession(Security.getSecurity().getCurrentUserId(), this.entityIsNew ? "EntityCreate" : "EntityChange", "ScriptCommandManager", ((Command)this.entity).getName(), ((Command)this.entity).getClass().getName());
        }
        catch (EntityAlreadyExistsException e) {
            this.invalidValues.add(new InvalidValue(i18n.translateString("CommandWithTheSameNameIsAlreadyDefined"), Command.class, i18n.translateString("Name"), (Object)e.getMessage(), null));
            throw new ServerValidationException(this.invalidValues);
        }
    }
}

