/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.client.gui.fault;

import com.bwanms.util.SystemPropertyUtil;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ColorSchema {
    Standard{

        public Color critical() {
            return Color.red;
        }

        public Color major() {
            return lightOrange;
        }

        public Color minor() {
            return Color.yellow;
        }

        public Color warning() {
            return paleBlue;
        }

        public Color indeterminate() {
            return lavender;
        }

        public Color cleared() {
            return Color.green;
        }

        public Color other() {
            return Color.white;
        }

        public Color selected() {
            return indigo;
        }
    }
    ,
    Dorado{

        public Color critical() {
            return Color.red;
        }

        public Color major() {
            return Color.orange;
        }

        public Color minor() {
            return Color.yellow;
        }

        public Color warning() {
            return Color.blue;
        }

        public Color indeterminate() {
            return violet;
        }

        public Color cleared() {
            return Color.white;
        }

        public Color other() {
            return Color.green;
        }

        public Color selected() {
            return Color.gray;
        }
    }
    ,
    Custom{

        public Color critical() {
            return customRed1;
        }

        public Color major() {
            return gold;
        }

        public Color minor() {
            return Color.yellow;
        }

        public Color warning() {
            return paleBlue;
        }

        public Color indeterminate() {
            return lavender;
        }

        public Color cleared() {
            return lime;
        }

        public Color other() {
            return Color.white;
        }

        public Color selected() {
            return blueGray;
        }
    };

    private static ColorSchema activeSchema;
    private static Color customRed1;
    private static Color lightOrange;
    private static Color gold;
    private static Color lime;
    private static Color lavender;
    private static Color lightTurquoise;
    private static Color indigo;
    private static Color violet;
    private static Color paleBlue;
    private static Color blueGray;

    public abstract Color critical();

    public abstract Color major();

    public abstract Color minor();

    public abstract Color warning();

    public abstract Color indeterminate();

    public abstract Color cleared();

    public abstract Color other();

    public abstract Color selected();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorSchema getActiveSchema() {
        if (activeSchema == null) {
            try {
                activeSchema = ColorSchema.valueOf(SystemPropertyUtil.getString("com.bwanms.client.fault.colorSchema", Standard.name()));
            }
            catch (Exception e) {
                activeSchema = Standard;
            }
            finally {
                if (activeSchema == null) {
                    activeSchema = Standard;
                }
            }
        }
        return activeSchema;
    }

    public static void setActiveSchema(ColorSchema colorSchema) {
        activeSchema = colorSchema;
    }

    static {
        activeSchema = null;
        customRed1 = new Color(230, 0, 0);
        lightOrange = new Color(255, 153, 0);
        gold = new Color(255, 204, 0);
        lime = new Color(153, 204, 0);
        lavender = new Color(204, 153, 255);
        lightTurquoise = new Color(204, 255, 255);
        indigo = new Color(51, 51, 153);
        violet = new Color(128, 0, 128);
        paleBlue = new Color(153, 204, 255);
        blueGray = new Color(102, 102, 153);
    }
}

