/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.be.servermaintenance;

import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.be.servermaintenance.IServerMaintenance;
import com.bwanms.be.servermaintenance.ServerMaintenanceImpl;
import com.bwanms.be.servermaintenance.ServerMaintenanceMBean;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.ejb.MBeanProxyFactory;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.system.ServiceMBeanSupport;

public class ServerMaintenance
extends ServiceMBeanSupport
implements ServerMaintenanceMBean {
    private static final Logger log = Logger.getLogger(ServerMaintenance.class);
    private static final int DB_CONNECTION_LOST = 1;
    private static final long DEFAULT_TIMEOUT = 10L;
    private IServerMaintenance delegate;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            return new Thread(r, "DB CHECKING SCHEDULER");
        }
    });

    public ServerMaintenance() {
        this.delegate = new ServerMaintenanceImpl();
    }

    protected void startService() throws Exception {
        Calendar startTime = Calendar.getInstance();
        startTime.setTimeInMillis(System.currentTimeMillis());
        this.delegate.setStartTime(startTime);
        this.delegate.setServerUp(true);
        PlatformFactory.getApplicationLayerPlatform().getLookup().bind("bwanms/server/ServerMaintenance", MBeanProxyFactory.createProxy(IServerMaintenance.class, this.getServiceName()));
        log.info((Object)"AStar server is up");
        log.info((Object)String.format("AStar start time: %s", new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date(startTime.getTimeInMillis()))));
        this.startDbCheckingScheduler();
    }

    private void startDbCheckingScheduler() {
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            public void run() {
                ServerMaintenance.this.checkDb();
            }
        }, 0L, this.getDbCheckInterval(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDb() {
        Connection conn = null;
        try {
            conn = JDBCConnectionProvider.getConnection();
        }
        catch (Throwable ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("=================================================\n");
            msg.append("=================================================\n");
            msg.append("[DB Keep Alive Service] Communication failed - AlvariSTAR  Database Astar did not respond to the keep alive test.");
            msg.append("=================================================\n");
            msg.append("=================================================\n");
            log.error((Object)msg.toString(), ex);
            System.exit(1);
        }
        finally {
            JDBCConnectionProvider.close(conn);
        }
    }

    protected void stopService() throws Exception {
        PlatformFactory.getApplicationLayerPlatform().getLookup().unbind("bwanms/server/ServerMaintenance");
        this.delegate.setServerUp(false);
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            this.scheduler.shutdownNow();
        }
    }

    public Calendar getStartTime() {
        return this.delegate.getStartTime();
    }

    public boolean isServerUp() {
        return this.delegate.isServerUp();
    }

    public void setServerUp(boolean serverUp) {
    }

    public void setStartTime(Calendar startTime) {
    }

    public long getDbCheckInterval() {
        return this.delegate.getDbCheckInterval();
    }

    public void setDbCheckInterval(long dbCheckInterval) {
        this.delegate.setDbCheckInterval(dbCheckInterval);
    }

    public long getJVMFreeMemory() {
        return this.delegate.getJVMFreeMemory();
    }

    public long getJVMMaxMemory() {
        return this.delegate.getJVMMaxMemory();
    }

    public long getJVMTotalMemory() {
        return this.delegate.getJVMTotalMemory();
    }

    public void setJVMFreeMemory(long JVMFreeMemory) {
    }

    public void setJVMMaxMemory(long JVMMaxMemory) {
    }

    public void setJVMTotalMemory(long JVMTotalMemory) {
    }
}

