/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.be.registries.local;

import com.bwanms.be.Queue;
import com.bwanms.be.QueueI;
import com.bwanms.be.QueueSelector;
import com.bwanms.be.registries.QueueRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueRegistryLocalImpl
implements QueueRegistry {
    private Map<String, Queue> regQueue = new HashMap<String, Queue>();
    private HashMap<String, Class> classes = new HashMap();
    private HashMap<QueueRegistry.Key, QueueI> newQueues = new HashMap();
    private Lock lock = new ReentrantLock();

    @Override
    public Queue getQueue(String queueId) {
        return this.regQueue.get(queueId);
    }

    @Override
    public void register(Queue queue, String queueId) {
        this.regQueue.put(queueId, queue);
    }

    @Override
    public void unregister(String queueId) {
        this.regQueue.remove(queueId);
    }

    @Override
    public boolean isRegistered(String queueId) {
        return this.regQueue.containsKey(queueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <F> QueueI<F> getNewQueue(QueueRegistry.Key<F> key) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter key can't be null");
        }
        this.lock.lock();
        try {
            if (this.classes.containsKey(key.getKey())) {
                if (this.classes.get(key.getKey()).equals(key.getClazz())) {
                    QueueI queueI = this.newQueues.get(key);
                    return queueI;
                }
                throw new IllegalArgumentException("For key " + key.getKey() + " it was registered parameter " + this.classes.get(key.getKey()) + " not " + key.getClazz());
            }
            QueueI<F> newQueue = QueueSelector.getNewQueue(key.getClazz());
            this.registerNewQueue(key, newQueue);
            QueueI<F> queueI = newQueue;
            return queueI;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> boolean isNewQueueRegistered(QueueRegistry.Key<E> key) {
        if (key == null) {
            return false;
        }
        this.lock.lock();
        try {
            if (this.classes.containsKey(key.getKey())) {
                if (!this.classes.get(key.getKey()).equals(key.getClazz())) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.newQueues.get(key) != null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> QueueI<E> registerNewQueue(QueueRegistry.Key<E> key, QueueI<E> value) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter key can't be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value can't be null");
        }
        this.lock.lock();
        try {
            if (this.classes.containsKey(key.getKey())) {
                if (!this.classes.get(key.getKey()).equals(key.getClazz())) {
                    throw new IllegalArgumentException("Illegal parameter " + key.getClazz() + ", already registered " + key.getKey() + "=" + this.classes.get(key.getKey()));
                }
            } else {
                this.classes.put(key.getKey(), key.getClazz());
            }
            QueueI<E> queueI = this.newQueues.put(key, value);
            return queueI;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> void unregisterNewQueue(QueueRegistry.Key<E> key) {
        if (key == null) {
            return;
        }
        this.lock.lock();
        try {
            this.classes.remove(key.getKey());
            this.newQueues.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }
}

