/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.be.connection;

import com.bwanms.backend.model.Stack;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.ServiceException;
import com.bwanms.util.PlatformConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.hibernate.connection.ConnectionProvider;

public class JDBCConnectionProvider {
    private static final Logger log = Logger.getLogger(JDBCConnectionProvider.class);
    private static volatile AtomicInteger index = new AtomicInteger();

    public static Connection getConnection() throws ServiceException {
        return JDBCConnectionProvider.createInternalConnection();
    }

    private static void saveStack(Connection con, String operation, long indexCon) throws ServiceException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        new Exception("Stack trace").printStackTrace(ps);
        Stack stack = new Stack();
        if ("OPEN".equals(operation)) {
            stack.setCounter(index.incrementAndGet());
        } else {
            stack.setCounter(index.decrementAndGet());
        }
        stack.setIndexStack(indexCon);
        stack.setOperation(operation);
        stack.setStack(baos.toString());
        stack.setThread(Thread.currentThread().toString());
        stack.setTimeStack(System.currentTimeMillis());
        StackDAO.saveStack(con, stack);
    }

    private static Connection createInternalConnection() throws ServiceException {
        if (PlatformConfiguration.isRemotePlatform()) {
            String name = "java:jdbc/AStar";
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(name);
                Connection con = ds.getConnection();
                if (con.getAutoCommit()) {
                    con.setAutoCommit(false);
                }
                return con;
            }
            catch (NamingException e) {
                e.printStackTrace();
                throw new ServiceException("Unable to locate SessionFactory in JNDI under name [" + name + "]", e);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ServiceException("Unable to open a connection on datasource with JNDI name [" + name + "]", e);
            }
        }
        ConnectionProvider ds = (ConnectionProvider)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/InternalDatasource");
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ServiceException("Unable to open a connection on internal datasource [bwanms/InternalDatasource]", e);
        }
    }

    public static void close(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)("Can't close JDBC connection " + con));
        }
        catch (Exception e) {
            log.error((Object)"Can't save stack connection ", (Throwable)e);
        }
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)("Can't close ResultSet " + rs));
        }
    }

    public static void close(Statement stat) {
        try {
            if (stat != null) {
                stat.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)("Can't close Statement " + stat));
        }
    }

    private static class StackDAO {
        private StackDAO() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void saveStack(Connection conn, Stack stack) {
            String insert = "insert into BwAdminStacktrace (stack, thread,indexStack, counter, timeStack, operation) values(?,? ,? ,? ,? ,? )";
            PreparedStatement stat = null;
            try {
                stat = conn.prepareStatement(insert);
                stat.setString(1, stack.getStack());
                stat.setString(2, stack.getThread());
                stat.setLong(3, stack.getIndexStack());
                stat.setLong(4, stack.getCounter());
                stat.setLong(5, stack.getTimeStack());
                stat.setString(6, stack.getOperation());
                stat.executeUpdate();
                conn.commit();
            }
            catch (SQLException e) {
                System.out.println("Catch SQL Exception: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                if (stat != null) {
                    try {
                        stat.close();
                    }
                    catch (SQLException e) {
                        System.out.println("Can't close JDBC statement");
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

