/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.be.connection;

import com.bwanms.platform.PlatformFactory;
import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.PoolConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;

public class InternalConnectionProvider
implements ConnectionProvider {
    public static final String DATASOURCE_NAME = "bwanms/InternalDatasource";
    private DataSource ds;
    private Integer isolation;
    private boolean autocommit;
    private static final Log log = LogFactory.getLog(InternalConnectionProvider.class);

    public Connection getConnection() throws SQLException {
        Connection c = this.ds.getConnection();
        if (this.isolation != null) {
            c.setTransactionIsolation(this.isolation);
        }
        if (c.getAutoCommit() != this.autocommit) {
            c.setAutoCommit(this.autocommit);
        }
        return c;
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void configure(Properties props) throws HibernateException {
        String jdbcDriverClass = props.getProperty("hibernate.connection.driver_class");
        String jdbcUrl = props.getProperty("hibernate.connection.url");
        Properties connectionProps = ConnectionProviderFactory.getConnectionProperties((Properties)props);
        log.info((Object)("C3P0 using driver: " + jdbcDriverClass + " at URL: " + jdbcUrl));
        log.info((Object)("Connection properties: " + PropertiesHelper.maskOut((Properties)connectionProps, (String)"password")));
        this.autocommit = PropertiesHelper.getBoolean((String)"hibernate.connection.autocommit", (Properties)props);
        log.info((Object)("autocommit mode: " + this.autocommit));
        if (jdbcDriverClass == null) {
            log.warn((Object)"No JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(jdbcDriverClass);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    ReflectHelper.classForName((String)jdbcDriverClass);
                }
                catch (ClassNotFoundException e) {
                    String msg = "JDBC Driver class not found: " + jdbcDriverClass;
                    log.fatal((Object)msg, (Throwable)e);
                    throw new HibernateException(msg, (Throwable)e);
                }
            }
        }
        try {
            int minPoolSize = PropertiesHelper.getInt((String)"hibernate.c3p0.min_size", (Properties)props, (int)1);
            int maxPoolSize = PropertiesHelper.getInt((String)"hibernate.c3p0.max_size", (Properties)props, (int)100);
            int maxIdleTime = PropertiesHelper.getInt((String)"hibernate.c3p0.timeout", (Properties)props, (int)0);
            int maxStatements = PropertiesHelper.getInt((String)"hibernate.c3p0.max_statements", (Properties)props, (int)0);
            int acquireIncrement = PropertiesHelper.getInt((String)"hibernate.c3p0.acquire_increment", (Properties)props, (int)1);
            int idleTestPeriod = PropertiesHelper.getInt((String)"hibernate.c3p0.idle_test_period", (Properties)props, (int)0);
            PoolConfig pcfg = new PoolConfig();
            pcfg.setInitialPoolSize(minPoolSize);
            pcfg.setMinPoolSize(minPoolSize);
            pcfg.setMaxPoolSize(maxPoolSize);
            pcfg.setAcquireIncrement(acquireIncrement);
            pcfg.setMaxIdleTime(maxIdleTime);
            pcfg.setMaxStatements(maxStatements);
            pcfg.setIdleConnectionTestPeriod(idleTestPeriod);
            DataSource unpooled = DataSources.unpooledDataSource((String)jdbcUrl, (Properties)connectionProps);
            this.ds = DataSources.pooledDataSource((DataSource)unpooled, (PoolConfig)pcfg);
            PlatformFactory.getApplicationLayerPlatform().getLookup().bind(DATASOURCE_NAME, this);
            log.info((Object)"Binded conection provider as bwanms/InternalDatasource");
        }
        catch (Exception e) {
            log.fatal((Object)"could not instantiate C3P0 connection pool", (Throwable)e);
            throw new HibernateException("Could not instantiate C3P0 connection pool", (Throwable)e);
        }
        String i = props.getProperty("hibernate.connection.isolation");
        if (i == null) {
            this.isolation = null;
        } else {
            this.isolation = new Integer(i);
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString((int)this.isolation)));
        }
    }

    public void close() {
        try {
            PlatformFactory.getApplicationLayerPlatform().getLookup().unbind(DATASOURCE_NAME);
            DataSources.destroy((DataSource)this.ds);
        }
        catch (SQLException sqle) {
            log.warn((Object)"could not destroy C3P0 connection pool", (Throwable)sqle);
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

