/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.be;

import com.bwanms.be.QueueI;
import com.bwanms.be.QueueIListener;
import com.bwanms.be.QueueSelector;
import com.bwanms.be.registries.QueueRegister;
import com.bwanms.be.registries.QueueRegistry;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueHelper {
    public static void pushMsg(Object msg, String msgId) {
        if (!QueueRegister.getQueueRegistry().isRegistered(msgId)) {
            QueueRegister.getQueueRegistry().register(QueueSelector.select(), msgId);
        }
        QueueRegister.getQueueRegistry().getQueue(msgId).put(msg);
    }

    public static Object pullMsg(String msgId) {
        if (!QueueRegister.getQueueRegistry().isRegistered(msgId)) {
            QueueRegister.getQueueRegistry().register(QueueSelector.select(), msgId);
        }
        Object take = QueueRegister.getQueueRegistry().getQueue(msgId).take();
        return take;
    }

    public static <E> void add(E object, String queueId, Class<E> clazz) {
        QueueHelper.getQueueI(queueId, clazz).add(object);
    }

    public static <E> void add(Collection<E> collection, String queueId, Class<E> clazz) {
        QueueHelper.getQueueI(queueId, clazz).addAll(collection);
    }

    public static <E> void registerQueueIListener(QueueIListener listener, String queueId, Class<E> clazz) {
        QueueHelper.getQueueI(queueId, clazz).setQueueListener(listener);
    }

    public static <E> QueueI<E> getQueueI(String queueId, Class<E> clazz) {
        QueueRegistry.Key<E> key = new QueueRegistry.Key<E>(queueId, clazz);
        return QueueRegister.getQueueRegistry().getNewQueue(key);
    }
}

