/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.task;

import com.bwanms.backend.task.CSVRowFormatter;
import com.bwanms.backend.task.CSVUtil;
import com.bwanms.gui.Internationalizer;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.AlarmType;
import com.bwanms.model.fault.constants.ConfigChangeType;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.EventProtocol;
import com.bwanms.model.fault.constants.ProbableCause;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.model.fault.constants.StateChangeType;
import com.bwanms.model.fault.constants.SysEventType;
import com.bwanms.util.PluginUtil;
import com.bwanms.util.fault.EventUtil;
import com.bwanms.util.fault.FilterUtil;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;

public class EventHistoryRowFormatter
implements CSVRowFormatter {
    private static final Internationalizer i18nConstants = Internationalizer.getInternationalizer("com.bwanms.faultConstants");

    public String getColumnValue(ResultSet resultset, int columnIndex) throws SQLException, IOException {
        String columnName = resultset.getMetaData().getColumnName(columnIndex);
        Event.Property prop = Event.Property.fromColumnName(columnName);
        String result = "";
        if ("receiveTime".equalsIgnoreCase(columnName) || "eventTime".equalsIgnoreCase(columnName) || "ackTime".equalsIgnoreCase(columnName) || "clearTime".equalsIgnoreCase(columnName) || "lastUpdateTime".equalsIgnoreCase(columnName)) {
            long timestamp = resultset.getLong(columnIndex);
            result = timestamp == 0L ? "" : CSVUtil.TIMESTAMP_FORMATTER.format(new Date(timestamp));
        } else if ("eventCategory".equalsIgnoreCase(columnName)) {
            EventCategory category = EventCategory.fromValue(resultset.getByte(columnIndex));
            result = EventCategory.unexpectedValue.equals((Object)category) ? "" : i18nConstants.translateString(category.toString());
        } else if ("eventType".equalsIgnoreCase(columnName)) {
            EventCategory category = EventCategory.fromValue(resultset.getByte("eventCategory"));
            Enum eventType = null;
            switch (category) {
                case Alarm: {
                    eventType = AlarmType.fromValue(resultset.getInt(columnIndex));
                    break;
                }
                case StateChange: {
                    eventType = StateChangeType.fromValue(resultset.getInt(columnIndex));
                    break;
                }
                case SysEvent: {
                    eventType = SysEventType.fromValue(resultset.getInt(columnIndex));
                    break;
                }
                case ConfigChange: {
                    eventType = ConfigChangeType.fromValue(resultset.getInt(columnIndex));
                }
            }
            result = eventType == null || "unexpectedValue".equals(eventType.name()) ? "" : i18nConstants.translateString(eventType.toString());
        } else if ("eventSeverity".equalsIgnoreCase(columnName)) {
            Severity severity = Severity.fromValue(resultset.getInt(columnIndex));
            result = Severity.unexpectedValue.equals((Object)severity) ? "" : i18nConstants.translateString(severity.toString());
        } else if ("protocol".equalsIgnoreCase(columnName)) {
            EventProtocol protocol = EventProtocol.fromValue(resultset.getInt(columnIndex));
            result = EventProtocol.unexpectedValue.equals((Object)protocol) ? "" : i18nConstants.translateString(protocol.toString());
        } else if ("objectSeverity".equalsIgnoreCase(columnName)) {
            byte value = resultset.getByte(columnIndex);
            Severity severity = Severity.fromValue(value);
            result = value == 127 ? "" : (Severity.unexpectedValue.equals((Object)severity) ? "" : i18nConstants.translateString(severity.toString()));
        } else if ("probableCause".equalsIgnoreCase(columnName)) {
            int value = resultset.getInt(columnIndex);
            ProbableCause cause = ProbableCause.fromValue(value);
            result = value == Integer.MAX_VALUE ? "" : (ProbableCause.unexpectedValue.equals((Object)cause) ? "" : i18nConstants.translateString(cause.toString()));
        } else if ("equipmentType".equalsIgnoreCase(columnName)) {
            Enum<?> neType = PluginUtil.getNEType(resultset.getInt(columnIndex));
            result = neType == null ? "" : i18nConstants.translateString(neType.toString());
        } else if ("moType".equalsIgnoreCase(columnName)) {
            Enum<?> moType = PluginUtil.getMOType(FilterUtil.fixMoTypeValue(resultset.getByte(columnIndex)));
            result = moType == null ? "" : i18nConstants.translateString(moType.toString());
        } else if ("equipmentName".equalsIgnoreCase(columnName) || "locationName".equalsIgnoreCase(columnName) || "ackedBy".equalsIgnoreCase(columnName) || "clearedBy".equalsIgnoreCase(columnName) || "managedObject".equalsIgnoreCase(columnName) || "userClassifier".equalsIgnoreCase(columnName) || "moAlias".equalsIgnoreCase(columnName)) {
            String str = CSVUtil.getColumnValue(resultset, columnIndex);
            result = EventUtil.unescapeString(str);
        } else {
            result = "operationalState".equalsIgnoreCase(columnName) || "administrativeState".equalsIgnoreCase(columnName) || "alarmStatus".equalsIgnoreCase(columnName) || "availabilityStatus".equalsIgnoreCase(columnName) || "controlStatus".equalsIgnoreCase(columnName) || "lifecycleStatus".equalsIgnoreCase(columnName) || "proceduralStatus".equalsIgnoreCase(columnName) || "standbyStatus".equalsIgnoreCase(columnName) || "unknownStatus".equalsIgnoreCase(columnName) || "usageState".equalsIgnoreCase(columnName) ? "" : ("secondaryId".equalsIgnoreCase(columnName) || "deleted".equalsIgnoreCase(columnName) || "eventCause".equalsIgnoreCase(columnName) || "eventAdvisor".equalsIgnoreCase(columnName) ? "" : CSVUtil.getColumnValue(resultset, columnIndex));
        }
        return result;
    }

    public String getColumnName(ResultSetMetaData resultsetmetadata, int columnIndex) throws SQLException, IOException {
        String columnName = resultsetmetadata.getColumnName(columnIndex);
        Event.Property prop = Event.Property.fromColumnName(columnName);
        return prop == null ? columnName : i18nConstants.translateString(prop.toString());
    }
}

