/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.task;

import com.bwanms.backend.services.EventDAO;
import com.bwanms.backend.task.DatabaseAgingGenericTaskExecutor;
import com.bwanms.backend.task.EventHistoryRowFormatter;
import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.model.fault.Event;
import com.bwanms.model.task.DatabaseAgingGenericTask;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class EventHistoryDAPTaskExecutor
extends DatabaseAgingGenericTaskExecutor {
    private static final Logger log = Logger.getLogger(EventHistoryDAPTaskExecutor.class);
    private long threshold;
    private int chunkSize = 10000;
    private static final Event.Property[] excludeProps = new Event.Property[]{Event.Property.secondaryId, Event.Property.sequenceNumber, Event.Property.deleted, Event.Property.eventCause, Event.Property.eventAdvisor, Event.Property.proposedRepairAction, Event.Property.eventNotes, Event.Property.equipmentId, Event.Property.locationId, Event.Property.moType, Event.Property.moInstance, Event.Property.administrativeState, Event.Property.operationalState, Event.Property.usageState, Event.Property.alarmStatus, Event.Property.availabilityStatus, Event.Property.controlStatus, Event.Property.lifecycleStatus, Event.Property.proceduralStatus, Event.Property.standbyStatus, Event.Property.unknownStatus};
    static final int SECONDARY_THERESHOLD = 10000;

    public EventHistoryDAPTaskExecutor(DatabaseAgingGenericTask task) {
        super(task);
        this.threshold = task.getThreshold();
        this.formatter = new EventHistoryRowFormatter();
    }

    protected int performDelete() {
        int removedRows = -1;
        try {
            int updated;
            long time1 = System.currentTimeMillis();
            StringBuffer buffer = new StringBuffer();
            EventDAO.Database db = EventDAO.Database.getDB(null);
            if (EventDAO.Database.MySQL.equals((Object)db)) {
                buffer.append("DELETE FROM ").append(Event.Table.Historical.tableName());
                buffer.append(" WHERE ").append(Event.Property.deleted.columnName()).append("=1 AND ");
                buffer.append(Event.Property.receiveTime.columnName()).append(" <= ").append((Long)this.customData);
                buffer.append(" LIMIT ").append(this.chunkSize);
            } else if (EventDAO.Database.Oracle.equals((Object)db)) {
                buffer.append("DELETE FROM ").append(Event.Table.Historical.tableName());
                buffer.append(" WHERE ").append(Event.Property.deleted.columnName()).append("=1 AND ");
                buffer.append(Event.Property.receiveTime.columnName()).append(" <= ").append((Long)this.customData);
                buffer.append(" AND ROWNUM < ").append(this.chunkSize);
            } else {
                throw new Exception("unknown database");
            }
            String query = buffer.toString();
            removedRows = 0;
            while ((updated = EventDAO.executeUpdate(query)) > 0) {
                removedRows += updated;
            }
            long time2 = System.currentTimeMillis();
            log.info((Object)("Event History rows deleted: [" + removedRows + "] in " + (time2 - time1) + " millis"));
            this.performDeleteOnSecondary();
        }
        catch (Exception e) {
            log.error((Object)"Failed to delete rows on Event History", (Throwable)e);
        }
        return removedRows;
    }

    private boolean excludeProperty(Event.Property prop) {
        for (Event.Property prop2 : excludeProps) {
            if (!prop.equals((Object)prop2)) continue;
            return true;
        }
        return false;
    }

    protected ResultSet performSelect(Statement stat, int fetchSize) {
        ResultSet rs = null;
        try {
            StringBuilder query = new StringBuilder();
            StringBuilder columns = new StringBuilder();
            for (Event.Property prop : Event.Table.Historical.properties()) {
                if (this.excludeProperty(prop)) continue;
                columns.append(Event.Table.Historical.tableName()).append(".").append(prop.columnName()).append(",");
            }
            for (Event.Property prop : Event.Table.Historical2.properties()) {
                if (this.excludeProperty(prop)) continue;
                columns.append(Event.Table.Historical2.tableName()).append(".").append(prop.columnName()).append(",");
            }
            query.append("SELECT ").append(Event.Table.Historical.tableName()).append(".").append(Event.Property.id.columnName()).append(",").append(columns.substring(0, columns.length() - 1)).append(" FROM ").append(Event.Table.Historical.tableName());
            query.append(" INNER JOIN ").append(Event.Table.Historical2.tableName());
            query.append(" ON ").append(Event.Table.Historical.tableName()).append(".").append(Event.Property.secondaryId.columnName()).append("=").append(Event.Table.Historical2.tableName()).append(".").append(Event.Property.id.columnName());
            query.append(" WHERE ").append(Event.Table.Historical.tableName()).append(".").append(Event.Property.deleted.columnName()).append("=1");
            query.append(" ORDER BY ").append(Event.Table.Historical.tableName()).append(".").append(Event.Property.receiveTime.columnName()).append(" ASC ");
            String sql = query.toString();
            stat.setMaxRows(fetchSize);
            rs = stat.executeQuery(sql);
        }
        catch (Exception e) {
            log.error((Object)"Failed to select candidates for DAP on Event History", (Throwable)e);
            rs = null;
        }
        return rs;
    }

    protected void updateCustomData(Object ... args) throws Exception {
        ResultSet rs = (ResultSet)args[0];
        this.customData = rs.getLong(Event.Property.receiveTime.columnName());
    }

    protected long candidatesCount() {
        long rowCount = this.getRowCount();
        long openCount = this.getOpenCount();
        if (rowCount < 0L || rowCount < 0L) {
            return -1L;
        }
        return openCount >= this.threshold ? rowCount - openCount : rowCount - this.threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getOpenCount() {
        long recordsNumber = -1L;
        Connection con = null;
        ResultSet rs = null;
        Statement stat = null;
        try {
            con = JDBCConnectionProvider.getConnection();
            stat = con.createStatement();
            rs = stat.executeQuery("select count(*) from bwoperationalevent where deleted = 0");
            rs.next();
            recordsNumber = rs.getLong("count(*)");
        }
        catch (Exception e) {
            try {
                log.error((Object)"Failed to count open alarms", (Throwable)e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(rs);
                JDBCConnectionProvider.close(stat);
                JDBCConnectionProvider.close(con);
                rs = null;
                stat = null;
                con = null;
                throw throwable;
            }
            JDBCConnectionProvider.close(rs);
            JDBCConnectionProvider.close(stat);
            JDBCConnectionProvider.close(con);
            rs = null;
            stat = null;
            con = null;
        }
        JDBCConnectionProvider.close(rs);
        JDBCConnectionProvider.close(stat);
        JDBCConnectionProvider.close(con);
        rs = null;
        stat = null;
        con = null;
        return recordsNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int performDeleteOnSecondary() {
        int recordsNumber;
        block9: {
            recordsNumber = -1;
            Connection con = null;
            ResultSet rs = null;
            Statement stat = null;
            Statement stat2 = null;
            long time1 = System.currentTimeMillis();
            try {
                con = JDBCConnectionProvider.getConnection();
                stat = con.createStatement();
                StringBuilder query = new StringBuilder();
                query.append("SELECT COUNT(b.").append(Event.Property.id.columnName()).append(") FROM ").append(Event.Table.Historical2.tableName()).append(" b LEFT JOIN ").append(Event.Table.Historical.tableName()).append(" a ON (").append("b.").append(Event.Property.id.columnName()).append(" = a.").append(Event.Property.secondaryId.columnName()).append(") WHERE a.").append(Event.Property.secondaryId.columnName()).append(" IS NULL");
                rs = stat.executeQuery(query.toString());
                if (rs.next() && rs.getLong(1) > 10000L) {
                    EventDAO.Database db = EventDAO.Database.getDB(con);
                    query = new StringBuilder();
                    if (EventDAO.Database.MySQL.equals((Object)db)) {
                        query.append("DELETE b FROM ").append(Event.Table.Historical2.tableName()).append(" b LEFT JOIN ").append(Event.Table.Historical.tableName()).append(" a ON (").append("b.").append(Event.Property.id.columnName()).append(" = a.").append(Event.Property.secondaryId.columnName()).append(") WHERE a.").append(Event.Property.secondaryId.columnName()).append(" IS NULL");
                    } else if (EventDAO.Database.Oracle.equals((Object)db)) {
                        query.append("DELETE FROM ").append(Event.Table.Historical2.tableName()).append(" b ").append("WHERE NOT EXISTS (SELECT a.").append(Event.Property.id.columnName()).append(" FROM ").append(Event.Table.Historical.tableName()).append(" a WHERE b.").append(Event.Property.id.columnName()).append(" = a.").append(Event.Property.secondaryId.columnName()).append(")");
                    }
                    JDBCConnectionProvider.close(rs);
                    JDBCConnectionProvider.close(stat);
                    rs = null;
                    stat = null;
                    stat2 = con.createStatement();
                    recordsNumber = stat2.executeUpdate(query.toString());
                    con.commit();
                }
                long time2 = System.currentTimeMillis();
                log.info((Object)("Event History Secondary rows deleted: [" + recordsNumber + "] in " + (time2 - time1) + " millis"));
                JDBCConnectionProvider.close(rs);
            }
            catch (Exception e) {
                log.error((Object)"Failed to delete rows on Event History Secondary", (Throwable)e);
                break block9;
            }
            finally {
                JDBCConnectionProvider.close(rs);
                JDBCConnectionProvider.close(stat);
                JDBCConnectionProvider.close(stat2);
                JDBCConnectionProvider.close(con);
            }
            JDBCConnectionProvider.close(stat);
            JDBCConnectionProvider.close(stat2);
            JDBCConnectionProvider.close(con);
        }
        return recordsNumber;
    }
}

