/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.task;

import au.com.bytecode.opencsv.CSVWriter;
import com.bwanms.backend.task.AbstractTaskExecutor;
import com.bwanms.backend.task.CSVRowFormatter;
import com.bwanms.backend.task.CSVUtil;
import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.domain.logic.SystemEntityEvents;
import com.bwanms.mediation.util.EventFacade;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.fault.Event;
import com.bwanms.model.task.DatabaseAgingGenericTask;
import com.bwanms.model.task.Destination;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationStatus;
import com.bwanms.util.task.OperationTaskRuntimeStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseAgingGenericTaskExecutor
extends AbstractTaskExecutor<DatabaseAgingGenericTask> {
    private static final Logger log = Logger.getLogger(DatabaseAgingGenericTaskExecutor.class);
    private static final double _125_PERCENT = 1.25;
    private static final double _150_PERCENT = 1.5;
    protected Object customData;
    private OperationTaskRuntimeStatus runtimeStatus;
    private Operation mainOperation;
    private Operation exportOperation;
    private Operation deleteOperation;
    CSVRowFormatter formatter = null;
    private static final int FLUSH_AFTER_ROWS = 20;
    private static final SimpleDateFormat FILE_TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss");

    public DatabaseAgingGenericTaskExecutor(DatabaseAgingGenericTask task) {
        super(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(TaskExecutionContext ctx) {
        long candidatesCount;
        long startTimestamp;
        boolean doExport;
        block27: {
            ResultSet rs;
            Statement stm;
            Connection con;
            block26: {
                block25: {
                    block24: {
                        this.deleteOperation = null;
                        this.exportOperation = null;
                        doExport = false;
                        startTimestamp = System.currentTimeMillis();
                        log.debug((Object)("RUNNING DAP on " + ((DatabaseAgingGenericTask)this.task).getTargetTable().tableName()));
                        super.execute(ctx);
                        this.mainOperation = new Operation(null, "TaskTitle");
                        this.runtimeStatus = new OperationTaskRuntimeStatus(this.mainOperation);
                        if (!Destination.Type.None.equals((Object)((DatabaseAgingGenericTask)this.task).getDestination().getDestinationType())) {
                            doExport = true;
                        }
                        if (doExport) {
                            this.exportOperation = this.runtimeStatus.addOperation(this.mainOperation, "ExportOp", ((DatabaseAgingGenericTask)this.task).getDestination().getParam1());
                        }
                        this.deleteOperation = this.runtimeStatus.addOperation(this.mainOperation, "DeleteOp", ((DatabaseAgingGenericTask)this.task).getTargetTable().toString());
                        long threshold = ((DatabaseAgingGenericTask)this.task).getThreshold();
                        long rowNumTotal = this.getRowCount();
                        if (rowNumTotal < 0L) {
                            log.error((Object)("FAILED to run DAP : cannot count rows on table " + ((DatabaseAgingGenericTask)this.task).getTargetTable().tableName()));
                            this.runtimeStatus.logOperationStatus(this.mainOperation, OperationStatus.FAILED, (Serializable)((Object)"CannotCountRowsOnTable"), ((DatabaseAgingGenericTask)this.task).getTargetTable().toString());
                            if (doExport) {
                                this.runtimeStatus.logOperationStatus(this.exportOperation, OperationStatus.SKIPPED);
                            }
                            this.runtimeStatus.logOperationStatus(this.deleteOperation, OperationStatus.SKIPPED);
                            ctx.taskFinished();
                            return;
                        }
                        this.runtimeStatus.logOperationStatus(this.mainOperation, OperationStatus.IN_PROGRESS);
                        log.debug((Object)(((DatabaseAgingGenericTask)this.task).getTargetTable().tableName() + " table currently has " + rowNumTotal + " records "));
                        if (this.checkAbort(doExport)) {
                            return;
                        }
                        if ((double)rowNumTotal < (double)threshold * 1.25) {
                            log.debug((Object)("FINISHED DAP (NO NEED FOR DAP) on " + ((DatabaseAgingGenericTask)this.task).getTargetTable().tableName()));
                            this.runtimeStatus.logOperationStatus(this.mainOperation, OperationStatus.COMPLETED, (Serializable)((Object)"NoNeedForAction"));
                            if (doExport) {
                                this.runtimeStatus.logOperationStatus(this.exportOperation, OperationStatus.SKIPPED);
                            }
                            this.runtimeStatus.logOperationStatus(this.deleteOperation, OperationStatus.SKIPPED);
                            ctx.taskFinished();
                            return;
                        }
                        if ((double)rowNumTotal < (double)threshold * 1.5) {
                            this.emitEvent(1.25);
                            log.debug((Object)("FINISHED DAP (NO NEED FOR DAP) on " + ((DatabaseAgingGenericTask)this.task).getTargetTable().tableName() + " 125% FULL"));
                            this.runtimeStatus.logOperationStatus(this.mainOperation, OperationStatus.SKIPPED, (Serializable)((Object)"Database125Full"));
                            if (doExport) {
                                this.runtimeStatus.logOperationStatus(this.exportOperation, OperationStatus.SKIPPED);
                            }
                            this.runtimeStatus.logOperationStatus(this.deleteOperation, OperationStatus.SKIPPED);
                            ctx.taskFinished();
                            return;
                        }
                        this.emitEvent(1.5);
                        log.debug((Object)("database " + ((DatabaseAgingGenericTask)this.task).getTargetTable().tableName() + " 150% full ... running DAP"));
                        candidatesCount = this.candidatesCount();
                        con = null;
                        stm = null;
                        rs = null;
                        try {
                            con = JDBCConnectionProvider.getConnection();
                            stm = con.createStatement();
                            rs = this.performSelect(stm, (int)candidatesCount);
                            if (rs == null) {
                                ++this.failures;
                                log.error((Object)("FAILED to run DAP : cannot fetch rows from table" + ((DatabaseAgingGenericTask)this.task).getTargetTable().tableName()));
                                this.runtimeStatus.logOperationStatus(this.mainOperation, OperationStatus.FAILED, (Serializable)((Object)"CannotFetchRowsFromTable"), ((DatabaseAgingGenericTask)this.task).getTargetTable().toString());
                                this.runtimeStatus.logOperationStatus(this.deleteOperation, OperationStatus.SKIPPED);
                                if (doExport) {
                                    this.runtimeStatus.logOperationStatus(this.exportOperation, OperationStatus.SKIPPED);
                                }
                                ctx.taskFinished();
                                JDBCConnectionProvider.close(rs);
                                break block24;
                            }
                            if (!this.performExport(rs)) {
                                log.error((Object)("FAILED to run DAP : export to " + ((DatabaseAgingGenericTask)this.task).getDestination().getDestinationType().name() + " failed on table " + ((DatabaseAgingGenericTask)this.task).getTargetTable().tableName()));
                                this.runtimeStatus.logOperationStatus(this.deleteOperation, OperationStatus.FAILED);
                                if (doExport) {
                                    this.runtimeStatus.logOperationStatus(this.exportOperation, OperationStatus.FAILED);
                                }
                                this.runtimeStatus.logOperationStatus(this.mainOperation, OperationStatus.FAILED, (Serializable)((Object)"ExportFailedOnTable"), ((DatabaseAgingGenericTask)this.task).getTargetTable().toString());
                                ctx.taskFinished();
                                JDBCConnectionProvider.close(rs);
                                break block25;
                            }
                            JDBCConnectionProvider.close(rs);
                            break block26;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break block27;
                        }
                    }
                    JDBCConnectionProvider.close(stm);
                    JDBCConnectionProvider.close(con);
                    return;
                }
                JDBCConnectionProvider.close(stm);
                JDBCConnectionProvider.close(con);
                return;
            }
            JDBCConnectionProvider.close(stm);
            JDBCConnectionProvider.close(con);
            break block27;
            finally {
                JDBCConnectionProvider.close(rs);
                JDBCConnectionProvider.close(stm);
                JDBCConnectionProvider.close(con);
            }
        }
        if (doExport) {
            this.runtimeStatus.logOperationStatus(this.exportOperation, OperationStatus.COMPLETED);
        }
        if (this.checkAbort(doExport = false)) {
            return;
        }
        if (this.performDelete() < 0) {
            ++this.failures;
            log.error((Object)("FAILED to run DAP : cannot delete rows from table " + (Object)((Object)((DatabaseAgingGenericTask)this.task).getTargetTable())));
            this.runtimeStatus.logOperationStatus(this.deleteOperation, OperationStatus.FAILED);
            this.runtimeStatus.logOperationStatus(this.mainOperation, OperationStatus.FAILED, (Serializable)((Object)"CannotDeleteRowsFromTable"), new Object[]{((DatabaseAgingGenericTask)this.task).getTargetTable()});
            ctx.taskFinished();
            return;
        }
        this.runtimeStatus.logOperationStatus(this.deleteOperation, OperationStatus.COMPLETED, (Serializable)((Object)"Deleted"), String.valueOf(candidatesCount));
        if (this.failures == 0) {
            String duration = String.valueOf((float)(System.currentTimeMillis() - startTimestamp) / 1000.0f);
            log.debug((Object)String.format("DAP deleted %d rows from %s table in %s seconds", new Object[]{candidatesCount, ((DatabaseAgingGenericTask)this.task).getTargetTable(), duration}));
            log.debug((Object)("FINISHED DAP SUCCESSFUL on " + (Object)((Object)((DatabaseAgingGenericTask)this.task).getTargetTable()) + " - " + duration + " seconds"));
            this.runtimeStatus.logOperationStatus(this.mainOperation, OperationStatus.COMPLETED, (Serializable)((Object)"DoneIn"), duration);
        } else {
            this.runtimeStatus.logOperationStatus(this.mainOperation, OperationStatus.COMPLETED_WITH_ERRORS);
        }
        ctx.taskFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getRowCount() {
        long recordsNumber;
        block5: {
            recordsNumber = -1L;
            Connection con = null;
            ResultSet rs = null;
            Statement stat = null;
            try {
                con = JDBCConnectionProvider.getConnection();
                stat = con.createStatement();
                rs = stat.executeQuery("select count(*) from " + ((DatabaseAgingGenericTask)this.task).getTargetTable().tableName());
                rs.next();
                recordsNumber = rs.getLong("count(*)");
                JDBCConnectionProvider.close(rs);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                JDBCConnectionProvider.close(rs);
                JDBCConnectionProvider.close(stat);
                JDBCConnectionProvider.close(con);
                rs = null;
                stat = null;
                con = null;
            }
            JDBCConnectionProvider.close(stat);
            JDBCConnectionProvider.close(con);
            rs = null;
            stat = null;
            con = null;
        }
        return recordsNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performExport(ResultSet rs) {
        Destination.Type destType = ((DatabaseAgingGenericTask)this.task).getDestination().getDestinationType();
        switch (destType) {
            case None: {
                try {
                    while (rs.next()) {
                        this.updateCustomData(rs);
                    }
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case CSV: {
                Writer writer = null;
                CSVWriter csvWriter = null;
                try {
                    writer = this.createWriter();
                    csvWriter = new CSVWriter(writer);
                    CSVUtil.writeColumnNames(rs.getMetaData(), csvWriter, this.formatter);
                    int fl = 20;
                    while (rs.next()) {
                        CSVUtil.writeRow(rs, csvWriter, this.formatter);
                        if (--fl == 0) {
                            fl = 20;
                            csvWriter.flush();
                        }
                        this.updateCustomData(rs);
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (csvWriter != null) {
                            csvWriter.close();
                        }
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    protected abstract void updateCustomData(Object ... var1) throws Exception;

    protected abstract ResultSet performSelect(Statement var1, int var2);

    protected abstract int performDelete();

    protected abstract long candidatesCount();

    private void emitEvent(final double percent) {
        try {
            EventFacade.emitEvent(new CallableDatastoreDecorator<Event>(new Callable<Event>(){

                @Override
                public Event call() throws Exception {
                    return SystemEntityEvents.databaseAgingReport((DatabaseAgingGenericTask)DatabaseAgingGenericTaskExecutor.this.task, (int)(percent * 100.0));
                }
            }).call());
        }
        catch (Exception e) {
            log.warn((Object)String.format("Failed to emit DAP report system event for %s : %d/% FULL", ((DatabaseAgingGenericTask)this.task).getTargetTable().tableName(), (int)(percent * 100.0)));
        }
    }

    private boolean checkAbort(boolean doExport) {
        if (this.ctx.shouldAbort()) {
            if (doExport) {
                this.runtimeStatus.logOperationStatus(this.exportOperation, OperationStatus.ABORTED);
            }
            this.runtimeStatus.logOperationStatus(this.deleteOperation, OperationStatus.ABORTED);
            this.runtimeStatus.logOperationStatus(this.mainOperation, OperationStatus.ABORTED);
            this.ctx.taskFinished();
            return true;
        }
        return false;
    }

    @Override
    public String getReport() {
        String strXML = this.runtimeStatus.toXMLString();
        log.debug((Object)strXML);
        return this.runtimeStatus.toXMLString();
    }

    @Override
    public int getExecutionResult() {
        if (this.ctx.shouldAbort()) {
            return 2;
        }
        if (this.taskFailed) {
            return 3;
        }
        if (this.failures == 0) {
            return 1;
        }
        return 4;
    }

    private Writer createWriter() throws Exception {
        Destination destination = ((DatabaseAgingGenericTask)this.task).getDestination();
        if (destination == null) {
            throw new IllegalArgumentException("Task attribute destination is null");
        }
        Destination.Type type = Destination.Type.valueOf(destination.getDestinationType().name());
        switch (type) {
            case CSV: {
                String folder = destination.getParam1();
                File fileFolder = new File(folder);
                if (!fileFolder.exists()) {
                    fileFolder.mkdir();
                }
                if (!fileFolder.isDirectory()) {
                    throw new Exception("Task CSV destination has an invalid folder destination: " + folder);
                }
                String outputStr = folder + File.separator + (Object)((Object)((DatabaseAgingGenericTask)this.task).getTargetTable()) + "-" + FILE_TIMESTAMP_FORMATTER.format(new Date()) + ".zip";
                File outputFile = new File(outputStr);
                log.info((Object)("outputfile " + outputFile));
                if (!outputFile.createNewFile()) {
                    throw new Exception("Output file exists: " + outputFile);
                }
                ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(outputFile));
                zip.setLevel(9);
                ZipEntry backup = new ZipEntry((Object)((Object)((DatabaseAgingGenericTask)this.task).getTargetTable()) + ".csv");
                backup.setMethod(8);
                zip.putNextEntry(backup);
                OutputStreamWriter writer = new OutputStreamWriter(zip);
                return writer;
            }
            case None: {
                return null;
            }
        }
        throw new IllegalArgumentException("Destination is not supported: " + type.name());
    }
}

