/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.task;

import au.com.bytecode.opencsv.CSVWriter;
import com.bwanms.backend.task.CSVRowFormatter;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public final class CSVUtil {
    static final SimpleDateFormat TIMESTAMP_FORMATTER = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("dd-MMM-yyyy");

    public static void writeColumnNames(ResultSetMetaData resultsetmetadata, CSVWriter writer, CSVRowFormatter formatter) throws SQLException, IOException {
        int i = resultsetmetadata.getColumnCount();
        String[] as = new String[i];
        for (int j = 0; j < i; ++j) {
            as[j] = formatter == null ? resultsetmetadata.getColumnName(j + 1) : formatter.getColumnName(resultsetmetadata, j + 1);
        }
        writer.writeNext(as);
    }

    public static void writeRow(ResultSet resultset, CSVWriter writer, CSVRowFormatter formatter) throws SQLException, IOException {
        ResultSetMetaData resultsetmetadata = resultset.getMetaData();
        int count = resultsetmetadata.getColumnCount();
        String[] as = new String[count];
        for (int j = 0; j < count; ++j) {
            as[j] = formatter == null ? CSVUtil.getColumnValue(resultset, j + 1) : formatter.getColumnValue(resultset, j + 1);
        }
        writer.writeNext(as);
    }

    public static String getColumnValue(ResultSet resultset, int j) throws SQLException, IOException {
        String s = "";
        switch (resultset.getMetaData().getColumnType(j)) {
            case -7: {
                Object obj = resultset.getObject(j);
                if (obj == null) break;
                s = String.valueOf(obj);
                break;
            }
            case 16: {
                boolean flag = resultset.getBoolean(j);
                if (resultset.wasNull()) break;
                s = Boolean.valueOf(flag).toString();
                break;
            }
            case 2005: {
                Clob clob = resultset.getClob(j);
                if (clob == null) break;
                s = CSVUtil.read(clob);
                break;
            }
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                BigDecimal bigdecimal = resultset.getBigDecimal(j);
                if (bigdecimal == null) break;
                s = "" + bigdecimal.doubleValue();
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                int k = resultset.getInt(j);
                if (resultset.wasNull()) break;
                s = "" + k;
                break;
            }
            case 2000: {
                Object obj1 = resultset.getObject(j);
                if (obj1 == null) break;
                s = String.valueOf(obj1);
                break;
            }
            case 91: {
                Date date = resultset.getDate(j);
                if (date == null) break;
                s = DATE_FORMATTER.format(date);
                break;
            }
            case 92: {
                Time time = resultset.getTime(j);
                if (time == null) break;
                s = time.toString();
                break;
            }
            case 93: {
                Timestamp timestamp = resultset.getTimestamp(j);
                if (timestamp == null) break;
                s = TIMESTAMP_FORMATTER.format(timestamp);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                s = resultset.getString(j);
                break;
            }
            default: {
                s = "";
            }
        }
        if (s == null) {
            s = "";
        }
        return s;
    }

    private static String read(Clob clob) throws SQLException, IOException {
        int i;
        StringBuffer stringbuffer = new StringBuffer((int)clob.length());
        Reader reader = clob.getCharacterStream();
        char[] ac = new char[2048];
        boolean flag = false;
        while ((i = reader.read(ac, 0, ac.length)) != -1) {
            if (i <= 0) continue;
            stringbuffer.append(ac, 0, i);
        }
        return stringbuffer.toString();
    }
}

