/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.task;

import com.bwanms.model.Task;
import com.bwanms.model.TaskExecutionContext;
import com.bwanms.model.TaskExecutor;
import com.bwanms.model.TaskRuntimeStatus;
import com.bwanms.util.task.Operation;
import com.bwanms.util.task.OperationTaskRuntimeStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTaskExecutor<T extends Task>
implements TaskExecutor {
    protected T task;
    protected TaskExecutionContext ctx;
    protected boolean taskFailed;
    protected int failures;
    protected Operation mainOperation;
    protected OperationTaskRuntimeStatus runtimeStatus;

    public AbstractTaskExecutor(T task) {
        this.task = task;
    }

    @Override
    public void execute(TaskExecutionContext ctx) {
        this.ctx = ctx;
        this.mainOperation = new Operation(null, "TaskTitle");
        this.runtimeStatus = new OperationTaskRuntimeStatus(this.mainOperation);
    }

    @Override
    public int getExecutionResult() {
        if (this.ctx.shouldAbort()) {
            return 2;
        }
        if (this.taskFailed) {
            return 3;
        }
        if (this.failures == 0) {
            return 1;
        }
        return 4;
    }

    @Override
    public String getReport() {
        return this.runtimeStatus.toXMLString();
    }

    @Override
    public TaskRuntimeStatus getStatus(Object clientData) {
        int index = clientData == null ? 0 : (Integer)clientData;
        return this.runtimeStatus.getDiff(index);
    }

    public T getTask() {
        return this.task;
    }
}

