/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.services.impl;

import com.bwanms.backend.services.impl.EventDAOHelper;
import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.model.fault.Event;
import com.bwanms.services.ServiceException;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleEventDAOHelper
extends EventDAOHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getNextId(Connection con) throws Exception {
        long l;
        Statement stm = null;
        ResultSet rs = null;
        try {
            stm = con.createStatement();
            rs = stm.executeQuery("select HIBERNATE_SEQUENCE.NEXTVAL from dual");
            rs.next();
            long nextVal = rs.getLong(1);
            log.debug((Object)("HIBERNATE_SEQUENCE.NEXTVAL " + nextVal));
            l = nextVal;
        }
        catch (Throwable throwable) {
            JDBCConnectionProvider.close(rs);
            JDBCConnectionProvider.close(stm);
            throw throwable;
        }
        JDBCConnectionProvider.close(rs);
        JDBCConnectionProvider.close(stm);
        return l;
    }

    public static void insert(Connection con, Collection<Event> list, Event.Table table, int batchSize) throws ServiceException {
        if (con == null) {
            throw new IllegalArgumentException("JDBC Connection is null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Event list is null or empty");
        }
        if (table == null) {
            throw new IllegalArgumentException("Event Table is null");
        }
        if (list.size() == 0) {
            return;
        }
        switch (table) {
            case Historical: {
                for (Event event : list) {
                    try {
                        OracleEventDAOHelper.solveHistoricalEventSecondary(con, event);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new ServiceException(e);
                    }
                }
                OracleEventDAOHelper.insertIntoHistorical(con, list, batchSize);
                break;
            }
            case Operational: {
                OracleEventDAOHelper.insertIntoOperational(con, list, batchSize);
                break;
            }
            default: {
                throw new IllegalArgumentException("Undefined Event Table " + table.name());
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void insertIntoOperational(Connection con, Collection<Event> list, int batchSize) throws ServiceException {
        PreparedStatement stat = null;
        try {
            stat = con.prepareStatement(EventDAOHelper.getSQLInsert(Event.Table.Operational, true));
            int cnt = 0;
            for (Event evt : list) {
                OracleEventDAOHelper.setBussinesParameters(stat, evt, true);
                stat.setBigDecimal(tableColumns.size() + 1, new BigDecimal(evt.getId()));
                stat.addBatch();
                if (++cnt % batchSize != 0) continue;
                stat.executeBatch();
            }
            if (cnt % batchSize != 0) {
                stat.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new ServiceException(e);
                catch (IOException e2) {
                    e2.printStackTrace();
                    throw new ServiceException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stat);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stat);
    }

    private static void insertIntoHistorical(Connection con, Collection<Event> list, int batchSize) throws ServiceException {
        PreparedStatement stat = null;
        try {
            stat = con.prepareStatement(OracleEventDAOHelper.getSQLInsertForHistorical(Event.Table.Historical));
            int cnt = 0;
            for (Event evt : list) {
                OracleEventDAOHelper.setHistoricalBussinesParameters(stat, evt, true, true);
                evt.setId(OracleEventDAOHelper.getNextId(con));
                stat.setLong(Event.Table.Historical.properties().length + 1, evt.getId());
                stat.addBatch();
                if (++cnt % batchSize != 0) continue;
                stat.executeBatch();
            }
            if (cnt % batchSize != 0) {
                stat.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stat);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stat);
    }

    private static String getSQLInsertForHistorical(Event.Table table) throws ServiceException {
        String sqlInsert = (String)cacheInsertSQL.get((Object)table);
        if (sqlInsert == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("INSERT INTO ").append(table.tableName()).append(" (");
            int i = 0;
            Event.Property[] props = table.properties();
            for (i = 0; i < props.length; ++i) {
                buffer.append(props[i].columnName()).append(",");
            }
            buffer.append(Event.Property.id.columnName());
            buffer.append(") VALUES (");
            for (i = 0; i < props.length; ++i) {
                buffer.append("?,");
            }
            buffer.append("?)");
            sqlInsert = buffer.toString();
            cacheInsertSQL.put(table, sqlInsert);
        }
        log.debug((Object)("SQL " + table.name() + " insert: " + sqlInsert));
        return sqlInsert;
    }

    protected static long insertIntoSecondaryHistorical(Connection con, Event event) throws ServiceException {
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            stm = con.prepareStatement(OracleEventDAOHelper.getSQLInsertForHistorical(Event.Table.Historical2));
            OracleEventDAOHelper.setHistoricalBussinesParameters2(stm, event);
            long nextId = OracleEventDAOHelper.getNextId(con);
            stm.setLong(Event.Table.Historical2.properties().length + 1, nextId);
            stm.executeUpdate();
            long l = nextId;
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage(), e);
        }
        finally {
            JDBCConnectionProvider.close(rs);
            JDBCConnectionProvider.close(stm);
        }
    }

    protected static String getSQLUpdateForHistorical(Event.Table table) throws ServiceException {
        String sqlUpdate = (String)cacheUpdateSQL.get(table.tableName());
        if (sqlUpdate == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("UPDATE ").append(table.tableName()).append(" SET ");
            int i = 0;
            Event.Property[] props = table.properties();
            for (i = 0; i < props.length - 1; ++i) {
                if (Event.Property.eventCause.equals((Object)props[i])) continue;
                buffer.append(props[i].columnName()).append("=?,");
            }
            buffer.append(props[i].columnName()).append("=?");
            buffer.append(" WHERE id=?");
            sqlUpdate = buffer.toString();
            cacheUpdateSQL.put(table.tableName(), sqlUpdate);
        }
        log.debug((Object)("SQL " + table.name() + " update: " + sqlUpdate));
        return sqlUpdate;
    }

    protected static String getSQLUpdateForHistoricalNoSecondaryId(Event.Table table) throws ServiceException {
        String sqlUpdate = (String)cacheUpdateSQL.get(table.tableName() + "NoSecondaryId");
        if (sqlUpdate == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("UPDATE ").append(table.tableName()).append(" SET ");
            int i = 0;
            Event.Property[] props = table.properties();
            for (i = 0; i < props.length; ++i) {
                if (Event.Property.eventCause.equals((Object)props[i]) || Event.Property.secondaryId.equals((Object)props[i])) continue;
                buffer.append(props[i].columnName()).append("=?,");
            }
            int len = buffer.length();
            buffer.replace(len - 1, len, "");
            buffer.append(" WHERE id=?");
            sqlUpdate = buffer.toString();
            cacheUpdateSQL.put(table.tableName() + "NoSecondaryId", sqlUpdate);
        }
        log.debug((Object)("SQL " + table.name() + " update: " + sqlUpdate));
        return sqlUpdate;
    }

    private static void solveHistoricalEventSecondary(Connection con, Event event) throws ServiceException {
        Long id = OracleEventDAOHelper.searchHistoricalSecondary(con, event);
        if (id == null) {
            id = OracleEventDAOHelper.insertIntoSecondaryHistorical(con, event);
        }
        event.setSecondaryId(id);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void updateOnlyHistoricalEvent(Connection con, Event event, int batchSize) throws ServiceException {
        PreparedStatement stat = null;
        try {
            stat = con.prepareStatement(OracleEventDAOHelper.getSQLUpdateForHistorical(Event.Table.Historical));
            OracleEventDAOHelper.setHistoricalBussinesParameters(stat, event, false, true);
            stat.setLong(Event.Table.Historical.properties().length, event.getId());
            stat.executeUpdate();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new ServiceException(e);
                catch (IOException e2) {
                    e2.printStackTrace();
                    throw new ServiceException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stat);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stat);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void updateOnlyHistoricalEventNoSecondaryId(Connection con, Event event, int batchSize) throws ServiceException {
        PreparedStatement stat = null;
        try {
            stat = con.prepareStatement(OracleEventDAOHelper.getSQLUpdateForHistoricalNoSecondaryId(Event.Table.Historical));
            OracleEventDAOHelper.setHistoricalBussinesParameters(stat, event, false, false);
            stat.setLong(Event.Table.Historical.properties().length - 1, event.getId());
            stat.executeUpdate();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new ServiceException(e);
                catch (IOException e2) {
                    e2.printStackTrace();
                    throw new ServiceException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stat);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stat);
    }

    public static void update(Connection con, Collection<Event> list, Event.Table table, int batchSize) throws ServiceException {
        if (table == Event.Table.Operational) {
            OracleEventDAOHelper.updateOperational(con, list, batchSize);
        } else {
            OracleEventDAOHelper.updateHistorical(con, list, batchSize);
        }
    }

    private static void updateHistorical(Connection con, Collection<Event> list, int batchSize) throws ServiceException {
        for (Event event : list) {
            if (OracleEventDAOHelper.isSecondaryTblUpdateRequired(con, event)) {
                OracleEventDAOHelper.solveHistoricalEventSecondary(con, event);
                OracleEventDAOHelper.updateOnlyHistoricalEvent(con, event, batchSize);
                continue;
            }
            OracleEventDAOHelper.updateOnlyHistoricalEventNoSecondaryId(con, event, batchSize);
        }
    }

    private static void updateOperational(Connection con, Collection<Event> list, int batchSize) throws ServiceException {
        PreparedStatement stat = null;
        try {
            stat = con.prepareStatement(OracleEventDAOHelper.getSQLUpdate(Event.Table.Operational));
            int cnt = 0;
            Iterator<Event> iter = list.iterator();
            while (iter.hasNext()) {
                OracleEventDAOHelper.setUpdateStatementParams(stat, iter.next());
                stat.addBatch();
                if (++cnt % batchSize != 0) continue;
                stat.executeBatch();
            }
            if (cnt % batchSize != 0) {
                stat.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stat);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stat);
    }
}

