/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.services.impl;

import com.bwanms.backend.fault.alarmstate.AlarmStateProcessor;
import com.bwanms.backend.fault.policies.remove.EventsRemoveDaemon;
import com.bwanms.backend.services.EventDAO;
import com.bwanms.backend.services.EventHistoryDAO;
import com.bwanms.backend.services.EventManagerService;
import com.bwanms.backend.services.impl.EventQueryHelper;
import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.EventQueryResult;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.services.ServiceException;
import com.bwanms.util.fault.FilterUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManagerServiceImpl
implements EventManagerService {
    public static Logger logger = Logger.getLogger(EventManagerServiceImpl.class);
    private static final String selectCols = EventQueryHelper.sqlSelectColsExcluded(Arrays.asList(Event.Property.eventCause, Event.Property.secondaryId), null);

    @Override
    public EventQueryResult getEvents(String filter, long lastUpdateTime) throws ServiceException {
        if (lastUpdateTime < 0L) {
            throw new IllegalArgumentException("LastUpdateTime is undefined");
        }
        EventQueryResult result = new EventQueryResult();
        StringBuffer finalFilter = new StringBuffer();
        if (filter != null && filter.length() > 0) {
            finalFilter.append(filter);
        }
        if (lastUpdateTime > 0L) {
            if (finalFilter.length() > 0) {
                finalFilter.append(" AND ");
            }
            finalFilter.append(Event.Property.lastUpdateTime.columnName()).append(">").append(lastUpdateTime);
        }
        List<Event> events = EventDAO.fetch(Event.Table.Operational, selectCols, finalFilter.toString());
        result.setEvents(events);
        result.setCounters(EventDAO.fetchCounters(Event.Table.Operational, null));
        EventsRemoveDaemon removeDaemon = (EventsRemoveDaemon)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/EventsRemoveDaemon");
        result.setLastRemoveTime(removeDaemon.lastRemoveTime());
        result.setOldRemoveTime(removeDaemon.oldRemoveTime());
        return result;
    }

    @Override
    public Event getEventDetails(long id) throws ServiceException {
        if (id <= 0L) {
            throw new IllegalArgumentException("Event ID is undefined");
        }
        return EventHistoryDAO.fetchDetails(id);
    }

    @Override
    public int[] getCounters(String filter) throws ServiceException {
        return EventDAO.fetchCounters(Event.Table.Historical, filter);
    }

    @Override
    public void ackEvents(List<Event> events, String ackBy, boolean ackFlag) throws ServiceException {
        if (events == null) {
            throw new IllegalArgumentException("Event list is null");
        }
        if (ackBy == null || ackBy.length() == 0) {
            throw new IllegalArgumentException("AckBy is null or empty");
        }
        long time = System.currentTimeMillis();
        if (ackFlag) {
            for (Event event : events) {
                event.setAckedBy(ackBy);
                event.setAckTime(time);
                event.setLastUpdateTime(time);
            }
        } else {
            for (Event event : events) {
                event.setAckedBy(null);
                event.setAckTime(0L);
                event.setLastUpdateTime(time);
            }
        }
        try {
            this.update(events);
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
            ex.printStackTrace();
        }
    }

    @Override
    public void clearEvents(List<Event> events, String clearBy) throws ServiceException {
        if (events == null) {
            throw new IllegalArgumentException("Event list is null");
        }
        if (clearBy == null || clearBy.length() == 0) {
            throw new IllegalArgumentException("AckBy is null or empty");
        }
        long time = System.currentTimeMillis();
        for (Event event : events) {
            event.setClearedBy(clearBy);
            event.setClearTime(time);
            event.setLastUpdateTime(time);
        }
        try {
            this.update(events);
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
            ex.printStackTrace();
        }
        this.computeAlarmState(events);
    }

    private void computeAlarmState(List<Event> events) throws ServiceException {
        HashSet<Long> equipments = new HashSet<Long>();
        for (Event event : events) {
            Long eqId = event.getEquipmentId();
            if (equipments.contains(eqId)) continue;
            try {
                AlarmStateProcessor.computeAlarmState(eqId, EventDAO.fetch(Event.Table.Operational, FilterUtil.formatOpenAlarmsFilter(eqId)));
                equipments.add(eqId);
            }
            catch (ServiceException se) {
                logger.debug((Object)se);
                se.printStackTrace();
            }
        }
    }

    private void update(List<Event> events) throws Exception {
        Connection con = null;
        try {
            con = JDBCConnectionProvider.getConnection();
            EventHistoryDAO.update(events, con);
            EventDAO.update(Event.Table.Operational, events, con);
            con.commit();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            JDBCConnectionProvider.close(con);
        }
    }

    @Override
    public void updateEvent(Event event) throws ServiceException {
        ArrayList<Event> events = new ArrayList<Event>();
        events.add(event);
        try {
            this.update(events);
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
            ex.printStackTrace();
        }
    }
}

