/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.services.impl;

import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.model.fault.Event;
import com.bwanms.services.ServiceException;
import com.bwanms.util.fault.EventUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventDAOHelper {
    protected static final Logger log = Logger.getLogger(EventDAOHelper.class);
    protected static final LinkedHashMap<Event.Property, Integer> tableColumns = new LinkedHashMap();
    static final HashMap<Event.Table, String> cacheInsertSQL;
    static final HashMap<String, String> cacheUpdateSQL;

    public static String getSQLUpdate(Event.Table table, Event.Property[] props) {
        int i;
        for (Event.Property prop : props) {
            if (!prop.equals((Object)Event.Property.id)) continue;
            throw new IllegalArgumentException("Event ID cannot be updated");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(table.tableName()).append(" SET ");
        for (i = 0; i < props.length - 1; ++i) {
            buffer.append(props[i].name()).append("=?, ");
        }
        buffer.append(props[i].name()).append("=? ");
        buffer.append("WHERE ").append(Event.Property.id.columnName()).append("=?");
        String sqlUpdate = buffer.toString();
        log.debug((Object)("SQL " + table.name() + " update: " + sqlUpdate));
        return sqlUpdate;
    }

    public static String getSQLUpdate(Event.Table table) {
        String sqlUpdate = cacheUpdateSQL.get(table.tableName());
        if (sqlUpdate == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("UPDATE ").append(table.tableName()).append(" SET ");
            Set<Event.Property> keySet = tableColumns.keySet();
            Iterator<Event.Property> iter = keySet.iterator();
            int size = keySet.size();
            int i = 0;
            while (iter.hasNext()) {
                Event.Property p = iter.next();
                if (!p.equals((Object)Event.Property.eventCause)) {
                    buffer.append(p.columnName()).append("=?");
                    if (i < size - 1) {
                        buffer.append(", ");
                    }
                }
                ++i;
            }
            buffer.append(" WHERE id=?");
            sqlUpdate = buffer.toString();
            cacheUpdateSQL.put(table.tableName(), sqlUpdate);
        }
        log.debug((Object)("SQL " + table.name() + " update: " + sqlUpdate));
        return sqlUpdate;
    }

    public static String getSQLInsert(Event.Table table, boolean isColumnIDNeeded) throws ServiceException {
        String sqlInsert = cacheInsertSQL.get((Object)table);
        if (sqlInsert == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("INSERT INTO ").append(table.tableName()).append(" (");
            Set<Event.Property> keySet = tableColumns.keySet();
            Iterator<Event.Property> iter = keySet.iterator();
            int size = keySet.size();
            int i = 0;
            while (iter.hasNext()) {
                buffer.append(iter.next().columnName());
                if (i < size - 1) {
                    buffer.append(",");
                }
                ++i;
            }
            if (isColumnIDNeeded) {
                buffer.append(",id");
            }
            buffer.append(") VALUES (");
            for (i = 0; i < size - 1; ++i) {
                buffer.append("?,");
            }
            if (isColumnIDNeeded) {
                buffer.append("?,");
            }
            buffer.append("?)");
            sqlInsert = buffer.toString();
            cacheInsertSQL.put(table, sqlInsert);
        }
        log.debug((Object)("SQL " + table.name() + " insert: " + sqlInsert));
        return sqlInsert;
    }

    public static void insert(Connection con, Collection<Event> list, Event.Table table, int batchSize) throws ServiceException {
        throw new ServiceException("Unsuported operation. Use specific EventDAOHelpers: OracleEventDAOHelper or MySQLEventDAOHelper");
    }

    public static String getSQLDelete(Event.Table table) {
        StringBuffer buffer = new StringBuffer("DELETE FROM ");
        buffer.append(table.tableName());
        buffer.append(" WHERE id = ?");
        String strDelete = buffer.toString();
        log.debug((Object)("SQL " + table.name() + " delete: " + strDelete));
        return strDelete;
    }

    public static String getSQLSelect(Event.Table table) {
        if (Event.Table.Historical2.equals((Object)table)) {
            StringBuilder buf = new StringBuilder("SELECT ");
            buf.append(Event.Property.id.columnName()).append(" FROM ").append(Event.Table.Historical2.tableName()).append(" WHERE ");
            Event.Property[] props = Event.Table.Historical2.properties();
            int i = 0;
            for (i = 0; i < props.length - 1; ++i) {
                buf.append(props[i].columnName()).append("=? AND ");
            }
            buf.append(props[i].columnName()).append("=? ");
            return buf.toString();
        }
        throw new IllegalArgumentException("Only Event Historical Table is allowed here");
    }

    public static void setDeleteOperationalEventParams(PreparedStatement stat, Event event) throws SQLException {
        stat.setLong(1, event.getId());
    }

    @Deprecated
    public static void setUpdateStatementParams(PreparedStatement stat, Event event) throws ServiceException {
        try {
            EventDAOHelper.setBussinesParameters(stat, event, false);
            stat.setLong(tableColumns.size() + 1 - 1, event.getId());
        }
        catch (SQLException e) {
            throw new ServiceException(e);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Deprecated
    protected static void setBussinesParameters(PreparedStatement stat, Event event, boolean useEventCause) throws SQLException, IOException {
        int i = 1;
        stat.setLong(i++, event.getEventTime());
        stat.setByte(i++, event.getEventCategory());
        stat.setString(i++, event.getEquipmentName());
        stat.setByte(i++, event.getEventType());
        stat.setByte(i++, event.getEventSeverity());
        stat.setLong(i++, event.getSequenceNumber());
        stat.setString(i++, event.getAckedBy());
        stat.setLong(i++, event.getAckTime());
        stat.setInt(i++, event.getEquipmentType());
        stat.setString(i++, event.getLocationName());
        stat.setLong(i++, event.getClearTime());
        stat.setString(i++, event.getClearedBy());
        stat.setString(i++, event.getManagedObject());
        stat.setLong(i++, event.getReceiveTime());
        stat.setString(i++, event.getEventDescription());
        stat.setString(i++, event.getSourceIPAddress());
        stat.setLong(i++, event.getEquipmentId());
        stat.setByte(i++, event.getObjectSeverity());
        stat.setLong(i++, event.getLastUpdateTime());
        stat.setByte(i++, event.getProtocol());
        stat.setByte(i++, event.getMoType());
        stat.setString(i++, event.getMoInstance());
        stat.setString(i++, event.getMoAlias());
        stat.setLong(i++, event.getLocationId());
        stat.setString(i++, event.getEventName());
        stat.setBoolean(i++, event.isAckRequired());
        stat.setLong(i++, event.getCorrelationEventId());
        stat.setByte(i++, event.getDeleted());
        if (useEventCause) {
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            ObjectOutputStream outObj = new ObjectOutputStream(buff);
            outObj.writeObject(event.getEventCause());
            outObj.close();
            stat.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(buff.toByteArray()), buff.size());
        }
        stat.setString(i++, event.getEventOID());
        stat.setInt(i++, event.getProbableCause());
        stat.setString(i++, event.getEventAdvisor());
        stat.setString(i++, event.getProposedRepairAction());
        stat.setString(i++, event.getEventNotes());
        stat.setString(i++, event.getSpecificProblem());
        stat.setByte(i++, event.getAdministrativeState());
        stat.setByte(i++, event.getOperationalState());
        stat.setByte(i++, event.getUsageState());
        stat.setByte(i++, event.getAlarmStatus());
        stat.setByte(i++, event.getProceduralStatus());
        stat.setByte(i++, event.getAvailabilityStatus());
        stat.setByte(i++, event.getControlStatus());
        stat.setByte(i++, event.getStandbyStatus());
        stat.setByte(i++, event.getLifecycleStatus());
        stat.setByte(i++, event.getUnknownStatus());
        stat.setString(i++, event.getUserClassifier());
        stat.setBoolean(i++, event.isAudible());
    }

    protected static void setHistoricalBussinesParameters(PreparedStatement stat, Event event, boolean useEventCause, boolean useSecondaryId) throws SQLException, IOException {
        int i = 1;
        stat.setByte(i++, event.getProtocol());
        stat.setLong(i++, event.getSequenceNumber());
        stat.setLong(i++, event.getEventTime());
        stat.setLong(i++, event.getReceiveTime());
        stat.setString(i++, event.getEventDescription());
        stat.setByte(i++, event.getObjectSeverity());
        stat.setLong(i++, event.getAckTime());
        stat.setLong(i++, event.getClearTime());
        stat.setLong(i++, event.getLastUpdateTime());
        stat.setLong(i++, event.getCorrelationEventId());
        stat.setByte(i++, event.getDeleted());
        if (useEventCause) {
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            ObjectOutputStream outObj = new ObjectOutputStream(buff);
            outObj.writeObject(event.getEventCause());
            outObj.close();
            stat.setBinaryStream(i++, (InputStream)new ByteArrayInputStream(buff.toByteArray()), buff.size());
        }
        stat.setInt(i++, event.getProbableCause());
        stat.setString(i++, event.getEventAdvisor());
        stat.setString(i++, event.getEventNotes());
        stat.setString(i++, event.getProposedRepairAction());
        stat.setByte(i++, event.getAdministrativeState());
        stat.setByte(i++, event.getAlarmStatus());
        stat.setByte(i++, event.getAvailabilityStatus());
        stat.setByte(i++, event.getControlStatus());
        stat.setByte(i++, event.getLifecycleStatus());
        stat.setByte(i++, event.getOperationalState());
        stat.setByte(i++, event.getProceduralStatus());
        stat.setString(i++, event.getSpecificProblem());
        stat.setByte(i++, event.getStandbyStatus());
        stat.setByte(i++, event.getUnknownStatus());
        stat.setByte(i++, event.getUsageState());
        if (useSecondaryId) {
            stat.setLong(i++, event.getSecondaryId());
        }
    }

    protected static void setHistoricalBussinesParameters2(PreparedStatement stat, Event event) throws SQLException {
        int col = 1;
        stat.setByte(col++, event.getEventSeverity());
        stat.setString(col++, EventUtil.escapeString(event.getLocationName()));
        stat.setString(col++, EventUtil.escapeString(event.getEquipmentName()));
        stat.setString(col++, event.getManagedObject());
        stat.setString(col++, event.getSourceIPAddress());
        stat.setString(col++, EventUtil.escapeString(event.getEventName()));
        stat.setInt(col++, event.getEquipmentType());
        stat.setByte(col++, event.getMoType());
        stat.setString(col++, event.getMoInstance());
        stat.setString(col++, EventUtil.escapeString(event.getMoAlias()));
        stat.setString(col++, event.getEventOID());
        stat.setLong(col++, event.getLocationId());
        stat.setLong(col++, event.getEquipmentId());
        stat.setByte(col++, event.getEventCategory());
        stat.setByte(col++, event.getEventType());
        stat.setString(col++, EventUtil.escapeString(event.getAckedBy()));
        stat.setString(col++, EventUtil.escapeString(event.getClearedBy()));
        stat.setString(col++, EventUtil.escapeString(event.getUserClassifier()));
    }

    protected static void setOnlyHistoricalBussinesParameters(PreparedStatement stat, Event event) throws SQLException {
        stat.setString(1, event.getEventNotes());
    }

    public static Event createEvent(ResultSet rs) throws ServiceException, IOException, ClassNotFoundException {
        Event event = new Event();
        try {
            event.setId(rs.getLong("Id"));
            event.setEventTime(rs.getLong(Event.Property.eventTime.columnName()));
            event.setEventCategory(rs.getByte(Event.Property.eventCategory.columnName()));
            event.setEquipmentName(EventUtil.unescapeString(rs.getString(Event.Property.equipmentName.columnName())));
            event.setEventType(rs.getByte(Event.Property.eventType.columnName()));
            event.setEventSeverity(rs.getByte(Event.Property.eventSeverity.columnName()));
            event.setSequenceNumber(rs.getLong(Event.Property.sequenceNumber.columnName()));
            event.setAckedBy(EventUtil.unescapeString(rs.getString(Event.Property.ackedBy.columnName())));
            event.setAckTime(rs.getLong(Event.Property.ackTime.columnName()));
            event.setEquipmentType(rs.getInt(Event.Property.equipmentType.columnName()));
            event.setLocationName(EventUtil.unescapeString(rs.getString(Event.Property.locationName.columnName())));
            event.setClearTime(rs.getLong(Event.Property.clearTime.columnName()));
            event.setClearedBy(EventUtil.unescapeString(rs.getString(Event.Property.clearedBy.columnName())));
            event.setManagedObject(rs.getString(Event.Property.managedObject.columnName()));
            event.setReceiveTime(rs.getLong(Event.Property.receiveTime.columnName()));
            event.setEventDescription(rs.getString(Event.Property.eventDescription.columnName()));
            event.setSourceIPAddress(rs.getString(Event.Property.sourceIPAddress.columnName()));
            event.setEquipmentId(rs.getLong(Event.Property.equipmentId.columnName()));
            event.setObjectSeverity(rs.getByte(Event.Property.objectSeverity.columnName()));
            event.setLastUpdateTime(rs.getLong(Event.Property.lastUpdateTime.columnName()));
            event.setProtocol(rs.getByte(Event.Property.protocol.columnName()));
            event.setMoType(rs.getByte(Event.Property.moType.columnName()));
            event.setMoInstance(rs.getString(Event.Property.moInstance.columnName()));
            event.setMoAlias(EventUtil.unescapeString(rs.getString(Event.Property.moAlias.columnName())));
            event.setLocationId(rs.getLong(Event.Property.locationId.columnName()));
            event.setEventName(EventUtil.unescapeString(rs.getString(Event.Property.eventName.columnName())));
            event.setAckRequired(rs.getBoolean(Event.Property.ackRequired.columnName()));
            event.setCorrelationEventId(rs.getLong(Event.Property.correlationEventId.columnName()));
            event.setDeleted(rs.getByte(Event.Property.deleted.columnName()));
            event.setProposedRepairAction(rs.getString(Event.Property.proposedRepairAction.columnName()));
            event.setEventAdvisor(rs.getString(Event.Property.eventAdvisor.columnName()));
            event.setEventNotes(rs.getString(Event.Property.eventNotes.columnName()));
            try {
                ObjectInputStream inObj = new ObjectInputStream(rs.getBinaryStream(Event.Property.eventCause.columnName()));
                event.setEventCause((Serializable)inObj.readObject());
                inObj.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            event.setEventOID(rs.getString(Event.Property.eventOID.columnName()));
            event.setProbableCause(rs.getInt(Event.Property.probableCause.columnName()));
            event.setSpecificProblem(rs.getString(Event.Property.specificProblem.columnName()));
            event.setAdministrativeState(rs.getByte(Event.Property.administrativeState.columnName()));
            event.setOperationalState(rs.getByte(Event.Property.operationalState.columnName()));
            event.setUsageState(rs.getByte(Event.Property.usageState.columnName()));
            event.setAlarmStatus(rs.getByte(Event.Property.alarmStatus.columnName()));
            event.setProceduralStatus(rs.getByte(Event.Property.proceduralStatus.columnName()));
            event.setAvailabilityStatus(rs.getByte(Event.Property.availabilityStatus.columnName()));
            event.setControlStatus(rs.getByte(Event.Property.controlStatus.columnName()));
            event.setStandbyStatus(rs.getByte(Event.Property.standbyStatus.columnName()));
            event.setLifecycleStatus(rs.getByte(Event.Property.lifecycleStatus.columnName()));
            event.setUnknownStatus(rs.getByte(Event.Property.unknownStatus.columnName()));
            event.setUserClassifier(EventUtil.unescapeString(rs.getString(Event.Property.userClassifier.columnName())));
            event.setAudible(rs.getBoolean(Event.Property.audible.columnName()));
            return event;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ServiceException(e);
        }
    }

    protected static Long searchHistoricalSecondary(Connection con, Event event) throws ServiceException {
        Long l;
        ResultSet rs;
        PreparedStatement stm;
        block5: {
            stm = null;
            rs = null;
            String query = EventDAOHelper.getSQLSelect(Event.Table.Historical2);
            log.debug((Object)query);
            stm = con.prepareStatement(query);
            EventDAOHelper.setHistoricalBussinesParameters2(stm, event);
            rs = stm.executeQuery();
            if (!rs.next()) break block5;
            Long l2 = rs.getLong(Event.Property.id.columnName());
            JDBCConnectionProvider.close(rs);
            JDBCConnectionProvider.close(stm);
            return l2;
        }
        try {
            l = null;
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new ServiceException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(rs);
                JDBCConnectionProvider.close(stm);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(rs);
        JDBCConnectionProvider.close(stm);
        return l;
    }

    protected static boolean isSecondaryTblUpdateRequired(Connection con, Event event) throws ServiceException {
        boolean ret = false;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("SELECT COUNT(*) FROM ").append(Event.Table.Historical2.tableName()).append(" WHERE ").append(Event.Property.id.columnName()).append(" IN (").append(" SELECT ").append(Event.Property.secondaryId.columnName()).append(" FROM ").append(Event.Table.Historical.tableName()).append(" WHERE ").append(Event.Property.id.columnName()).append(" = ").append(event.getId()).append(" )").append(" AND ( ").append(Event.Property.ackedBy.columnName()).append(" != '").append(EventUtil.escapeString(event.getAckedBy())).append("'").append(" OR ").append(Event.Property.clearedBy.columnName()).append(" != '").append(EventUtil.escapeString(event.getClearedBy())).append("'").append(" )");
            stat = con.prepareStatement(strBuf.toString());
            rs = stat.executeQuery();
            if (rs.next() && rs.getLong(1) > 0L) {
                ret = true;
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(rs);
                JDBCConnectionProvider.close(stat);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(rs);
        JDBCConnectionProvider.close(stat);
        return ret;
    }

    protected static String getSQLColumnName(String columnName) {
        return "'" + columnName + "'";
    }

    public static void delete(Connection con, Collection<Event> list, Event.Table table, int batchSize) throws ServiceException {
        PreparedStatement stat = null;
        try {
            stat = con.prepareStatement(EventDAOHelper.getSQLDelete(table));
            int cnt = 0;
            Iterator<Event> iter = list.iterator();
            while (iter.hasNext()) {
                EventDAOHelper.setDeleteOperationalEventParams(stat, iter.next());
                stat.addBatch();
                if (++cnt % batchSize != 0) continue;
                stat.executeBatch();
            }
            if (cnt % batchSize != 0) {
                stat.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stat);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stat);
    }

    static {
        int i = 1;
        tableColumns.put(Event.Property.eventTime, i++);
        tableColumns.put(Event.Property.eventCategory, i++);
        tableColumns.put(Event.Property.equipmentName, i++);
        tableColumns.put(Event.Property.eventType, i++);
        tableColumns.put(Event.Property.eventSeverity, i++);
        tableColumns.put(Event.Property.sequenceNumber, i++);
        tableColumns.put(Event.Property.ackedBy, i++);
        tableColumns.put(Event.Property.ackTime, i++);
        tableColumns.put(Event.Property.equipmentType, i++);
        tableColumns.put(Event.Property.locationName, i++);
        tableColumns.put(Event.Property.clearTime, i++);
        tableColumns.put(Event.Property.clearedBy, i++);
        tableColumns.put(Event.Property.managedObject, i++);
        tableColumns.put(Event.Property.receiveTime, i++);
        tableColumns.put(Event.Property.eventDescription, i++);
        tableColumns.put(Event.Property.sourceIPAddress, i++);
        tableColumns.put(Event.Property.equipmentId, i++);
        tableColumns.put(Event.Property.objectSeverity, i++);
        tableColumns.put(Event.Property.lastUpdateTime, i++);
        tableColumns.put(Event.Property.protocol, i++);
        tableColumns.put(Event.Property.moType, i++);
        tableColumns.put(Event.Property.moInstance, i++);
        tableColumns.put(Event.Property.moAlias, i++);
        tableColumns.put(Event.Property.locationId, i++);
        tableColumns.put(Event.Property.eventName, i++);
        tableColumns.put(Event.Property.ackRequired, i++);
        tableColumns.put(Event.Property.correlationEventId, i++);
        tableColumns.put(Event.Property.deleted, i++);
        tableColumns.put(Event.Property.eventCause, i++);
        tableColumns.put(Event.Property.eventOID, i++);
        tableColumns.put(Event.Property.probableCause, i++);
        tableColumns.put(Event.Property.eventAdvisor, i++);
        tableColumns.put(Event.Property.proposedRepairAction, i++);
        tableColumns.put(Event.Property.eventNotes, i++);
        tableColumns.put(Event.Property.specificProblem, i++);
        tableColumns.put(Event.Property.administrativeState, i++);
        tableColumns.put(Event.Property.operationalState, i++);
        tableColumns.put(Event.Property.usageState, i++);
        tableColumns.put(Event.Property.alarmStatus, i++);
        tableColumns.put(Event.Property.proceduralStatus, i++);
        tableColumns.put(Event.Property.availabilityStatus, i++);
        tableColumns.put(Event.Property.controlStatus, i++);
        tableColumns.put(Event.Property.standbyStatus, i++);
        tableColumns.put(Event.Property.lifecycleStatus, i++);
        tableColumns.put(Event.Property.unknownStatus, i++);
        tableColumns.put(Event.Property.userClassifier, i++);
        tableColumns.put(Event.Property.audible, i++);
        cacheInsertSQL = new HashMap();
        cacheUpdateSQL = new HashMap();
    }
}

