/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.services;

import com.bwanms.backend.services.EventDAO;
import com.bwanms.backend.services.impl.EventDAOHelper;
import com.bwanms.backend.services.impl.MySQLEventDAOHelper;
import com.bwanms.backend.services.impl.OracleEventDAOHelper;
import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.services.ServiceException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventHistoryDAO {
    private static final Logger log = Logger.getLogger(EventHistoryDAO.class);
    private static final Lock lock = new ReentrantLock();
    private static int BATCH_SIZE = 20;

    public static List<Event> fetch(String filter) throws ServiceException {
        return EventHistoryDAO.fetch("*", filter);
    }

    public static List<Event> fetch(String selectCols, String filter) throws ServiceException {
        throw new ServiceException("dummy");
    }

    public static Event fetchDetails(long id) throws ServiceException {
        ResultSet rs;
        Statement stm;
        Connection con;
        block4: {
            Event event;
            con = null;
            stm = null;
            rs = null;
            try {
                con = JDBCConnectionProvider.getConnection();
                stm = con.createStatement();
                StringBuilder query = new StringBuilder();
                query.append("SELECT * FROM ").append(Event.Table.Historical.tableName());
                query.append(" INNER JOIN ").append(Event.Table.Historical2.tableName());
                query.append(" ON ").append(Event.Table.Historical.tableName()).append(".").append(Event.Property.secondaryId.columnName()).append("=").append(Event.Table.Historical2.tableName()).append(".").append(Event.Property.id.columnName());
                query.append(" WHERE ").append(Event.Table.Historical.tableName()).append(".").append(Event.Property.id.columnName()).append("=").append(id);
                rs = stm.executeQuery(query.toString());
                if (!rs.next()) break block4;
                event = EventDAOHelper.createEvent(rs);
            }
            catch (Exception e) {
                try {
                    throw new ServiceException(e);
                }
                catch (Throwable throwable) {
                    JDBCConnectionProvider.close(rs);
                    JDBCConnectionProvider.close(stm);
                    JDBCConnectionProvider.close(con);
                    throw throwable;
                }
            }
            JDBCConnectionProvider.close(rs);
            JDBCConnectionProvider.close(stm);
            JDBCConnectionProvider.close(con);
            return event;
        }
        JDBCConnectionProvider.close(rs);
        JDBCConnectionProvider.close(stm);
        JDBCConnectionProvider.close(con);
        return null;
    }

    public static void insert(Collection<Event> list) throws ServiceException {
        Connection con = null;
        try {
            lock.lock();
            con = JDBCConnectionProvider.getConnection();
            long lastUpdateTime = System.currentTimeMillis();
            for (Event evt : list) {
                evt.setLastUpdateTime(lastUpdateTime);
            }
            EventHistoryDAO.insert(list, con);
            con.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ServiceException(e);
        }
        finally {
            JDBCConnectionProvider.close(con);
            lock.unlock();
        }
    }

    private static void insert(Collection<Event> list, Connection con) throws SQLException, ServiceException {
        long time1 = System.currentTimeMillis();
        EventDAO.Database db = EventDAO.Database.getDB(con);
        if (EventDAO.Database.Oracle.equals((Object)db)) {
            OracleEventDAOHelper.insert(con, list, Event.Table.Historical, BATCH_SIZE);
        } else if (EventDAO.Database.MySQL.equals((Object)db)) {
            MySQLEventDAOHelper.insert(con, list, Event.Table.Historical, BATCH_SIZE);
        } else {
            throw new ServiceException("Unknown database implementation: " + db.name());
        }
        long time2 = System.currentTimeMillis();
        log.debug((Object)("JDBC Bulk Insert: " + list.size() + " rows - " + (time2 - time1) + " millis"));
    }

    public static void delete(Collection<Event> list) throws ServiceException {
        throw new ServiceException("Dummy");
    }

    private static void delete(Collection<Event> list, Connection con) throws SQLException {
        throw new SQLException("Dummy");
    }

    public static void update(Collection<Event> list) throws ServiceException {
        Connection con = null;
        try {
            lock.lock();
            con = JDBCConnectionProvider.getConnection();
            EventHistoryDAO.update(list, con);
            con.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ServiceException(e);
        }
        finally {
            JDBCConnectionProvider.close(con);
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Collection<Event> list, Connection con) throws SQLException, ServiceException {
        try {
            lock.lock();
            long time1 = System.currentTimeMillis();
            EventDAO.Database db = EventDAO.Database.getDB(con);
            if (EventDAO.Database.Oracle.equals((Object)db)) {
                OracleEventDAOHelper.update(con, list, Event.Table.Historical, BATCH_SIZE);
            } else if (EventDAO.Database.MySQL.equals((Object)db)) {
                MySQLEventDAOHelper.update(con, list, Event.Table.Historical, BATCH_SIZE);
            } else {
                throw new ServiceException("Unknown database implementation: " + db.name());
            }
            long time2 = System.currentTimeMillis();
            log.debug((Object)("JDBC Bulk Update: " + list.size() + " rows - " + (time2 - time1) + " millis"));
        }
        finally {
            lock.unlock();
        }
    }

    public static int[] fetchCounters(Event.Table table, String filter) throws ServiceException {
        int[] counters = new int[7];
        Connection con = null;
        ResultSet rs = null;
        Statement stm = null;
        try {
            con = JDBCConnectionProvider.getConnection();
            stm = con.createStatement();
            StringBuilder query = new StringBuilder();
            query.append("SELECT ").append(Event.Property.eventSeverity.columnName());
            query.append(", count(" + Event.Property.eventSeverity.columnName() + ") FROM ").append(table.tableName());
            boolean where = false;
            if (Event.Table.Operational.equals((Object)table)) {
                if (!where) {
                    query.append(" WHERE ");
                    where = true;
                } else {
                    query.append(" AND ");
                }
                query.append("(").append(Event.Property.deleted.columnName()).append(" = 0").append(")");
            }
            if (null != filter) {
                if (!where) {
                    query.append(" WHERE ");
                    where = true;
                } else {
                    query.append(" AND ");
                }
                query.append("(").append(filter).append(")");
            }
            query.append(" GROUP BY ").append(Event.Property.eventSeverity.columnName());
            rs = stm.executeQuery(query.toString());
            block12: while (rs.next()) {
                switch (Severity.fromValue(rs.getInt(1))) {
                    case Critical: {
                        counters[6] = rs.getInt(2);
                        continue block12;
                    }
                    case Major: {
                        counters[5] = rs.getInt(2);
                        continue block12;
                    }
                    case Minor: {
                        counters[4] = rs.getInt(2);
                        continue block12;
                    }
                    case Warning: {
                        counters[3] = rs.getInt(2);
                        continue block12;
                    }
                    case Indeterminate: {
                        counters[2] = rs.getInt(2);
                        continue block12;
                    }
                    case Cleared: {
                        counters[1] = rs.getInt(2);
                        continue block12;
                    }
                }
                counters[0] = rs.getInt(2);
            }
        }
        catch (Exception e) {
            try {
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(rs);
                JDBCConnectionProvider.close(stm);
                JDBCConnectionProvider.close(con);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(rs);
        JDBCConnectionProvider.close(stm);
        JDBCConnectionProvider.close(con);
        return counters;
    }

    public static int executeUpdate(String sqlCmd) throws ServiceException {
        throw new ServiceException("Dummy");
    }

    public static int executeUpdate(QueryHelper queryHelper) throws ServiceException {
        Connection con = null;
        Statement stat = null;
        int count = -1;
        try {
            lock.lock();
            con = JDBCConnectionProvider.getConnection();
            stat = con.createStatement();
            count = stat.executeUpdate(queryHelper.formatQuery());
            con.commit();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stat);
                JDBCConnectionProvider.close(con);
                lock.unlock();
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stat);
        JDBCConnectionProvider.close(con);
        lock.unlock();
        return count;
    }

    public static interface QueryHelper {
        public String formatQuery();
    }
}

