/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.services;

import com.bwanms.backend.services.impl.EventDAOHelper;
import com.bwanms.backend.services.impl.MySQLEventDAOHelper;
import com.bwanms.backend.services.impl.OracleEventDAOHelper;
import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.services.ServiceException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDAO {
    private static final Logger log = Logger.getLogger(EventDAO.class);
    private static final Lock lock = new ReentrantLock();
    private static int BATCH_SIZE = 20;

    public static List<Event> fetch(Event.Table table, String filter) throws ServiceException {
        return EventDAO.fetch(table, "*", filter);
    }

    public static List<Event> fetch(Event.Table table, String selectCols, String filter) throws ServiceException {
        LinkedList<Event> events = new LinkedList<Event>();
        Connection con = EventDAO.getConnection();
        Statement stm = null;
        ResultSet rs = null;
        try {
            stm = con.createStatement();
            StringBuilder query = new StringBuilder();
            query.append("SELECT ").append(selectCols).append(" FROM ").append(table.tableName());
            if (filter != null && filter.trim().length() > 0) {
                query.append(" WHERE ").append(filter);
            }
            query.append(" ORDER BY ").append(Event.Property.receiveTime.columnName()).append(" DESC").append(" , ").append(Event.Property.id.columnName()).append(" DESC");
            rs = stm.executeQuery(query.toString());
            while (rs.next()) {
                events.add(EventDAOHelper.createEvent(rs));
            }
        }
        catch (Exception e) {
            try {
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(rs);
                JDBCConnectionProvider.close(stm);
                EventDAO.closeConnection(con);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(rs);
        JDBCConnectionProvider.close(stm);
        EventDAO.closeConnection(con);
        return events;
    }

    public static void insert(Event.Table table, Collection<Event> list) throws ServiceException {
        Connection con = null;
        try {
            lock.lock();
            con = EventDAO.getConnection();
            long lastUpdateTime = System.currentTimeMillis();
            for (Event evt : list) {
                evt.setLastUpdateTime(lastUpdateTime);
            }
            EventDAO.insert(table, list, con);
            con.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ServiceException(e);
        }
        finally {
            EventDAO.closeConnection(con);
            lock.unlock();
        }
    }

    private static void insert(Event.Table table, Collection<Event> list, Connection con) throws SQLException, ServiceException {
        DatabaseMetaData metaData = con.getMetaData();
        String databaseName = metaData.getDatabaseProductName();
        long time1 = System.currentTimeMillis();
        if (Database.Oracle.name().equalsIgnoreCase(databaseName)) {
            OracleEventDAOHelper.insert(con, list, table, BATCH_SIZE);
        } else if (Database.MySQL.name().equalsIgnoreCase(databaseName)) {
            MySQLEventDAOHelper.insert(con, list, table, BATCH_SIZE);
        } else {
            throw new ServiceException("Unknown database implementation: " + databaseName);
        }
        long time2 = System.currentTimeMillis();
        log.debug((Object)("JDBC Bulk Insert: " + list.size() + " rows - " + (time2 - time1) + " millis"));
    }

    public static void delete(Event.Table table, Collection<Event> list) throws ServiceException {
        Connection con = null;
        try {
            lock.lock();
            con = EventDAO.getConnection();
            long lastUpdateTime = System.currentTimeMillis();
            for (Event evt : list) {
                evt.setLastUpdateTime(lastUpdateTime);
            }
            EventDAO.delete(table, list, con);
            con.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ServiceException(e);
        }
        finally {
            EventDAO.closeConnection(con);
            lock.unlock();
        }
    }

    public static void closeConnection(Connection con) {
        JDBCConnectionProvider.close(con);
    }

    public static Connection getConnection() throws ServiceException {
        return JDBCConnectionProvider.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void delete(Event.Table table, Collection<Event> list, Connection con) throws SQLException {
        PreparedStatement stat;
        block5: {
            stat = null;
            try {
                stat = con.prepareStatement(EventDAOHelper.getSQLDelete(table));
                int cnt = 0;
                Iterator<Event> iter = list.iterator();
                while (iter.hasNext()) {
                    EventDAOHelper.setDeleteOperationalEventParams(stat, iter.next());
                    stat.addBatch();
                    if (++cnt % BATCH_SIZE != 0) continue;
                    stat.executeBatch();
                }
                if (cnt % BATCH_SIZE == 0) break block5;
                stat.executeBatch();
            }
            catch (Exception e) {
                JDBCConnectionProvider.close(stat);
                catch (Throwable throwable) {
                    JDBCConnectionProvider.close(stat);
                    throw throwable;
                }
            }
        }
        JDBCConnectionProvider.close(stat);
    }

    public static void update(Event.Table table, Collection<Event> list) throws ServiceException {
        Connection con = null;
        try {
            con = EventDAO.getConnection();
            EventDAO.update(table, list, con);
            con.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ServiceException(e);
        }
        finally {
            EventDAO.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Event.Table table, Collection<Event> list, Connection con) throws SQLException, ServiceException {
        PreparedStatement stat = null;
        try {
            lock.lock();
            long lastUpdateTime = System.currentTimeMillis();
            for (Event evt : list) {
                evt.setLastUpdateTime(lastUpdateTime);
            }
            stat = con.prepareStatement(EventDAOHelper.getSQLUpdate(table));
            int cnt = 0;
            Iterator<Event> iter = list.iterator();
            while (iter.hasNext()) {
                EventDAOHelper.setUpdateStatementParams(stat, iter.next());
                stat.addBatch();
                if (++cnt % BATCH_SIZE != 0) continue;
                stat.executeBatch();
            }
            if (cnt % BATCH_SIZE != 0) {
                stat.executeBatch();
            }
        }
        catch (Throwable throwable) {
            JDBCConnectionProvider.close(stat);
            lock.unlock();
            throw throwable;
        }
        JDBCConnectionProvider.close(stat);
        lock.unlock();
    }

    public static int[] fetchCounters(Event.Table table, String filter) throws ServiceException {
        int[] counters = new int[7];
        Connection con = EventDAO.getConnection();
        ResultSet rs = null;
        Statement stm = null;
        try {
            stm = con.createStatement();
            StringBuilder query = new StringBuilder();
            query.append("SELECT ").append(Event.Property.eventSeverity.columnName());
            query.append(", count(" + Event.Property.eventSeverity.columnName() + ") FROM ").append(table.tableName());
            boolean where = false;
            if (Event.Table.Operational.equals((Object)table)) {
                if (!where) {
                    query.append(" WHERE ");
                    where = true;
                } else {
                    query.append(" AND ");
                }
                query.append("(").append(Event.Property.deleted.columnName()).append(" = 0").append(")");
            }
            if (null != filter) {
                if (!where) {
                    query.append(" WHERE ");
                    where = true;
                } else {
                    query.append(" AND ");
                }
                query.append("(").append(filter).append(")");
            }
            query.append(" GROUP BY ").append(Event.Property.eventSeverity.columnName());
            rs = stm.executeQuery(query.toString());
            block12: while (rs.next()) {
                switch (Severity.fromValue(rs.getInt(1))) {
                    case Critical: {
                        counters[6] = rs.getInt(2);
                        continue block12;
                    }
                    case Major: {
                        counters[5] = rs.getInt(2);
                        continue block12;
                    }
                    case Minor: {
                        counters[4] = rs.getInt(2);
                        continue block12;
                    }
                    case Warning: {
                        counters[3] = rs.getInt(2);
                        continue block12;
                    }
                    case Indeterminate: {
                        counters[2] = rs.getInt(2);
                        continue block12;
                    }
                    case Cleared: {
                        counters[1] = rs.getInt(2);
                        continue block12;
                    }
                }
                counters[0] = rs.getInt(2);
            }
        }
        catch (Exception e) {
            try {
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(rs);
                JDBCConnectionProvider.close(stm);
                EventDAO.closeConnection(con);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(rs);
        JDBCConnectionProvider.close(stm);
        EventDAO.closeConnection(con);
        return counters;
    }

    public static int executeUpdate(String sqlCmd) throws ServiceException {
        Connection con = null;
        Statement stat = null;
        int count = -1;
        try {
            lock.lock();
            con = JDBCConnectionProvider.getConnection();
            stat = con.createStatement();
            count = stat.executeUpdate(sqlCmd);
            con.commit();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stat);
                EventDAO.closeConnection(con);
                lock.unlock();
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stat);
        EventDAO.closeConnection(con);
        lock.unlock();
        return count;
    }

    public static int executeUpdate(QueryHelper queryHelper) throws ServiceException {
        Connection con = null;
        Statement stat = null;
        int count = -1;
        try {
            lock.lock();
            con = JDBCConnectionProvider.getConnection();
            stat = con.createStatement();
            count = stat.executeUpdate(queryHelper.formatQuery());
            con.commit();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stat);
                JDBCConnectionProvider.close(con);
                lock.unlock();
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stat);
        JDBCConnectionProvider.close(con);
        lock.unlock();
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Database {
        Oracle,
        MySQL;

        static Database db;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Database getDB(Connection con) {
            if (db == null) {
                Connection local = null;
                DatabaseMetaData metaData = null;
                try {
                    if (con != null) {
                        metaData = con.getMetaData();
                    } else {
                        local = JDBCConnectionProvider.getConnection();
                        metaData = local.getMetaData();
                    }
                    if (metaData != null) {
                        String dbName = metaData.getDatabaseProductName();
                        if ("Oracle".equalsIgnoreCase(dbName)) {
                            db = Oracle;
                        } else if ("MySQL".equalsIgnoreCase(dbName)) {
                            db = MySQL;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    JDBCConnectionProvider.close(local);
                }
            }
            return db;
        }

        static {
            db = null;
        }
    }

    public static interface QueryHelper {
        public String formatQuery();
    }
}

