/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault.policies.remove;

import com.bwanms.backend.fault.policies.remove.EventsRemoveCriterion;
import com.bwanms.backend.fault.policies.remove.EventsRemoveStrategy;
import com.bwanms.backend.services.EventDAO;
import com.bwanms.backend.services.EventHistoryDAO;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import com.bwanms.services.ServiceException;
import com.bwanms.util.SystemPropertyUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QryRemoveStrategy
implements EventsRemoveStrategy {
    private static final Logger log = Logger.getLogger(QryRemoveStrategy.class);
    public static final long DEFAULT_LIFETIME = 0L;

    @Override
    public void removeEvents(long currentTime) throws Exception {
        Set<EventsRemoveCriterion> criteria = null;
        try {
            criteria = this.getCriteria();
        }
        catch (Exception exc) {
            throw new Exception("Select criteria failed", exc);
        }
        this.removeCandidatesByJDBC(criteria, currentTime);
    }

    private void removeCandidatesByJDBC(final Set<EventsRemoveCriterion> criteria, final long currentTime) throws Exception {
        try {
            int affectedRows = EventDAO.executeUpdate(new EventDAO.QueryHelper(){

                public String formatQuery() {
                    return QryRemoveStrategy.this.logicalRemoveSQLCmd(criteria, currentTime);
                }
            });
            log.info((Object)String.format("Deleted %d alarms raised by NMS or equipments", affectedRows));
            affectedRows = EventHistoryDAO.executeUpdate(new EventHistoryDAO.QueryHelper(){

                public String formatQuery() {
                    StringBuilder sql = new StringBuilder();
                    sql.append("UPDATE ").append(Event.Table.Historical.tableName()).append(" SET ").append(Event.Property.deleted.columnName()).append("=1").append(", ").append(Event.Property.lastUpdateTime.columnName()).append("=").append(currentTime).append(" WHERE ").append(Event.Property.id.columnName()).append(" IN (SELECT ").append(Event.Property.id.columnName()).append(" FROM ").append(Event.Table.Operational.tableName()).append(" WHERE ").append(Event.Property.deleted.columnName()).append("=1)");
                    return sql.toString();
                }
            });
        }
        catch (ServiceException exc) {
            throw new Exception("Update failed", exc);
        }
    }

    private String logicalRemoveSQLCmd(Set<EventsRemoveCriterion> criteria, long currentTime) {
        StringBuilder sql = new StringBuilder();
        String colDeleted = Event.Property.deleted.columnName();
        String colLastUpdateTime = Event.Property.lastUpdateTime.columnName();
        String colEventCategory = Event.Property.eventCategory.columnName();
        String colEventSeverity = Event.Property.eventSeverity.columnName();
        String colAckedBy = Event.Property.ackedBy.columnName();
        String colAckTime = Event.Property.ackTime.columnName();
        String colClearedBy = Event.Property.clearedBy.columnName();
        String colClearTime = Event.Property.clearTime.columnName();
        String colAckReq = Event.Property.ackRequired.columnName();
        int categoryAlarm = EventCategory.Alarm.value();
        int severityCleared = Severity.Cleared.value();
        sql.append("UPDATE ").append(Event.Table.Operational.tableName()).append(" SET ").append(colDeleted).append(" = 1 ").append(" , ").append(colLastUpdateTime).append(" = ").append(currentTime).append(" WHERE ").append(colDeleted).append(" = 0 ");
        long lifeTime = SystemPropertyUtil.getLong("com.bwanms.fault.event.lifeTime", 0L) * 1000L;
        if (lifeTime == 0L) {
            sql.append(" AND ").append(" ( ( (").append(colEventCategory).append(" = ").append(categoryAlarm).append(" AND ( ").append(colEventSeverity).append(" = ").append(severityCleared).append(" OR ").append(colClearedBy).append(" IS NOT NULL ) ) AND ").append(" ( ").append(colAckReq).append(" = 0 OR ").append(" ( ").append(colAckReq).append(" = 1 AND ").append(colAckedBy).append(" IS NOT NULL ) ) ) OR ").append(" ( ").append(colEventCategory).append(" != ").append(categoryAlarm).append(" AND ").append(colAckedBy).append(" IS NOT NULL ) )");
        } else {
            sql.append(" AND ").append(" ( ( (").append(colEventCategory).append(" = ").append(categoryAlarm).append(" AND ( ").append(colEventSeverity).append(" = ").append(severityCleared).append(" OR ").append(colClearedBy).append(" IS NOT NULL ) ) AND ").append(" ( ( ").append(colAckReq).append(" = 0 AND ").append(colClearTime).append(" <= ").append(currentTime - lifeTime).append(" ) OR ").append(" ( ").append(colAckReq).append(" = 1 AND ").append(colAckedBy).append(" IS NOT NULL AND ").append(colAckTime).append(" <= ").append(currentTime - lifeTime).append(" ) ) ) OR ").append(" ( ").append(colEventCategory).append(" != ").append(categoryAlarm).append(" AND ").append(colAckedBy).append(" IS NOT NULL AND ").append(colAckTime).append(" <= ").append(currentTime - lifeTime).append(" ) )");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sql.toString());
        }
        return sql.toString();
    }

    private Set<EventsRemoveCriterion> getCriteria() throws Exception {
        List<EventsRemoveCriterion> list = new CallableDatastoreDecorator<List<EventsRemoveCriterion>>(new Callable<List<EventsRemoveCriterion>>(){

            @Override
            public List<EventsRemoveCriterion> call() {
                return Datastore.session().createCriteria(EventsRemoveCriterion.class).list();
            }
        }).call();
        if (list.size() > 0) {
            return new HashSet<EventsRemoveCriterion>(list);
        }
        return this.getNewCriteria();
    }

    private Set<EventsRemoveCriterion> getNewCriteria() throws Exception {
        return new CallableDatastoreDecorator<Set<EventsRemoveCriterion>>(new Callable<Set<EventsRemoveCriterion>>(){

            @Override
            public Set<EventsRemoveCriterion> call() {
                EventsRemoveCriterion criterion = new EventsRemoveCriterion();
                criterion.putDefaults();
                Datastore.session().save((Object)criterion);
                HashSet<EventsRemoveCriterion> crit = new HashSet<EventsRemoveCriterion>();
                crit.add(criterion);
                return crit;
            }
        }).call();
    }
}

