/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault.policies.remove;

import com.bwanms.backend.fault.policies.remove.EventsRemoveStrategy;
import com.bwanms.backend.services.EventDAO;
import com.bwanms.backend.services.EventHistoryDAO;
import com.bwanms.domain.logic.NmsSystemLocator;
import com.bwanms.model.NmsSystem;
import com.bwanms.model.fault.Event;
import com.bwanms.persistence.DatastoreDecoratorUtil;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class NEDelRemoveStrategy
implements EventsRemoveStrategy {
    private static final Logger log = Logger.getLogger(NEDelRemoveStrategy.class);

    public void removeEvents(long currentTime) throws Exception {
        this.removeCandidatesByJDBC(currentTime);
    }

    private void removeCandidatesByJDBC(long newParam) throws Exception {
        final StringBuilder sqlEquipmentIds = new StringBuilder();
        sqlEquipmentIds.append("SELECT + ").append("id").append(" FROM ").append("BwManagedEntityBase");
        final StringBuilder sqlEquipmentNames = new StringBuilder();
        sqlEquipmentNames.append("SELECT ").append("name").append(" FROM ").append("BwManagedEntityBase").append(" WHERE ").append("name").append(" IS NOT NULL");
        final String tableName = Event.Table.Operational.tableName();
        final long clearTime = System.currentTimeMillis();
        try {
            final long nmsId = DatastoreDecoratorUtil.call(new Callable<NmsSystem>(){

                @Override
                public NmsSystem call() throws Exception {
                    return NmsSystemLocator.findNmsSystem();
                }
            }).getId();
            int affectedRows = EventDAO.executeUpdate(new EventDAO.QueryHelper(){

                public String formatQuery() {
                    StringBuilder sqlUpd = new StringBuilder();
                    long timestamp = System.currentTimeMillis();
                    sqlUpd.append("UPDATE ").append(tableName).append(" SET ").append(Event.Property.clearedBy.columnName()).append(" = 'SYSTEM' , ").append(Event.Property.clearTime.columnName()).append(" = ").append(clearTime).append(" , ").append(Event.Property.lastUpdateTime.columnName()).append(" = ").append(timestamp).append(" WHERE ").append(Event.Property.deleted.columnName()).append(" = 0 ").append(" AND ").append(Event.Property.clearedBy.columnName()).append(" IS NULL AND ").append(Event.Property.eventCategory.columnName()).append(" = 1 ").append(" AND ").append(Event.Property.eventSeverity.columnName()).append(" > 1 ").append(" AND ").append(Event.Property.equipmentId.columnName()).append(" = ").append(nmsId).append(" AND ").append(Event.Property.moAlias.columnName()).append(" NOT IN (").append(sqlEquipmentNames.toString()).append(")");
                    return sqlUpd.toString();
                }
            });
            log.info((Object)String.format("Cleared %d alarms raised by NMS on behalf of deleted equipments", affectedRows));
            affectedRows = EventDAO.executeUpdate(new EventDAO.QueryHelper(){

                public String formatQuery() {
                    StringBuilder sqlUpd = new StringBuilder();
                    long timestamp = System.currentTimeMillis();
                    sqlUpd.append("UPDATE ").append(tableName).append(" SET ").append(Event.Property.clearedBy.columnName()).append(" = 'SYSTEM' , ").append(Event.Property.clearTime.columnName()).append(" = ").append(clearTime).append(" , ").append(Event.Property.lastUpdateTime.columnName()).append(" = ").append(timestamp).append(" WHERE ").append(Event.Property.deleted.columnName()).append(" = 0 ").append(" AND ").append(Event.Property.clearedBy.columnName()).append(" IS NULL AND ").append(Event.Property.eventCategory.columnName()).append(" = 1 ").append(" AND ").append(Event.Property.eventSeverity.columnName()).append(" > 1 ").append(" AND ").append(Event.Property.equipmentId.columnName()).append(" NOT IN (").append(sqlEquipmentIds.toString()).append(")");
                    return sqlUpd.toString();
                }
            });
            log.info((Object)String.format("Cleared %d alarms raised by deleted equipments", affectedRows));
            affectedRows = EventDAO.executeUpdate(new EventDAO.QueryHelper(){

                public String formatQuery() {
                    StringBuilder sqlUpd = new StringBuilder();
                    long timestamp = System.currentTimeMillis();
                    sqlUpd.append("UPDATE ").append(tableName).append(" SET ").append(Event.Property.deleted.columnName()).append(" = 1 , ").append(Event.Property.lastUpdateTime.columnName()).append(" = ").append(timestamp).append(" WHERE ").append(Event.Property.deleted.columnName()).append(" = 0 ").append(" AND ").append(Event.Property.equipmentId.columnName()).append(" = ").append(nmsId).append(" AND ").append(Event.Property.moAlias.columnName()).append(" NOT IN (").append(sqlEquipmentNames.toString()).append(")");
                    return sqlUpd.toString();
                }
            });
            log.info((Object)String.format("Deleted %d alarms raised by NMS on behalf of deleted equipments", affectedRows));
            affectedRows = EventDAO.executeUpdate(new EventDAO.QueryHelper(){

                public String formatQuery() {
                    StringBuilder sqlUpd = new StringBuilder();
                    long timestamp = System.currentTimeMillis();
                    sqlUpd.append("UPDATE ").append(tableName).append(" SET ").append(Event.Property.deleted.columnName()).append(" = 1 , ").append(Event.Property.lastUpdateTime.columnName()).append(" = ").append(timestamp).append(" WHERE ").append(Event.Property.deleted.columnName()).append(" = 0 ").append(" AND ").append(Event.Property.equipmentId.columnName()).append(" NOT IN (").append(sqlEquipmentIds.toString()).append(")");
                    return sqlUpd.toString();
                }
            });
            log.info((Object)String.format("Deleted %d alarms raised by deleted equipments", affectedRows));
            EventHistoryDAO.update(EventDAO.fetch(Event.Table.Operational, "deleted = 1"));
        }
        catch (Exception e) {
            log.error((Object)"Failed to clear alarms for deleted equipments", (Throwable)e);
            throw e;
        }
    }
}

