/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault.policies.remove;

import com.bwanms.backend.fault.policies.remove.EventsRemoveCriterion;
import com.bwanms.backend.fault.policies.remove.Query;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.EventCategory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventsRemoveQuery<T extends Event>
implements Query<T> {
    private static Logger log = Logger.getLogger(EventsRemoveQuery.class);
    private Set<EventsRemoveCriterion> criteria = new HashSet<EventsRemoveCriterion>();

    public void setCriteria(Set<EventsRemoveCriterion> criteria) {
        this.criteria = criteria;
    }

    public Set<EventsRemoveCriterion> getCriteria() {
        return this.criteria;
    }

    public EventsRemoveQuery(EventsRemoveCriterion criterion) {
        this.criteria.add(criterion);
    }

    public EventsRemoveQuery(Set<EventsRemoveCriterion> criteria) {
        this.criteria = criteria;
    }

    @Override
    public List<T> getResults() throws Exception {
        return this.getResultByJDBC();
    }

    private List<T> getResultByJDBC() {
        StringBuilder sql = new StringBuilder();
        EventsRemoveCriterion criterion = this.criteria.iterator().next();
        sql.append("DELETE FROM ").append(Event.Table.Operational.tableName()).append(" WHERE ").append(Event.Property.deleted.columnName()).append(" = 1");
        if (criterion.getEventCategory() != -1) {
            sql.append(Event.Property.eventCategory.columnName()).append(" = ").append(criterion.getEventCategory()).append(" ");
        }
        if (criterion.getEventSeverity() != -1) {
            sql.append(" AND ").append(Event.Property.eventSeverity.columnName()).append(" = ").append(criterion.getEventSeverity()).append(" ");
        }
        if (criterion.getLifetime() == 0L) {
            if (criterion.isAckRequired()) {
                sql.append(" AND ").append(" ISNULL( ").append(Event.Property.ackedBy.columnName()).append(" ) == 0");
            }
        } else {
            long lifeTime = criterion.getLifetime();
            long currentTime = System.currentTimeMillis();
            if (criterion.isAckRequired()) {
                sql.append(" AND ").append(" (( ").append(Event.Property.eventCategory.columnName()).append(" != ").append(EventCategory.Alarm.value()).append(" AND ").append(Event.Property.ackTime.columnName()).append("<=").append(Long.toString(currentTime - lifeTime)).append(" ) OR ( ").append(Event.Property.eventCategory.columnName()).append(" = ").append(EventCategory.Alarm.value()).append(" AND ").append(Event.Property.clearTime.columnName()).append("<=").append(Long.toString(currentTime - lifeTime)).append(" )) ");
            }
        }
        return null;
    }
}

