/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault.policies.remove;

import com.bwanms.backend.fault.policies.remove.EventsRemoveContext;
import com.bwanms.backend.fault.policies.remove.EventsRemoveDaemon;
import com.bwanms.backend.fault.policies.remove.EvtRemoveStrategy;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class EventsRemoveDaemonImpl
implements EventsRemoveDaemon {
    private static final int DEFAULT_CORE_POOL_SIZE = 1;
    private static Logger log = Logger.getLogger(EventsRemoveDaemonImpl.class);
    private long interval;
    private long lastRemoveTime = 0L;
    private long oldRemoveTime = 0L;
    private ScheduledExecutorService scheduler;
    private EventsRemoveContext ctxQry = new EventsRemoveContext(EvtRemoveStrategy.BY_QRY);
    private EventsRemoveContext ctxNeDel = new EventsRemoveContext(EvtRemoveStrategy.NE_DELETE);
    private EventsRemoveContext ctxTrueDel = new EventsRemoveContext(EvtRemoveStrategy.TRUE_DELETE);
    private boolean loaded;

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    void runDaemon() {
        long currentTime = 0L;
        this.lazyLoad();
        try {
            SimpleDateFormat formatter;
            if (log.isDebugEnabled()) {
                formatter = new SimpleDateFormat("HH:mm:ss.SSS");
                log.debug((Object)("STARTED; oldRemoveTime=" + formatter.format(new Date(this.oldRemoveTime)) + "; lastRemoveTime=" + formatter.format(new Date(this.lastRemoveTime))));
            }
            currentTime = System.currentTimeMillis();
            log.debug((Object)"Real remove of logical deleted events...");
            this.ctxTrueDel.removeEvents(currentTime);
            log.debug((Object)"Logical remove of orphans alarms/events");
            this.ctxNeDel.removeEvents(currentTime);
            log.debug((Object)"Logical remove of Remove alarms/events...");
            this.ctxQry.removeEvents(currentTime);
            this.stepForward(currentTime);
            if (log.isDebugEnabled()) {
                formatter = new SimpleDateFormat("HH:mm:ss.SSS");
                log.debug((Object)("FINISHED in " + (System.currentTimeMillis() - currentTime) + "; oldRemoveTime=" + formatter.format(new Date(this.oldRemoveTime)) + "; lastRemoveTime=" + formatter.format(new Date(this.lastRemoveTime))));
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            log.debug((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            if (msg != null && !msg.equals("Select criteria failed") && !msg.equals("Update failed")) {
                this.stepForward(currentTime);
            }
            log.debug((Object)msg, (Throwable)ex);
            ex.printStackTrace();
        }
    }

    private void lazyLoad() {
        if (this.loaded) {
            return;
        }
        this.ctxQry = new EventsRemoveContext(EvtRemoveStrategy.BY_QRY);
        this.ctxNeDel = new EventsRemoveContext(EvtRemoveStrategy.NE_DELETE);
        this.ctxTrueDel = new EventsRemoveContext(EvtRemoveStrategy.TRUE_DELETE);
        this.loaded = true;
    }

    public synchronized void startDaemon() {
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "Events Remove Daemon");
            }
        });
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                EventsRemoveDaemonImpl.this.runDaemon();
            }
        }, this.getInterval(), this.getInterval(), TimeUnit.MILLISECONDS);
    }

    public long lastRemoveTime() {
        return this.lastRemoveTime;
    }

    public long oldRemoveTime() {
        return this.oldRemoveTime;
    }

    private void stepForward(long currentTime) {
        this.oldRemoveTime = this.lastRemoveTime;
        this.lastRemoveTime = currentTime;
    }

    public synchronized void stopDaemon() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(this.getInterval(), TimeUnit.MILLISECONDS)) {
                this.scheduler.shutdownNow();
                log.warn((Object)"Timeout exceeded for Events Remove Daemon termination. It's was abruptly terminated");
            }
        }
        catch (InterruptedException ex) {
            log.debug((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

