/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault.policies.remove;

import com.bwanms.backend.fault.policies.remove.Criterion;
import com.bwanms.model.fault.constants.EventCategory;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.util.SystemPropertyUtil;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="BwEventsRemoveCriterion")
public class EventsRemoveCriterion
implements Criterion {
    public static final long NO_LIFETIME = 0L;
    private long id;
    private byte eventCategory;
    private byte eventSeverity;
    private boolean ackRequired;
    private long lifetime;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public byte getEventCategory() {
        return this.eventCategory;
    }

    public void setEventCategory(byte eventCategory) {
        this.eventCategory = eventCategory;
    }

    public byte getEventSeverity() {
        return this.eventSeverity;
    }

    public void setEventSeverity(byte eventSeverity) {
        this.eventSeverity = eventSeverity;
    }

    public boolean isAckRequired() {
        return this.ackRequired;
    }

    public void setAckRequired(boolean ackRequired) {
        this.ackRequired = ackRequired;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public void putDefaults() {
        this.setEventCategory(EventCategory.Alarm.byteValue());
        this.setAckRequired(true);
        this.setEventSeverity(Severity.Cleared.byteValue());
        this.setLifetime(SystemPropertyUtil.getLong("com.bwanms.fault.event.lifeTime", 0L) * 1000L);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ackRequired ? 1231 : 1237);
        result = 31 * result + (int)(this.lifetime ^ this.lifetime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventsRemoveCriterion other = (EventsRemoveCriterion)obj;
        if (this.ackRequired != other.ackRequired) {
            return false;
        }
        if (this.eventCategory != other.eventCategory) {
            return false;
        }
        if (this.eventSeverity != other.eventSeverity) {
            return false;
        }
        return this.lifetime == other.lifetime;
    }
}

