/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault.correlation;

import com.bwanms.backend.fault.correlation.CorrelationProcessor;
import com.bwanms.backend.services.EventDAO;
import com.bwanms.backend.services.EventHistoryDAO;
import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.fault.correlation.CorrelationRuleProvider;
import com.bwanms.mediation.snmp.SNMPTrapV1AgentEvent;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.NMSTrap;
import com.bwanms.protocols.snmp.VarBind;
import com.bwanms.protocols.snmp.VarBindList;
import com.bwanms.services.impl.EntityEventFilter;
import com.bwanms.util.fault.EventUtil;
import com.bwanms.util.fault.FilterUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationProcessorAdapter {
    Logger log = Logger.getLogger(CorrelationProcessorAdapter.class);
    private CorrelationProcessor processor;

    public CorrelationProcessorAdapter(CorrelationProcessor processor) {
        this.processor = processor;
    }

    public List<Event> process(Long eqId, List<Event> events) {
        LinkedList<Event> pickOpenAlarms = new LinkedList<Event>();
        try {
            pickOpenAlarms.addAll(EventDAO.fetch(Event.Table.Operational, FilterUtil.formatOpenAlarmsFilter(eqId)));
            ArrayList<Event> clearedEvent = new ArrayList<Event>();
            for (Event event : events) {
                Long entityId;
                VarBind varBind;
                VarBindList varBinds;
                SNMPTrapV1AgentEvent trap;
                if (!EventUtil.isClearingEvent(event)) continue;
                if (NMSTrap.nmsEquipmentResetDetected.oid().equals(event.getEventOID()) && (trap = (SNMPTrapV1AgentEvent)event.getEventCause()) != null && (varBinds = trap.getVarBindList()) != null && (varBind = varBinds.findVarBindByOID("1.3.6.1.4.1.12394.1.260.3.1.1")) != null && (entityId = (Long)varBind.getVariable()) != null) {
                    pickOpenAlarms.addAll(EventDAO.fetch(Event.Table.Operational, FilterUtil.formatOpenAlarmsFilter(entityId)));
                }
                EntityEventFilter correlationFilter = this.getCorrelationFilter(event);
                clearedEvent.addAll(this.clearEvents(pickOpenAlarms, event, correlationFilter));
            }
            try {
                this.saveEvents(clearedEvent);
            }
            catch (Exception ex) {
                this.log.debug((Object)ex);
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
        }
        return pickOpenAlarms;
    }

    private void saveEvents(List<Event> clearedEvents) throws Exception {
        Connection con = null;
        try {
            con = JDBCConnectionProvider.getConnection();
            EventHistoryDAO.update(clearedEvents, con);
            EventDAO.update(Event.Table.Operational, clearedEvents, con);
            con.commit();
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            JDBCConnectionProvider.close(con);
        }
    }

    private <T extends Event> List<T> clearEvents(List<T> openAlarms, T clearingEvent, EntityEventFilter filter) {
        ArrayList<Event> ret = new ArrayList<Event>();
        for (Event candidate : openAlarms) {
            if (EventUtil.isCleared(candidate) || !filter.accept(candidate)) continue;
            candidate.setClearedBy("Correlation");
            long timestamp = System.currentTimeMillis();
            candidate.setClearTime(timestamp);
            candidate.setLastUpdateTime(timestamp);
            candidate.setCorrelationEventId(clearingEvent.getId());
            ret.add(candidate);
        }
        return ret;
    }

    private EntityEventFilter getCorrelationFilter(Event event) {
        EntityEventFilter ret = null;
        for (CorrelationRuleProvider correlator : this.processor.getContext().getCorrelators()) {
            if (!correlator.accept(event)) continue;
            ret = correlator.getEntityEventFilter(event);
            break;
        }
        if (ret == null) {
            ret = new NullFilter();
        }
        return ret;
    }

    public CorrelationProcessor getProcessor() {
        return this.processor;
    }

    private static class NullFilter
    implements EntityEventFilter {
        private NullFilter() {
        }

        public boolean accept(Event candidate) {
            return false;
        }
    }
}

