/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault.alarmstate;

import com.bwanms.domain.logic.NmsSystemLocator;
import com.bwanms.domain.logic.TopologyServiceHelper;
import com.bwanms.model.Equipment;
import com.bwanms.model.NmsSystem;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.constants.Severity;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import com.bwanms.util.fault.EventUtil;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmStateProcessor {
    private static final Logger log = Logger.getLogger(AlarmStateProcessor.class);

    public static void computeAlarmState(final Long eqId, final List<Event> alarms) {
        try {
            new CallableDatastoreDecorator<Object>(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    NmsSystem nmsSys = NmsSystemLocator.findNmsSystem();
                    if (nmsSys == null || nmsSys.getId() != eqId.longValue()) {
                        Equipment eq;
                        int alarmState = Severity.Cleared.value();
                        if (alarms != null) {
                            for (Event alarm : alarms) {
                                if (EventUtil.isCleared(alarm) || alarm.getEventSeverity() <= alarmState) continue;
                                alarmState = alarm.getEventSeverity();
                            }
                        }
                        if ((eq = (Equipment)Datastore.session().get(Equipment.class, (Serializable)eqId)) != null && eq.getAlarmState() != alarmState) {
                            eq.setAlarmState(alarmState);
                            Datastore.session().saveOrUpdate((Object)eq);
                            TopologyServiceHelper.topologyChanged(eq);
                        }
                    }
                    return null;
                }
            }).call();
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
    }
}

