/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimingThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger log = Logger.getLogger(TimingThreadPoolExecutor.class);
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private final AtomicLong taskNo = new AtomicLong();
    private final AtomicLong totalTime = new AtomicLong();
    private AtomicLong time = new AtomicLong();

    public TimingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.startTime.set(System.nanoTime());
        log.debug((Object)String.format("Thread %s started.", t.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            long taskTime = System.nanoTime() - this.startTime.get();
            this.totalTime.addAndGet(taskTime);
            this.taskNo.incrementAndGet();
            log.debug((Object)String.format("Thread execution  time = %d%n", taskTime));
        }
        finally {
            super.afterExecute(r, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void terminated() {
        try {
            if (this.taskNo.get() != 0L) {
                Long avgTime = this.totalTime.get() / this.taskNo.get();
                log.debug((Object)("Threads pool average time [nanoseconds] = " + avgTime));
            }
        }
        finally {
            super.terminated();
        }
    }
}

