/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggingThread
extends Thread {
    public static final String DEFAULT_NAME = "LoggingThread";
    private static volatile boolean debugLifecycle = false;
    private static final AtomicInteger created = new AtomicInteger();
    private static final AtomicInteger alive = new AtomicInteger();
    private static final Logger log = Logger.getLogger(LoggingThread.class);

    public LoggingThread(Runnable r) {
        this(r, DEFAULT_NAME);
    }

    public LoggingThread(Runnable runnable, String name) {
        super(runnable, name + "-" + created.incrementAndGet());
        this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                log.log((Priority)Level.ERROR, (Object)("UNCAUGHT in thread " + t.getName()), e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean debug = debugLifecycle;
        if (debug) {
            log.log((Priority)Level.DEBUG, (Object)("Created " + this.getName()));
        }
        try {
            alive.incrementAndGet();
            super.run();
        }
        finally {
            alive.decrementAndGet();
            if (debug) {
                log.log((Priority)Level.DEBUG, (Object)("Exiting " + this.getName()));
            }
        }
    }

    public static int getThreadsCreated() {
        return created.get();
    }

    public static int getThreadsAlive() {
        return alive.get();
    }

    public static boolean getDebug() {
        return debugLifecycle;
    }

    public static void setDebug(boolean b) {
        debugLifecycle = b;
    }
}

