/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault;

import com.bwanms.backend.fault.AbstractProcessor;
import com.bwanms.backend.fault.EmailSendException;
import com.bwanms.backend.fault.EventTemplateHelper;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.EventTemplate;
import com.bwanms.model.fault.EventTemplateBehavior;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTemplateProcessor
extends AbstractProcessor {
    public static final Logger log = Logger.getLogger(EventTemplateProcessor.class);
    private static EventTemplateProcessor singleton = new EventTemplateProcessor();
    protected static final List<EventTemplate> templatesCache = new ArrayList<EventTemplate>();
    private static final int POLLING_INTERVAL = 60000;
    private ScheduledExecutorService refreshDaemon = Executors.newSingleThreadScheduledExecutor();
    private List<Event> events;

    private EventTemplateProcessor() {
        this.startRefreshTemplatesCache();
    }

    public static synchronized EventTemplateProcessor getInstance() {
        if (singleton == null) {
            singleton = new EventTemplateProcessor();
        }
        return singleton;
    }

    private void startRefreshTemplatesCache() {
        this.refreshDaemon.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                EventTemplateProcessor.this.refreshTemplatesCache();
            }
        }, 0L, 60000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTemplatesCache() {
        List<EventTemplate> list = templatesCache;
        synchronized (list) {
            try {
                new CallableDatastoreDecorator<Object>(new Callable<Object>(){

                    @Override
                    public Object call() {
                        List tpls = Datastore.session().createQuery("from " + EventTemplate.class.getName() + " as et order by et.priority").list();
                        templatesCache.clear();
                        templatesCache.addAll(tpls);
                        return null;
                    }
                }).call();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("A singleton can't be clonned.");
    }

    public EventTemplateProcessor setProcessingEvents(List<Event> events) {
        if (events == null) {
            throw new IllegalArgumentException("Evcents collections can't be null");
        }
        this.events = events;
        return this;
    }

    @Override
    public Serializable process() throws Exception {
        if (this.events == null) {
            throw new IllegalArgumentException("The processing events collections must be set");
        }
        try {
            for (Event event : this.events) {
                this.process(event);
            }
        }
        catch (EmailSendException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private void process(Event event) throws EmailSendException, Exception {
        if (event == null) {
            throw new IllegalArgumentException("Proccesed event can't be null");
        }
        EventTemplateHelper helper = EventTemplateHelper.getInstance();
        EventTemplate eventTemplate = helper.matchEventTemplate(event);
        if (eventTemplate != null) {
            EventTemplateBehavior behavior = eventTemplate.getBehavior();
            helper.applyBehavior(behavior, event);
            helper.runScriptCommand(behavior, event);
            if (behavior.isAutoSendEmail()) {
                helper.sendEMail(behavior, event);
            }
        }
    }
}

