/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault;

import com.bwanms.backend.fault.EmailSendType;
import com.bwanms.backend.fault.EmailSender;
import com.bwanms.backend.fault.EventTemplateProcessor;
import com.bwanms.backend.fault.LoggingThread;
import com.bwanms.backend.fault.LoggingThreadFactory;
import com.bwanms.backend.fault.TimingThreadPoolExecutor;
import com.bwanms.model.Contact;
import com.bwanms.model.fault.Command;
import com.bwanms.model.fault.Event;
import com.bwanms.model.fault.EventTemplate;
import com.bwanms.model.fault.EventTemplateBehavior;
import com.bwanms.model.fault.EventTemplateFilter;
import com.bwanms.model.fault.EvtTmplFilterEquipment;
import com.bwanms.model.fault.EvtTmplFilterEventCategory;
import com.bwanms.model.fault.EvtTmplFilterEventType;
import com.bwanms.model.fault.EvtTmplFilterEvtOID;
import com.bwanms.model.fault.EvtTmplFilterLocation;
import com.bwanms.model.fault.EvtTmplFilterMOAlias;
import com.bwanms.model.fault.EvtTmplFilterMOInst;
import com.bwanms.model.fault.EvtTmplFilterMOType;
import com.bwanms.model.fault.EvtTmplFilterNEType;
import com.bwanms.model.fault.EvtTmplFilterSeverity;
import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.platform.PlatformFactory;
import com.bwanms.platform.PlatformRuntime;
import com.bwanms.services.TimingThreadPool;
import com.bwanms.util.fault.CommandUtil;
import com.bwanms.util.fault.EventUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventTemplateHelper {
    private static final Logger log = Logger.getLogger(EventTemplateHelper.class);
    private static int THREAD_CORE_POOL_SIZE;
    private static int THREAD_MAX_POOL_SIZE;
    private static int THREAD_MAX_POOL_SIZE_1;
    private static long KEEP_ALIVE;
    private TimingThreadPool tpeRunScripts = (TimingThreadPool)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup("bwanms/TimingThreadPool");
    ThreadPoolExecutor tpeRunEmailSend = new TimingThreadPoolExecutor(THREAD_CORE_POOL_SIZE, THREAD_MAX_POOL_SIZE_1, KEEP_ALIVE, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(THREAD_MAX_POOL_SIZE_1), new LoggingThreadFactory("Event template thread pool for email sending"), new ThreadPoolExecutor.DiscardPolicy());
    private static EventTemplateHelper singleton;

    private EventTemplateHelper() {
    }

    public void sendEMail(final EventTemplateBehavior etMail, Event event) {
        if (etMail == null) {
            throw new IllegalArgumentException("Email object can't be null");
        }
        Set<Contact> contacts = etMail.getContacts();
        for (final Contact c : contacts) {
            this.tpeRunEmailSend.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String email = c.getEmail();
                    if (!EventTemplateHelper.this.areEmailPropsValid(email)) {
                        return null;
                    }
                    EmailSender.getInstance(EmailSendType.SIMPLE_SENDER).send(email, etMail.getEMailSubject(), etMail.getEMailMessage(), new Date());
                    return null;
                }
            });
        }
    }

    private boolean areEmailPropsValid(String emailTo) {
        return emailTo != null && EmailSender.PATTERN_EMAIL.matcher(emailTo).matches();
    }

    public static synchronized EventTemplateHelper getInstance() {
        if (singleton == null) {
            singleton = new EventTemplateHelper();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventTemplate matchEventTemplate(final Event event) throws Exception {
        List<EventTemplate> list = EventTemplateProcessor.templatesCache;
        synchronized (list) {
            return new CallableDatastoreDecorator<EventTemplate>(new Callable<EventTemplate>(){

                @Override
                public EventTemplate call() throws Exception {
                    for (EventTemplate et : EventTemplateProcessor.templatesCache) {
                        Set<EvtTmplFilterEquipment> equipments;
                        Set<EvtTmplFilterLocation> locations;
                        Set<EvtTmplFilterEvtOID> oids;
                        Set<EvtTmplFilterMOType> moTypes;
                        Set<EvtTmplFilterSeverity> severities;
                        Set<EvtTmplFilterMOAlias> moAliases;
                        Set<EvtTmplFilterMOInst> moInstances;
                        Set<EvtTmplFilterNEType> neTypes;
                        Set<EvtTmplFilterEventType> eventTypes;
                        Set<EvtTmplFilterEventCategory> eventCategories;
                        EventTemplateFilter filter = et.getFilter();
                        if (filter == null || !(eventCategories = filter.getEventCategories()).isEmpty() && !EventTemplateHelper.getEventCategories(eventCategories).contains(event.getEventCategory()) || !(eventTypes = filter.getEventTypes()).isEmpty() && !EventTemplateHelper.getEventTypes(eventTypes).contains(event.getEventType()) || !(neTypes = filter.getNeTypes()).isEmpty() && !EventTemplateHelper.getNeTypes(neTypes).contains(event.getEquipmentType()) || !(moInstances = filter.getMoInstances()).isEmpty() && !EventTemplateHelper.getMoInstances(moInstances).contains(event.getMoInstance()) || !(moAliases = filter.getMoAliases()).isEmpty() && !EventTemplateHelper.getMoAliases(moAliases).contains(event.getMoAlias()) || !(severities = filter.getSeverities()).isEmpty() && !EventTemplateHelper.getSeverities(severities).contains(event.getEventSeverity()) || !(moTypes = filter.getMoTypes()).isEmpty() && !EventTemplateHelper.getMoTypes(moTypes).contains(event.getMoType()) || !(oids = filter.getEventOIDs()).isEmpty() && !EventTemplateHelper.getOIDs(oids).contains(event.getEventOID()) || !(locations = filter.getLocations()).isEmpty() && !EventTemplateHelper.getLocationIds(locations).contains(event.getLocationId()) || !(equipments = filter.getNetworkElements()).isEmpty() && !EventTemplateHelper.getNeElements(equipments).contains(event.getEquipmentId())) continue;
                        return et;
                    }
                    return null;
                }
            }).call();
        }
    }

    private static Collection<Byte> getEventCategories(Set<EvtTmplFilterEventCategory> eventCategories) {
        HashSet<Byte> set = new HashSet<Byte>(eventCategories.size());
        for (EvtTmplFilterEventCategory evtCat : eventCategories) {
            set.add(evtCat.getEventCategory());
        }
        return set;
    }

    private static Collection<Byte> getEventTypes(Set<EvtTmplFilterEventType> eventTypes) {
        HashSet<Byte> set = new HashSet<Byte>(eventTypes.size());
        for (EvtTmplFilterEventType evtType : eventTypes) {
            set.add(evtType.getEventType());
        }
        return set;
    }

    private static Collection<Integer> getNeTypes(Set<EvtTmplFilterNEType> neTypes) {
        HashSet<Integer> set = new HashSet<Integer>(neTypes.size());
        for (EvtTmplFilterNEType neType : neTypes) {
            set.add(Integer.valueOf(neType.getNeType()));
        }
        return set;
    }

    private static Collection<String> getMoInstances(Set<EvtTmplFilterMOInst> moInstances) {
        HashSet<String> set = new HashSet<String>(moInstances.size());
        for (EvtTmplFilterMOInst moInst : moInstances) {
            set.add(moInst.getMoInst());
        }
        return set;
    }

    private static Collection<String> getMoAliases(Set<EvtTmplFilterMOAlias> moAliases) {
        HashSet<String> set = new HashSet<String>(moAliases.size());
        for (EvtTmplFilterMOAlias moAlias : moAliases) {
            set.add(moAlias.getMoAlias());
        }
        return set;
    }

    private static Collection<Byte> getSeverities(Set<EvtTmplFilterSeverity> severities) {
        HashSet<Byte> set = new HashSet<Byte>(severities.size());
        for (EvtTmplFilterSeverity sev : severities) {
            set.add(sev.getSeverity());
        }
        return set;
    }

    private static Collection<Byte> getMoTypes(Set<EvtTmplFilterMOType> moTypes) {
        HashSet<Byte> set = new HashSet<Byte>(moTypes.size());
        for (EvtTmplFilterMOType moType : moTypes) {
            set.add(moType.getMoType());
        }
        return set;
    }

    private static Collection<String> getOIDs(Set<EvtTmplFilterEvtOID> oids) {
        HashSet<String> set = new HashSet<String>(oids.size());
        for (EvtTmplFilterEvtOID oid : oids) {
            set.add(oid.getEventOID());
        }
        return set;
    }

    private static Collection<Long> getLocationIds(Set<EvtTmplFilterLocation> locations) {
        HashSet<Long> set = new HashSet<Long>(locations.size());
        for (EvtTmplFilterLocation location : locations) {
            set.add(location.getLocationID());
        }
        return set;
    }

    private static Collection<Long> getNeElements(Set<EvtTmplFilterEquipment> equipments) {
        HashSet<Long> set = new HashSet<Long>(equipments.size());
        for (EvtTmplFilterEquipment equipment : equipments) {
            set.add(equipment.getEquipmentID());
        }
        return set;
    }

    void applyBehavior(EventTemplateBehavior behavior, Event event) {
        byte severity = behavior.getAlarmSeverity();
        boolean isAudible = behavior.isAudible();
        String userClassif = behavior.getUserClassifier();
        String advisor = behavior.getAdvisorMessage();
        if (behavior == null) {
            return;
        }
        if (EventUtil.isAlarm(event) && severity != -1) {
            event.setEventSeverity(severity);
        }
        event.setAckRequired(behavior.isAckRequired());
        event.setUserClassifier(userClassif);
        event.setAudible(isAudible);
        if (advisor != null && advisor.length() > 0) {
            event.setEventAdvisor(advisor);
        }
    }

    public void runScriptCommand(EventTemplateBehavior behavior, final Event event) {
        final Command scriptCommand = behavior.getScriptCommand();
        if (scriptCommand == null) {
            return;
        }
        this.tpeRunScripts.execute(new Runnable(){

            public void run() {
                try {
                    String cmdLine = CommandUtil.formatCmdLine(scriptCommand, event);
                    log.info((Object)("Execute script command: " + cmdLine));
                    PlatformRuntime.getOS().runShellCmd(cmdLine);
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    ex.printStackTrace();
                }
            }
        });
    }

    static {
        LoggingThread.setDebug(true);
        THREAD_CORE_POOL_SIZE = 10;
        THREAD_MAX_POOL_SIZE = 50;
        THREAD_MAX_POOL_SIZE_1 = 100;
        KEEP_ALIVE = 5L;
        singleton = new EventTemplateHelper();
    }
}

