/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault;

import com.bwanms.backend.fault.EmailSendException;
import com.bwanms.backend.fault.EmailSendType;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public class EmailSender {
    private static final Logger log = Logger.getLogger(EmailSender.class);
    public static final Pattern PATTERN_EMAIL = Pattern.compile("^(.+)@([^\\(\\);:,<>]+\\.[a-zA-Z]{2,4})");
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final String DEFAULT_PROTOCOL = "smtp";
    public static final String DEFAULT_PORT = "25";
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private String host = "127.0.0.1";
    private String protocol = "smtp";
    private String port = "25";
    boolean debug;
    private String userName = "";
    private String password = "";
    private boolean auth;
    private boolean startTls;
    private EmailSendType emailSendType;
    private static EmailSender singleton;
    private Map<String, Object> miscProps = new Hashtable<String, Object>();

    private EmailSender(EmailSendType emailSendType) {
        this.emailSendType = emailSendType;
    }

    public static synchronized EmailSender getInstance(EmailSendType emailSendType) {
        if (singleton == null) {
            singleton = new EmailSender(emailSendType);
        }
        return singleton;
    }

    @Deprecated
    public final void send(String to, String from, String subject, String body, String contentType, Date sendDate) throws EmailSendException {
        Properties props = System.getProperties();
        props.put("mail.smtp.host", this.host);
        props.put("mail.smtp.port", this.port);
        props.put("mail.transport.protocol", this.protocol);
        props.put("mail.smtp.socketFactory.port", this.port);
        props.put("mail.debug", (Object)this.debug);
        Session mailSession = Session.getInstance((Properties)System.getProperties(), null);
        mailSession.setDebug(this.debug);
        MimeMessage msg = new MimeMessage(mailSession);
        Transport tr = null;
        try {
            msg.setFrom((Address)new InternetAddress(from));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setSubject(subject);
            msg.setSentDate(sendDate);
            msg.setContent((Object)body, contentType);
            tr = mailSession.getTransport(this.protocol);
            if (System.getProperty("mail.smtp.auth", "false").equals("true")) {
                this.host = System.getProperty("mail.smtp.host");
                this.userName = System.getProperty("mail.smtp.user");
                this.password = System.getProperty("mail.smtp.password");
                tr.connect(this.host, this.userName, this.password);
            } else {
                tr.connect();
            }
            tr.sendMessage((Message)msg, msg.getAllRecipients());
        }
        catch (AddressException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new EmailSendException("Error sending message.");
        }
        catch (NoSuchProviderException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new EmailSendException("Error sending message.");
        }
        catch (MessagingException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            throw new EmailSendException("Error sending message.");
        }
        finally {
            try {
                if (tr != null && tr.isConnected()) {
                    tr.close();
                }
            }
            catch (MessagingException ex) {
                throw new EmailSendException("Error closing email trasportation.");
            }
        }
    }

    public final void send(String to, String subject, Object body, Date sendDate) throws EmailSendException {
        this.emailSendType.send(to, subject, body, sendDate);
    }
}

