/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.fault;

import com.bwanms.backend.fault.EmailSendException;
import com.bwanms.backend.fault.EmailSender;
import com.bwanms.util.SystemPropertyUtil;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EmailSendType {
    SIMPLE_SENDER{
        Session mailSession = null;

        protected void send(String to, String subject, Object body, Date sendDate) throws EmailSendException {
            Transport tr = null;
            try {
                if (this.mailSession == null) {
                    this.mailSession = Session.getInstance((Properties)System.getProperties(), (Authenticator)new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(System.getProperty("mail.smtp.user"), System.getProperty("mail.smtp.password"));
                        }
                    });
                }
                if (tr == null && !(tr = this.mailSession.getTransport()).isConnected()) {
                    tr.connect();
                }
                MimeMessage msg = new MimeMessage(this.mailSession);
                msg.setFrom((Address)new InternetAddress(SystemPropertyUtil.getString("mail.smtp.from", "admin@bwanms.com")));
                InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
                msg.setRecipients(Message.RecipientType.TO, (Address[])address);
                msg.setSubject(subject);
                msg.setSentDate(sendDate);
                msg.setContent(body, SystemPropertyUtil.getString("com.bwanms.mail.contentType", "text/plain"));
                msg.saveChanges();
                tr.sendMessage((Message)msg, msg.getAllRecipients());
            }
            catch (AddressException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                throw new EmailSendException("Error sending message.", ex);
            }
            catch (NoSuchProviderException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                throw new EmailSendException("Error sending message.", ex);
            }
            catch (MessagingException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                throw new EmailSendException("Error sending message.", ex);
            }
            finally {
                try {
                    if (tr != null && tr.isConnected()) {
                        tr.close();
                        tr = null;
                    }
                }
                catch (MessagingException ex) {
                    throw new EmailSendException("Error closing email trasportation.");
                }
            }
        }
    }
    ,
    BULK_SENDER{

        protected void send(String to, String subject, Object body, Date sendDate) {
            throw new UnsupportedOperationException("Not supported yet");
        }
    };

    private static final Logger log;

    protected abstract void send(String var1, String var2, Object var3, Date var4) throws EmailSendException;

    static {
        log = Logger.getLogger(EmailSender.class);
    }
}

