/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.dao.pagination;

import com.bwanms.backend.dao.EntityCreator;
import com.bwanms.backend.dao.pagination.PaginationResult;
import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.services.ServiceException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPagination<T extends Serializable> {
    private static final Logger log = Logger.getLogger(JDBCPagination.class);
    private String query;
    private EntityCreator<T> creator;

    public JDBCPagination() {
    }

    public JDBCPagination(String query, int pageSize) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public EntityCreator<T> getCreator() {
        return this.creator;
    }

    public void setCreator(EntityCreator<T> creator) {
        this.creator = creator;
    }

    private ResultSet createResultSet(Connection con, int pageSize) throws ServiceException {
        try {
            PreparedStatement stat = con.prepareStatement(this.query, 1005, 1008);
            stat.setFetchSize(pageSize == 0 ? 1 : pageSize);
            return stat.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public PaginationResult<T> fetchRows(int index, int size) throws ServiceException {
        if (index <= 0) {
            throw new IllegalArgumentException("Parameter index should be greater than 0.");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Parameter size should be greater or equal than 0.");
        }
        Connection con = null;
        try {
            con = JDBCConnectionProvider.getConnection();
            ResultSet rs = this.createResultSet(con, size);
            PaginationResult result = new PaginationResult();
            ArrayList<T> list = new ArrayList<T>();
            result.setList(list);
            boolean absolute = rs.absolute(index);
            int rowNr = 0;
            if (!absolute) {
                rs.last();
                rowNr = rs.getRow();
                result.setCount(rowNr);
                PaginationResult paginationResult = result;
                return paginationResult;
            }
            while (size > 0) {
                list.add(this.creator.createEntity(rs));
                rowNr = rs.getRow();
                if (rowNr - index + 1 < size && rs.next()) continue;
            }
            rs.last();
            rowNr = rs.getRow();
            result.setCount(rowNr);
            log.debug((Object)("created list with " + list.size()));
            PaginationResult paginationResult = result;
            return paginationResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage(), e);
        }
        finally {
            JDBCConnectionProvider.close(con);
        }
    }

    public PaginationResult<T> goToPage(int pageNr, int pageSize) throws ServiceException {
        if (pageNr <= 0) {
            throw new IllegalArgumentException("Parameter pageNr should be greater than 0.");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Parameter pageSize should be greater than 0.");
        }
        Connection con = null;
        try {
            con = JDBCConnectionProvider.getConnection();
            ResultSet rs = this.createResultSet(con, pageSize);
            PaginationResult result = new PaginationResult();
            ArrayList<T> list = new ArrayList<T>();
            result.setList(list);
            rs.last();
            int totalRowNrs = rs.getRow();
            int pageNrs = (int)Math.ceil((double)totalRowNrs / (double)pageSize);
            result.setCount(pageNrs);
            int firstIndex = (pageNr - 1) * pageSize + 1;
            if (!rs.absolute(firstIndex)) {
                PaginationResult paginationResult = result;
                return paginationResult;
            }
            int rowNr = 0;
            do {
                list.add(this.creator.createEntity(rs));
            } while ((rowNr = rs.getRow()) - firstIndex - pageSize < -1 && totalRowNrs - rowNr > 0 && rs.next());
            PaginationResult paginationResult = result;
            return paginationResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage(), e);
        }
        finally {
            JDBCConnectionProvider.close(con);
        }
    }

    public PaginationResult<T> goToLastPage(int pageSize) throws ServiceException {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Parameter pageSize should be greater than 0.");
        }
        Connection con = null;
        try {
            con = JDBCConnectionProvider.getConnection();
            ResultSet rs = this.createResultSet(con, pageSize);
            PaginationResult result = new PaginationResult();
            ArrayList<T> list = new ArrayList<T>();
            result.setList(list);
            rs.last();
            int totalRowNrs = rs.getRow();
            int pageNrs = (int)Math.ceil((double)totalRowNrs / (double)pageSize);
            result.setCount(pageNrs);
            int firstIndex = (pageNrs - 1) * pageSize + 1;
            if (!rs.absolute(firstIndex)) {
                PaginationResult paginationResult = result;
                return paginationResult;
            }
            int rowNr = 0;
            do {
                list.add(this.creator.createEntity(rs));
            } while ((rowNr = rs.getRow()) - firstIndex - pageSize < -1 && totalRowNrs - rowNr > 0 && rs.next());
            PaginationResult paginationResult = result;
            return paginationResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage(), e);
        }
        finally {
            JDBCConnectionProvider.close(con);
        }
    }
}

