/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.backend.dao;

import com.bwanms.backend.dao.EntityHandler;
import com.bwanms.be.connection.JDBCConnectionProvider;
import com.bwanms.services.ServiceException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDAO<T extends Serializable> {
    private static final int BATCH_SIZE = 20;

    public T fetch(String tableName, long id, EntityHandler<T> handler) throws ServiceException {
        ResultSet rs;
        Statement stm;
        Connection con;
        block7: {
            T t;
            if (tableName == null || tableName.length() == 0) {
                throw new IllegalArgumentException("table is null or empty");
            }
            if (id <= 0L) {
                throw new IllegalArgumentException("id is undefined");
            }
            if (handler == null) {
                throw new IllegalArgumentException("entity handler is null");
            }
            con = null;
            stm = null;
            rs = null;
            try {
                con = JDBCConnectionProvider.getConnection();
                stm = con.createStatement();
                StringBuilder query = new StringBuilder();
                query.append("SELECT * FROM ").append(tableName).append(" WHERE id = ").append(id);
                rs = stm.executeQuery(query.toString());
                if (!rs.next()) break block7;
                t = handler.readEntity(rs);
            }
            catch (Exception e) {
                try {
                    throw new ServiceException(e);
                }
                catch (Throwable throwable) {
                    JDBCConnectionProvider.close(rs);
                    JDBCConnectionProvider.close(stm);
                    JDBCConnectionProvider.close(con);
                    throw throwable;
                }
            }
            JDBCConnectionProvider.close(rs);
            JDBCConnectionProvider.close(stm);
            JDBCConnectionProvider.close(con);
            return t;
        }
        JDBCConnectionProvider.close(rs);
        JDBCConnectionProvider.close(stm);
        JDBCConnectionProvider.close(con);
        return null;
    }

    public List<T> fetch(String tableName, String filter, String orderBy, String groupBy, EntityHandler<T> handler) throws ServiceException {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("table is null or empty");
        }
        if (handler == null) {
            throw new IllegalArgumentException("entity handler is null");
        }
        LinkedList<T> list = new LinkedList<T>();
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            con = JDBCConnectionProvider.getConnection();
            stm = con.createStatement();
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ").append(tableName);
            if (filter != null || filter.length() > 0) {
                query.append(" WHERE ").append(filter);
            }
            if (orderBy != null || orderBy.length() > 0) {
                query.append(" ORDER BY ").append(orderBy);
            }
            if (groupBy != null || groupBy.length() > 0) {
                query.append(" GROUP BY ").append(groupBy);
            }
            rs = stm.executeQuery(query.toString());
            while (rs.next()) {
                list.add(handler.readEntity(rs));
            }
        }
        catch (Exception e) {
            try {
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(rs);
                JDBCConnectionProvider.close(stm);
                JDBCConnectionProvider.close(con);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(rs);
        JDBCConnectionProvider.close(stm);
        JDBCConnectionProvider.close(con);
        return list;
    }

    public List<Object[]> fetch(String tableName, String[] columnNames, String filter, String orderBy, String groupBy) throws Exception {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("table is null or empty");
        }
        LinkedList<Object[]> list = new LinkedList<Object[]>();
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            con = JDBCConnectionProvider.getConnection();
            stm = con.createStatement();
            StringBuilder query = new StringBuilder();
            if (columnNames == null || columnNames.length == 0) {
                query.append("SELECT * FROM ").append(tableName);
            } else {
                query.append("SELECT ");
                for (int i = 0; i < columnNames.length - 1; ++i) {
                    query.append(columnNames[i]).append(", ");
                }
                query.append(columnNames[columnNames.length - 1]).append(" FROM ").append(tableName);
            }
            if (filter != null || filter.length() > 0) {
                query.append(" WHERE ").append(filter);
            }
            if (orderBy != null || orderBy.length() > 0) {
                query.append(" ORDER BY ").append(orderBy);
            }
            if (groupBy != null || groupBy.length() > 0) {
                query.append(" GROUP BY ").append(groupBy);
            }
            rs = stm.executeQuery(query.toString());
            while (rs.next()) {
                Object[] values = new Object[columnNames.length];
                for (int i = 0; i < columnNames.length; ++i) {
                    rs.getObject(columnNames[i]);
                }
                list.add(values);
            }
        }
        catch (Exception e) {
            try {
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(rs);
                JDBCConnectionProvider.close(stm);
                JDBCConnectionProvider.close(con);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(rs);
        JDBCConnectionProvider.close(stm);
        JDBCConnectionProvider.close(con);
        return list;
    }

    public int update(String tableName, String[] columnNames, Object[] values, String filter) throws ServiceException {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("table is null or empty");
        }
        if (columnNames == null || columnNames.length == 0) {
            throw new IllegalArgumentException("columns array is null or empty");
        }
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("values array is null or empty");
        }
        if (columnNames.length != values.length) {
            throw new IllegalArgumentException("values number does not match the columns number");
        }
        int rowCount = -1;
        Connection con = null;
        PreparedStatement stm = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ").append(tableName).append(" SET ");
            int i = 0;
            for (i = 0; i < columnNames.length - 1; ++i) {
                query.append(columnNames[i]).append(" = ?, ");
            }
            query.append(columnNames[i]).append(" = ? ");
            if (filter != null && filter.length() > 0) {
                query.append("WHERE ").append(filter);
            }
            con = JDBCConnectionProvider.getConnection();
            stm = con.prepareStatement(query.toString());
            for (i = 0; i < values.length; ++i) {
                stm.setObject(i + 1, values[i]);
            }
            rowCount = stm.executeUpdate();
            con.commit();
        }
        catch (Exception e) {
            try {
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stm);
                JDBCConnectionProvider.close(con);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stm);
        JDBCConnectionProvider.close(con);
        return rowCount;
    }

    public void update(String tableName, String[] columnNames, List<T> list, EntityHandler<T> handler) throws ServiceException {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("table is null or empty");
        }
        if (columnNames == null || columnNames.length == 0) {
            throw new IllegalArgumentException("columns array is null or empty");
        }
        if (handler == null) {
            throw new IllegalArgumentException("entity handler is null");
        }
        Connection con = null;
        PreparedStatement stm = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ").append(tableName).append(" SET ");
            int i = 0;
            for (i = 0; i < columnNames.length - 1; ++i) {
                query.append(columnNames[i]).append(" = ?, ");
            }
            query.append(columnNames[i]).append(" = ? ");
            query.append("WHERE id = ?");
            con = JDBCConnectionProvider.getConnection();
            stm = con.prepareStatement(query.toString());
            int cnt = 0;
            for (Serializable t : list) {
                handler.writeEntity(t, stm);
                stm.addBatch();
                if (++cnt % 20 != 0) continue;
                stm.executeBatch();
            }
            if (cnt % 20 != 0) {
                stm.executeBatch();
            }
            con.commit();
        }
        catch (Exception e) {
            try {
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stm);
                JDBCConnectionProvider.close(con);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stm);
        JDBCConnectionProvider.close(con);
    }

    public int delete(String tableName, String filter) throws ServiceException {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("table is null or empty");
        }
        int rowCount = -1;
        Connection con = null;
        Statement stm = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM").append(tableName);
            if (filter != null && filter.length() > 0) {
                query.append("WHERE ").append(filter);
            }
            con = JDBCConnectionProvider.getConnection();
            stm = con.createStatement();
            rowCount = stm.executeUpdate(query.toString());
            con.commit();
        }
        catch (Exception e) {
            try {
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stm);
                JDBCConnectionProvider.close(con);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stm);
        JDBCConnectionProvider.close(con);
        return rowCount;
    }

    public int delete(String tableName, long id) throws ServiceException {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("table is null or empty");
        }
        int rowCount = -1;
        Connection con = null;
        PreparedStatement stm = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM").append(tableName).append("WHERE id = ?");
            con = JDBCConnectionProvider.getConnection();
            stm = con.prepareStatement(query.toString());
            stm.setLong(1, id);
            rowCount = stm.executeUpdate();
            con.commit();
        }
        catch (Exception e) {
            try {
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stm);
                JDBCConnectionProvider.close(con);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stm);
        JDBCConnectionProvider.close(con);
        return rowCount;
    }

    public void delete(String tableName, List<T> list, EntityHandler<T> handler) throws ServiceException {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("table is null or empty");
        }
        if (handler == null) {
            throw new IllegalArgumentException("entity handler is null");
        }
        Connection con = null;
        PreparedStatement stm = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ").append(tableName).append(" WHERE id = ?");
            con = JDBCConnectionProvider.getConnection();
            stm = con.prepareStatement(query.toString());
            int cnt = 0;
            for (Serializable t : list) {
                handler.writeEntity(t, stm);
                stm.addBatch();
                if (++cnt % 20 != 0) continue;
                stm.executeBatch();
            }
            if (cnt % 20 != 0) {
                stm.executeBatch();
            }
            con.commit();
        }
        catch (Exception e) {
            try {
                throw new ServiceException(e);
            }
            catch (Throwable throwable) {
                JDBCConnectionProvider.close(stm);
                JDBCConnectionProvider.close(con);
                throw throwable;
            }
        }
        JDBCConnectionProvider.close(stm);
        JDBCConnectionProvider.close(con);
    }
}

