/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.aspects;

import com.bwanms.persistence.CallableDatastoreDecorator;
import com.bwanms.persistence.Datastore;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.collection.PersistentCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Aspect
public class LIEAspect {
    private static final Logger log = Logger.getLogger(LIEAspect.class);

    @Pointcut(value="call(@(javax.persistence.OneToMany || javax.persistence.ManyToMany) java.util.Collection+ (@javax.persistence.Entity com.bwanms..*).get*( )) && target(target)")
    public void liePcCollection(Object target, JoinPoint jp) {
    }

    @Pointcut(value="call(@(javax.persistence.OneToOne) java.io.Serializable+ (@javax.persistence.Entity com.bwanms..*).get*( )) && target(target)")
    public void liePcProxy(Object target, JoinPoint jp) {
    }

    @AfterReturning(pointcut="liePcCollection(target, jp)", returning="ret")
    public void afterLie(final Object target, JoinPoint jp, Collection<?> ret) {
        log.debug((Object)"\n[LIE aspect][IN]");
        Signature signature = jp.getSignature();
        final String name = signature.getName();
        String typeName = signature.getDeclaringType().getName();
        log.debug((Object)String.format("[SIGNATURE] Name =  %s", name));
        log.debug((Object)String.format("[SIGNATURE] Declaring type name =  %s", typeName));
        if (PersistentCollection.class.isAssignableFrom(ret.getClass())) {
            if (!Hibernate.isInitialized(ret)) {
                log.debug((Object)"Collection is not initilized yet.");
                try {
                    new CallableDatastoreDecorator<Serializable>(new Callable<Serializable>(){

                        @Override
                        public Serializable call() throws Exception {
                            Method method = target.getClass().getMethod(name, new Class[0]);
                            LIEAspect.initialize(Datastore.session(), target, method);
                            return null;
                        }
                    }).call();
                }
                catch (SecurityException ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (NoSuchMethodException ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            } else {
                log.debug((Object)"Collection was already initilized.");
            }
        }
    }

    @AfterReturning(pointcut="liePcProxy(target, jp)", returning="ret")
    public void afterLieProxy(final Object target, JoinPoint jp, Serializable ret) {
        log.debug((Object)"\n[LIE aspect][IN]");
        Signature signature = jp.getSignature();
        final String name = signature.getName();
        String typeName = signature.getDeclaringType().getName();
        log.debug((Object)String.format("[SIGNATURE] Name =  %s", name));
        log.debug((Object)String.format("[SIGNATURE] Declaring type name =  %s", typeName));
        if (!Hibernate.isInitialized((Object)ret)) {
            log.debug((Object)"Proxy is not hit yet.");
            try {
                new CallableDatastoreDecorator<Serializable>(new Callable<Serializable>(){

                    @Override
                    public Serializable call() throws Exception {
                        Method method = target.getClass().getMethod(name, new Class[0]);
                        LIEAspect.initialize(Datastore.session(), target, method);
                        return null;
                    }
                }).call();
            }
            catch (SecurityException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            log.debug((Object)"Proxy was already hit.");
        }
    }

    public static void initialize(Session ses, Object parent, Method method) {
        ses.lock(parent, LockMode.READ);
        try {
            Object ret = method.invoke(parent, new Object[0]);
            Hibernate.initialize((Object)ret);
            log.debug((Object)String.format("Collection for '%s' getter was succesfully initialized on '%s' instance.", method.getName(), parent.getClass().getName()));
        }
        catch (IllegalArgumentException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

