/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms;

import com.bwanms.gui.Internationalizer;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LogCodeProvider {
    private static final Logger LOG = Logger.getLogger((String)LogCodeProvider.class.getName());
    private static Map<String, String> logs = new HashMap<String, String>();
    private static Internationalizer i18n = Internationalizer.getInternationalizer(LogCodeProvider.class);

    public static String getLogForCode(String code, Object ... params) {
        if (i18n != null) {
            return String.format(logs.get(code), params);
        }
        return String.format(code, params);
    }

    public static String getLogForCode(String code) {
        return LogCodeProvider.getLogForCode(code, null);
    }

    public static void redirectLogForCode(PrintStream ps, String code, Object ... params) {
        ps.println(LogCodeProvider.getLogForCode(code, params));
    }

    public static void redirectLogForCode(PrintStream ps, String code) {
        LogCodeProvider.redirectLogForCode(ps, code, null);
    }

    static {
        if (i18n != null) {
            logs.put("ASTR-000", i18n.translateString("ASTR-000"));
            logs.put("ASTR-100", i18n.translateString("ASTR-100"));
        } else {
            LOG.debug((Object)"The internationalizer is null.");
        }
    }
}

