<xsl:stylesheet version = '1.1'	xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:param name="currVersion"/>
<xsl:param name="finalVersion"/>

<xsl:output method="xml" indent="yes" />

<xsl:template match = "configuration" >
	<xsl:element name="configuration">
		<xsl:attribute name="version" ><xsl:value-of select="@version"/></xsl:attribute>
		<xsl:attribute name="date" ><xsl:value-of select="@date"/></xsl:attribute>
		<xsl:for-each select="//partition">
			<xsl:choose>
				<xsl:when test="@module='rb'">
					<!--xsl:apply-templates select="current()"/-->
					<xsl:if test="$currVersion &lt; 2">
						<xsl:choose>
							<xsl:when test="$currVersion=1">
								<xsl:call-template name="transf12"/>
							</xsl:when>
						</xsl:choose>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="current()"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:element>

</xsl:template>

<xsl:template match="partition" name="transf12">
	<xsl:element name="partition">

		<xsl:attribute name="module" ><xsl:value-of select="current()/@module"/></xsl:attribute>
		<xsl:attribute name="version" ><xsl:value-of select="current()/@version + 1"/></xsl:attribute>

		<!-- only for tracing -->
		<xsl:element name="transf-applied">
			<xsl:attribute name="oldVersion"><xsl:value-of select="$currVersion"/></xsl:attribute>
			<xsl:attribute name="newVersion"><xsl:value-of select="$currVersion + 1"/></xsl:attribute>
		</xsl:element>
		<!-- only for tracing -->

		<xsl:for-each select="child::*">
			<xsl:choose>
				<xsl:when test="@type='com.bwanms.rb.model.RbBS' or @type='com.bwanms.rb.model.RbMBS'">
					<xsl:element name="object">
						<xsl:attribute name="type" ><xsl:value-of select="current()/@type"/></xsl:attribute>
						<xsl:attribute name="uid" ><xsl:value-of select="current()/@uid"/></xsl:attribute>

						<xsl:for-each select="child::*">
							<xsl:if test="@name!='synchronizationRequest' and @name!='supportedServiceProfiles' and @name!='auChannels' and @name!='odus' and @name!='radioClusters'">
								<xsl:copy-of select="current()"/>
							</xsl:if>
						</xsl:for-each>
					</xsl:element>
				</xsl:when>
				<xsl:when test="@type='com.bwanms.rb.model.RbAU'">
					<xsl:element name="object">
						<xsl:attribute name="type" ><xsl:value-of select="current()/@type"/></xsl:attribute>
						<xsl:attribute name="uid" ><xsl:value-of select="current()/@uid"/></xsl:attribute>

						<xsl:for-each select="child::*">
							<xsl:if test="@name!='serialNo'">
								<xsl:copy-of select="current()"/>
							</xsl:if>
						</xsl:for-each>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="current()"/>
				</xsl:otherwise>
			</xsl:choose>

		</xsl:for-each>

	</xsl:element>
</xsl:template>



</xsl:stylesheet>