/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ws.impl;

import com.bwanms.ddi.ServiceManagementException;
import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.mo.DuplicateEntryException;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.TableRowMO;
import com.bwanms.model.Equipment;
import com.bwanms.persistence.RunnableDatastoreDecorator;
import com.bwanms.rb.ddi.RbServiceDeploymentHelper;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbRegisteredSuTable;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigTable;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigTable;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbSubscriberTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.ws.WsBsData;
import com.bwanms.rb.ws.WsBsListResponse;
import com.bwanms.rb.ws.WsCPEDetailsResponse;
import com.bwanms.rb.ws.WsQueryServiceMACResponse;
import com.bwanms.rb.ws.WsRadioLinkStatusResponse;
import com.bwanms.rb.ws.WsResponse;
import com.bwanms.rb.ws.WsServiceListResponse;
import com.bwanms.rb.ws.WsServiceMACData;
import com.bwanms.rb.ws.WsServiceManagement;
import com.bwanms.rb.ws.WsServiceProfileData;
import com.bwanms.rb.ws.WsServiceProfileListResponse;
import com.bwanms.rb.ws.WsServiceStatusResponse;
import com.bwanms.rb.ws.impl.WsException;
import com.bwanms.rb.ws.impl.WsLicenseHelper;
import com.bwanms.rb.ws.impl.WsServiceManagementHelper;
import com.bwanms.util.MacAddress;
import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionFactory;
import com.bwanms.util.version.impl.DefaultVersion;
import java.util.List;
import org.apache.log4j.Logger;

public class WsServiceManagementImpl
implements WsServiceManagement {
    private static final Logger log = Logger.getLogger(WsServiceManagementImpl.class);
    private static final boolean skipCheckingServiceStatus = Boolean.getBoolean("com.bwanms.rb.ws.skipCheckingServiceStatus");

    public WsResponse serviceCreate(final String bsIP, final String serviceName, final String subscriberId, final String cpeMacF, final String vlans, final String serviceProfileName, final String hybridVlanModeF, final String vlanClasificationModeF, final String accessVlanF, final String adminStatusF) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- serviceCreate ---------------");
            log.debug((Object)("bsIP:                   " + bsIP));
            log.debug((Object)("serviceName:            " + serviceName));
            log.debug((Object)("subscriberId:           " + subscriberId));
            log.debug((Object)("cpeMac:                 " + cpeMacF));
            log.debug((Object)("vlans:                  " + vlans));
            log.debug((Object)("serviceProfileName:     " + serviceProfileName));
            log.debug((Object)("hybridVlanModeF:        " + hybridVlanModeF));
            log.debug((Object)("vlanClasificationModeF: " + vlanClasificationModeF));
            log.debug((Object)("accessVlanF:            " + accessVlanF));
            log.debug((Object)("adminStatusF:           " + adminStatusF));
            log.debug((Object)"-------------------------------------------");
        }
        final WsResponse[] response = new WsResponse[1];
        final Object[] operStatusParameters = new Object[3];
        final boolean adminStatusEnable = adminStatusF.equalsIgnoreCase("enable") || adminStatusF.equalsIgnoreCase("enabled") || adminStatusF.equalsIgnoreCase("true");
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        log.debug((Object)WsResponse.ERROR_WS_NOT_LICENSED);
                        response[0] = WsResponse.ERROR_WS_NOT_LICENSED;
                        return;
                    }
                    WsResponse validateError = WsServiceManagementHelper.validateServiceCreateModifyInput(bsIP, serviceName, subscriberId, cpeMacF, vlans, serviceProfileName, hybridVlanModeF, vlanClasificationModeF, accessVlanF, adminStatusF);
                    if (validateError != null) {
                        response[0] = validateError;
                        return;
                    }
                    String cpeMac = WsServiceManagementHelper.getMacAddressFromString(cpeMacF);
                    RbBaseStationEquipment equipment = WsServiceManagementHelper.getBaseStationByIP(bsIP);
                    if (equipment == null) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_FOUND);
                        response[0] = WsResponse.ERROR_BS_NOT_FOUND;
                        return;
                    }
                    if (!LicenseHelper.isLicensed((Object)((Object)equipment))) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_LICENSED);
                        response[0] = WsResponse.ERROR_BS_NOT_LICENSED;
                        return;
                    }
                    if (!equipment.isReachable()) {
                        log.debug((Object)WsResponse.ERROR_BS_UNREACHABLE);
                        response[0] = WsResponse.ERROR_BS_UNREACHABLE;
                        return;
                    }
                    List<ManagedObject> managedObjects = WsServiceManagementHelper.getMOs(equipment);
                    if (managedObjects == null) {
                        log.debug((Object)("getMOs " + WsResponse.ERROR_BS_AGENT));
                        response[0] = WsResponse.ERROR_BS_AGENT;
                        return;
                    }
                    RbSubscriberTable subscriberTable = (RbSubscriberTable)managedObjects.get(0);
                    RbSubscriberEntry subscriber = subscriberTable.findEntryBySubscriberID(subscriberId);
                    if (subscriber == null) {
                        log.debug((Object)WsResponse.ERROR_SUBSCRIBER_NOT_EXIST);
                        response[0] = WsResponse.ERROR_SUBSCRIBER_NOT_EXIST;
                        return;
                    }
                    RbServiceConfigTable configTable = (RbServiceConfigTable)managedObjects.get(1);
                    if (configTable.findEntryByName(serviceName) != null) {
                        log.debug((Object)WsResponse.ERROR_SERVICE_NAME_EXISTS);
                        response[0] = WsResponse.ERROR_SERVICE_NAME_EXISTS;
                        return;
                    }
                    RbServiceTemplateConfigTable templateConfigTable = (RbServiceTemplateConfigTable)managedObjects.get(2);
                    RbServiceTemplateConfigEntry serviceProfile = templateConfigTable.findEntryByName(serviceProfileName);
                    if (serviceProfile == null) {
                        log.debug((Object)WsResponse.ERROR_INPUT_SERVICE_PROFILE_NAME);
                        response[0] = WsResponse.ERROR_INPUT_SERVICE_PROFILE_NAME;
                        return;
                    }
                    RbServiceConfigEntry entry = new RbServiceConfigEntry(equipment.isTDDDuplexMode());
                    entry.setRbServiceIdx(-1L);
                    entry.setRbServiceName(serviceName);
                    entry.setRbServiceSuMacAddress(MacAddress.fromSimpleString((String)cpeMac).toOctetString());
                    entry.setRbServiceServiceTemplateIdx(serviceProfile.getRbServiceTemplateIdx());
                    entry.setRbServiceServiceTemplateName(serviceProfileName);
                    entry.setRbServiceType(serviceProfile.getRbServiceTemplateType());
                    entry.setRbSubscriberIdx(subscriber.getRbSubscriberIdx());
                    entry.setRbServiceAdminStatus(adminStatusEnable ? 1 : 2);
                    int accessVlan = WsServiceManagementHelper.isEmptyString(accessVlanF) || accessVlanF.equalsIgnoreCase("none") ? 4095 : Integer.parseInt(accessVlanF);
                    entry.setRbServiceAccessVLAN(accessVlan);
                    boolean hybridVlanModeOn = hybridVlanModeF.equalsIgnoreCase("on") || hybridVlanModeF.equalsIgnoreCase("true");
                    entry.setRbServiceVLANHybridMode(hybridVlanModeOn ? 1 : 2);
                    boolean vlanClasificationModeOn = vlanClasificationModeF.equalsIgnoreCase("on") || vlanClasificationModeF.equalsIgnoreCase("true");
                    entry.setRbServiceVLANClassificationMode(vlanClasificationModeOn ? 2 : 1);
                    if (!WsServiceManagementHelper.setVLANListFromCommaSeparated(entry, vlans)) {
                        log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_MaximumVLANsAllowedPerSUExceeded);
                        response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_MaximumVLANsAllowedPerSUExceeded;
                        return;
                    }
                    WsResponse responseError = WsServiceManagementHelper.configureEntity(entry, templateConfigTable.getEntries());
                    if (!responseError.equals(WsResponse.SUCCESS)) {
                        log.debug((Object)responseError);
                        response[0] = responseError;
                        return;
                    }
                    try {
                        RbServiceDeploymentHelper.checkServiceDeployment(entry, configTable, templateConfigTable);
                    }
                    catch (ServiceManagementException e) {
                        if (e.getMessage().equals("MaximumVLANsAllowedPerSUExceeded")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_MaximumVLANsAllowedPerSUExceeded, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_MaximumVLANsAllowedPerSUExceeded;
                            return;
                        }
                        if (e.getMessage().equals("AccessVLANcantbeequaltoanyVLANintheSUVLANlist")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_AccessVLANcannotbeequaltoanyVLANintheSUVLANlist, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_AccessVLANcannotbeequaltoanyVLANintheSUVLANlist;
                            return;
                        }
                        if (e.getMessage().equals("TransparentVLANIDAndVPLIDMismatch")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_TransparentVLANIDAndVPLIDMismatch, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_TransparentVLANIDAndVPLIDMismatch;
                            return;
                        }
                        if (e.getMessage().equals("AServiceWithSameNameAndDifferentTypeAlreadyDeployed")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_AServiceWithSameNameAndDifferentTypeAlreadyDeployed, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_AServiceWithSameNameAndDifferentTypeAlreadyDeployed;
                            return;
                        }
                        if (e.getMessage().equals("CantAllocateOnTheSameSUPipesWithAndWithoutVLANs")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_CannotAllocateOnTheSameSUPipesWithAndWithoutVLANs, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_CannotAllocateOnTheSameSUPipesWithAndWithoutVLANs;
                            return;
                        }
                        if (e.getMessage().equals("OnlyoneAccessVLANallowedperSU")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_OnlyoneAccessVLANallowedperSU, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_OnlyoneAccessVLANallowedperSU;
                            return;
                        }
                        if (e.getMessage().equals("CannotCreate2ServicesWithEitherTheSameTypeOrVoIPL2OnTheSameVLAN")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_CannotCreate2ServicesWithEitherTheSameTypeOrVoIPL2OnTheSameVLAN, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_CannotCreate2ServicesWithEitherTheSameTypeOrVoIPL2OnTheSameVLAN;
                            return;
                        }
                        log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT, (Throwable)e);
                        response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT;
                        return;
                    }
                    RbRegisteredSuTable registeredSuTable = (RbRegisteredSuTable)managedObjects.get(3);
                    responseError = WsServiceManagementHelper.checkMacAddress(equipment, entry, registeredSuTable);
                    if (!responseError.equals(WsResponse.SUCCESS)) {
                        log.debug((Object)responseError);
                        response[0] = responseError;
                        return;
                    }
                    configTable = (RbServiceConfigTable)configTable.clone();
                    configTable.addEntry((TableRowMO)entry);
                    if (!WsServiceManagementHelper.submitMO((ManagedObject)configTable, equipment)) {
                        log.debug((Object)("create service " + WsResponse.ERROR_BS_AGENT));
                        response[0] = WsResponse.ERROR_BS_AGENT;
                        return;
                    }
                    operStatusParameters[0] = equipment;
                    operStatusParameters[1] = entry.getRbServiceIdx();
                    operStatusParameters[2] = entry.getRbSubscriberIdx();
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response[0] = WsResponse.ERROR;
                    return;
                }
                response[0] = WsResponse.SUCCESS;
            }
        }).run();
        if (skipCheckingServiceStatus || !adminStatusEnable || response[0] != WsResponse.SUCCESS) {
            return response[0];
        }
        return WsServiceManagementHelper.getOperationalStatus((Equipment)operStatusParameters[0], (Long)operStatusParameters[1], (Long)operStatusParameters[2], 1, 2000L);
    }

    public WsResponse serviceModify(final String bsIP, final String serviceName, final String subscriberId, final String cpeMacF, final String vlans, final String serviceProfileName, final String hybridVlanModeF, final String vlanClasificationModeF, final String accessVlanF, final String adminStatusF) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- serviceModify ---------------");
            log.debug((Object)("bsIP:                   " + bsIP));
            log.debug((Object)("serviceName:            " + serviceName));
            log.debug((Object)("subscriberId:           " + subscriberId));
            log.debug((Object)("cpeMac:                 " + cpeMacF));
            log.debug((Object)("vlans:                  " + vlans));
            log.debug((Object)("serviceProfileName:     " + serviceProfileName));
            log.debug((Object)("hybridVlanModeF:        " + hybridVlanModeF));
            log.debug((Object)("vlanClasificationModeF: " + vlanClasificationModeF));
            log.debug((Object)("accessVlanF:            " + accessVlanF));
            log.debug((Object)("adminStatusF:           " + adminStatusF));
            log.debug((Object)"-------------------------------------------");
        }
        final boolean adminStatusEnable = adminStatusF.equalsIgnoreCase("enable") || adminStatusF.equalsIgnoreCase("enabled") || adminStatusF.equalsIgnoreCase("true");
        final WsResponse[] response = new WsResponse[1];
        final Object[] operStatusParameters = new Object[3];
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    RbRegisteredSuTable registeredSuTable;
                    RbSubscriberTable subscriberTable;
                    RbSubscriberEntry subscriber;
                    if (!WsLicenseHelper.isLicensedWS()) {
                        log.debug((Object)WsResponse.ERROR_WS_NOT_LICENSED);
                        response[0] = WsResponse.ERROR_WS_NOT_LICENSED;
                        return;
                    }
                    WsResponse validateError = WsServiceManagementHelper.validateServiceCreateModifyInput(bsIP, serviceName, subscriberId, cpeMacF, vlans, serviceProfileName, hybridVlanModeF, vlanClasificationModeF, accessVlanF, adminStatusF);
                    if (validateError != null) {
                        response[0] = validateError;
                        return;
                    }
                    RbBaseStationEquipment baseStation = WsServiceManagementHelper.getBaseStationByIP(bsIP);
                    if (baseStation == null) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_FOUND);
                        response[0] = WsResponse.ERROR_BS_NOT_FOUND;
                        return;
                    }
                    if (!LicenseHelper.isLicensed((Object)((Object)baseStation))) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_LICENSED);
                        response[0] = WsResponse.ERROR_BS_NOT_LICENSED;
                        return;
                    }
                    if (!baseStation.isReachable()) {
                        log.debug((Object)WsResponse.ERROR_BS_UNREACHABLE);
                        response[0] = WsResponse.ERROR_BS_UNREACHABLE;
                        return;
                    }
                    List<ManagedObject> managedObjects = WsServiceManagementHelper.getMOs(baseStation);
                    if (managedObjects == null) {
                        log.debug((Object)("getMOs " + WsResponse.ERROR_BS_AGENT));
                        response[0] = WsResponse.ERROR_BS_AGENT;
                        return;
                    }
                    RbServiceConfigTable configTable = (RbServiceConfigTable)managedObjects.get(1).clone();
                    RbServiceConfigEntry entry = configTable.findEntryByName(serviceName);
                    if (entry == null) {
                        log.debug((Object)WsResponse.ERROR_SERVICE_NAME_NOT_EXIST);
                        response[0] = WsResponse.ERROR_SERVICE_NAME_NOT_EXIST;
                        return;
                    }
                    boolean cpeMacUpdate = false;
                    String cpeMac = WsServiceManagementHelper.getMacAddressFromString(cpeMacF);
                    if (!entry.getRbServiceSuMacAddress().equalsIgnoreCase(MacAddress.fromSimpleString((String)cpeMac).toOctetString())) {
                        if (1 == entry.getRbServiceAdminStatus() || VersionFactory.getInstance().createVersion(baseStation.getRunningSoftwareVersion()).isNewerOrEqualWith((Version)new DefaultVersion("4.0"))) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_CPEMAC_MISMATCH);
                            response[0] = WsResponse.ERROR_SERVICE_CPEMAC_MISMATCH;
                            return;
                        }
                        entry.setRbServiceSuMacAddress(MacAddress.fromSimpleString((String)cpeMac).toOctetString());
                        cpeMacUpdate = true;
                    }
                    if ((subscriber = (subscriberTable = (RbSubscriberTable)managedObjects.get(0)).findEntryBySubscriberID(subscriberId)) == null) {
                        log.debug((Object)WsResponse.ERROR_SUBSCRIBER_NOT_EXIST);
                        response[0] = WsResponse.ERROR_SUBSCRIBER_NOT_EXIST;
                        return;
                    }
                    if (!entry.getRbSubscriberIdx().equals(subscriber.getRbSubscriberIdx())) {
                        log.debug((Object)WsResponse.ERROR_SUBSCRIBER_NOT_MATCH);
                        response[0] = WsResponse.ERROR_SUBSCRIBER_NOT_MATCH;
                        return;
                    }
                    RbServiceTemplateConfigTable templateConfigTable = (RbServiceTemplateConfigTable)managedObjects.get(2);
                    RbServiceTemplateConfigEntry serviceProfile = templateConfigTable.findEntryByName(serviceProfileName);
                    if (serviceProfile == null || !serviceProfile.getRbServiceTemplateType().equals(entry.getRbServiceType())) {
                        log.debug((Object)WsResponse.ERROR_INPUT_SERVICE_PROFILE_NAME);
                        response[0] = WsResponse.ERROR_INPUT_SERVICE_PROFILE_NAME;
                        return;
                    }
                    entry.setRbServiceServiceTemplateIdx(serviceProfile.getRbServiceTemplateIdx());
                    entry.setRbServiceServiceTemplateName(serviceProfileName);
                    entry.setRbServiceAdminStatus(adminStatusEnable ? 1 : 2);
                    int accessVlan = WsServiceManagementHelper.isEmptyString(accessVlanF) || accessVlanF.equalsIgnoreCase("none") ? 4095 : Integer.parseInt(accessVlanF);
                    entry.setRbServiceAccessVLAN(accessVlan);
                    boolean hybridVlanModeOn = hybridVlanModeF.equalsIgnoreCase("on") || hybridVlanModeF.equalsIgnoreCase("true");
                    entry.setRbServiceVLANHybridMode(hybridVlanModeOn ? 1 : 2);
                    boolean vlanClasificationModeOn = vlanClasificationModeF.equalsIgnoreCase("on") || vlanClasificationModeF.equalsIgnoreCase("true");
                    entry.setRbServiceVLANClassificationMode(vlanClasificationModeOn ? 2 : 1);
                    if (!WsServiceManagementHelper.setVLANListFromCommaSeparated(entry, vlans)) {
                        log.debug((Object)WsResponse.ERROR_INPUT_VLAN);
                        response[0] = WsResponse.ERROR_INPUT_VLAN;
                        return;
                    }
                    WsResponse responseError = WsServiceManagementHelper.configureEntity(entry, templateConfigTable.getEntries());
                    if (!responseError.equals(WsResponse.SUCCESS)) {
                        log.debug((Object)responseError);
                        response[0] = responseError;
                        return;
                    }
                    try {
                        RbServiceDeploymentHelper.checkServiceDeployment(entry, configTable, templateConfigTable);
                    }
                    catch (ServiceManagementException e) {
                        if (e.getMessage().equals("MaximumVLANsAllowedPerSUExceeded")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_MaximumVLANsAllowedPerSUExceeded, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_MaximumVLANsAllowedPerSUExceeded;
                        } else if (e.getMessage().equals("AccessVLANcantbeequaltoanyVLANintheSUVLANlist")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_AccessVLANcannotbeequaltoanyVLANintheSUVLANlist, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_AccessVLANcannotbeequaltoanyVLANintheSUVLANlist;
                        } else if (e.getMessage().equals("TransparentVLANIDAndVPLIDMismatch")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_TransparentVLANIDAndVPLIDMismatch, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_TransparentVLANIDAndVPLIDMismatch;
                        } else if (e.getMessage().equals("AServiceWithSameNameAndDifferentTypeAlreadyDeployed")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_AServiceWithSameNameAndDifferentTypeAlreadyDeployed, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_AServiceWithSameNameAndDifferentTypeAlreadyDeployed;
                        } else if (e.getMessage().equals("CantAllocateOnTheSameSUPipesWithAndWithoutVLANs")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_CannotAllocateOnTheSameSUPipesWithAndWithoutVLANs, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_CannotAllocateOnTheSameSUPipesWithAndWithoutVLANs;
                        } else if (e.getMessage().equals("OnlyoneAccessVLANallowedperSU")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_OnlyoneAccessVLANallowedperSU, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_OnlyoneAccessVLANallowedperSU;
                        } else if (e.getMessage().equals("CannotCreate2ServicesWithEitherTheSameTypeOrVoIPL2OnTheSameVLAN")) {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT_CannotCreate2ServicesWithEitherTheSameTypeOrVoIPL2OnTheSameVLAN, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT_CannotCreate2ServicesWithEitherTheSameTypeOrVoIPL2OnTheSameVLAN;
                        } else {
                            log.debug((Object)WsResponse.ERROR_SERVICE_DEPLOYMENT, (Throwable)e);
                            response[0] = WsResponse.ERROR_SERVICE_DEPLOYMENT;
                        }
                        return;
                    }
                    if (cpeMacUpdate && !(responseError = WsServiceManagementHelper.checkMacAddress(baseStation, entry, registeredSuTable = (RbRegisteredSuTable)managedObjects.get(3))).equals(WsResponse.SUCCESS)) {
                        log.debug((Object)responseError);
                        response[0] = responseError;
                        return;
                    }
                    if (!WsServiceManagementHelper.submitMO((ManagedObject)configTable, baseStation)) {
                        log.debug((Object)("modify service " + WsResponse.ERROR_BS_AGENT));
                        response[0] = WsResponse.ERROR_BS_AGENT;
                        return;
                    }
                    operStatusParameters[0] = baseStation;
                    operStatusParameters[1] = entry.getRbServiceIdx();
                    operStatusParameters[2] = entry.getRbSubscriberIdx();
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response[0] = WsResponse.ERROR;
                    return;
                }
                response[0] = WsResponse.SUCCESS;
            }
        }).run();
        if (skipCheckingServiceStatus || !adminStatusEnable || response[0] != WsResponse.SUCCESS) {
            return response[0];
        }
        return WsServiceManagementHelper.getOperationalStatus((Equipment)operStatusParameters[0], (Long)operStatusParameters[1], (Long)operStatusParameters[2], 1, 2000L);
    }

    public WsResponse serviceDelete(final String bsIP, final String serviceName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- serviceDelete ---------------");
            log.debug((Object)("bsIP:              " + bsIP));
            log.debug((Object)("serviceName:       " + serviceName));
            log.debug((Object)"-------------------------------------------");
        }
        final WsResponse[] response = new WsResponse[1];
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        log.debug((Object)WsResponse.ERROR_WS_NOT_LICENSED);
                        response[0] = WsResponse.ERROR_WS_NOT_LICENSED;
                        return;
                    }
                    WsResponse isEmptyField = WsServiceManagementHelper.isEmptyField(bsIP, serviceName, "serviceProfileName", "subscriberId", "cpeMacF");
                    if (isEmptyField != null) {
                        response[0] = isEmptyField;
                        return;
                    }
                    RbBaseStationEquipment equipment = WsServiceManagementHelper.getBaseStationByIP(bsIP);
                    if (equipment == null) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_FOUND);
                        response[0] = WsResponse.ERROR_BS_NOT_FOUND;
                        return;
                    }
                    if (!LicenseHelper.isLicensed((Object)((Object)equipment))) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_LICENSED);
                        response[0] = WsResponse.ERROR_BS_NOT_LICENSED;
                        return;
                    }
                    if (!equipment.isReachable()) {
                        log.debug((Object)WsResponse.ERROR_BS_UNREACHABLE);
                        response[0] = WsResponse.ERROR_BS_UNREACHABLE;
                        return;
                    }
                    RbServiceConfigTable serviceTable = (RbServiceConfigTable)WsServiceManagementHelper.getMOFromEquipment(equipment, RbServiceConfigTable.class).clone();
                    if (serviceTable == null) {
                        log.debug((Object)("get RbServiceConfigTable " + WsResponse.ERROR_BS_AGENT));
                        response[0] = WsResponse.ERROR_BS_AGENT;
                        return;
                    }
                    RbServiceConfigEntry entry = serviceTable.findEntryByName(serviceName);
                    if (entry == null) {
                        log.debug((Object)WsResponse.ERROR_SERVICE_NAME_NOT_EXIST);
                        response[0] = WsResponse.ERROR_SERVICE_NAME_NOT_EXIST;
                        return;
                    }
                    serviceTable.removeEntry(entry.getRowKey());
                    if (!WsServiceManagementHelper.submitMO((ManagedObject)serviceTable, equipment)) {
                        log.debug((Object)("delete service " + WsResponse.ERROR_BS_AGENT));
                        response[0] = WsResponse.ERROR_BS_AGENT;
                        return;
                    }
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response[0] = WsResponse.ERROR;
                    return;
                }
                response[0] = WsResponse.SUCCESS;
            }
        }).run();
        return response[0];
    }

    public WsServiceStatusResponse serviceStatus(final String bsIP, final String serviceName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- serviceStatus ---------------");
            log.debug((Object)("bsIP: \t\t\t" + bsIP));
            log.debug((Object)("serviceName: \t" + serviceName));
            log.debug((Object)"-------------------------------------------");
        }
        final WsServiceStatusResponse response = new WsServiceStatusResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        log.debug((Object)WsResponse.ERROR_WS_NOT_LICENSED);
                        response.copyWsResponse(WsResponse.ERROR_WS_NOT_LICENSED);
                        return;
                    }
                    WsResponse isEmptyField = WsServiceManagementHelper.isEmptyField(bsIP, serviceName, "serviceProfileName", "subscriberId", "cpeMacF");
                    if (isEmptyField != null) {
                        response.copyWsResponse(isEmptyField);
                        return;
                    }
                    RbBaseStationEquipment equipment = WsServiceManagementHelper.getBaseStationByIP(bsIP);
                    if (equipment == null) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_FOUND);
                        response.copyWsResponse(WsResponse.ERROR_BS_NOT_FOUND);
                        return;
                    }
                    if (!LicenseHelper.isLicensed((Object)((Object)equipment))) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_LICENSED);
                        response.copyWsResponse(WsResponse.ERROR_BS_NOT_LICENSED);
                        return;
                    }
                    if (!equipment.isReachable()) {
                        log.debug((Object)WsResponse.ERROR_BS_UNREACHABLE);
                        response.copyWsResponse(WsResponse.ERROR_BS_UNREACHABLE);
                        return;
                    }
                    RbServiceConfigTable configTable = (RbServiceConfigTable)WsServiceManagementHelper.getMOFromEquipment(equipment, RbServiceConfigTable.class);
                    if (configTable == null) {
                        log.debug((Object)("get RbServiceConfigTable " + WsResponse.ERROR_BS_AGENT));
                        response.copyWsResponse(WsResponse.ERROR_BS_AGENT);
                        return;
                    }
                    RbServiceConfigEntry entry = configTable.findEntryByName(serviceName);
                    if (entry == null) {
                        log.debug((Object)WsResponse.ERROR_SERVICE_NAME_NOT_EXIST);
                        response.copyWsResponse(WsResponse.ERROR_SERVICE_NAME_NOT_EXIST);
                        return;
                    }
                    switch (entry.getRbServiceOperStatus()) {
                        case 1: {
                            response.setServiceStatus("Up");
                            response.copyWsResponse(WsResponse.SUCCESS);
                            return;
                        }
                        case 2: {
                            response.setServiceStatus("Down");
                            response.copyWsResponse(WsResponse.SUCCESS);
                            return;
                        }
                        case 3: {
                            response.setServiceStatus("Unknown");
                            response.copyWsResponse(WsResponse.SUCCESS);
                            return;
                        }
                    }
                    response.setServiceStatus("NA");
                    response.copyWsResponse(WsResponse.SUCCESS);
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                    return;
                }
            }
        }).run();
        return response;
    }

    public WsRadioLinkStatusResponse radioLinkStatus(final String cpeMacF) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- radioLinkStatus ---------------");
            log.debug((Object)("cpeMac:    " + cpeMacF));
            log.debug((Object)"---------------------------------------------");
        }
        final WsRadioLinkStatusResponse response = new WsRadioLinkStatusResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        log.debug((Object)WsResponse.ERROR_WS_NOT_LICENSED);
                        response.copyWsResponse(WsResponse.ERROR_WS_NOT_LICENSED);
                        return;
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeMacF)) {
                        log.debug((Object)WsResponse.ERROR_INPUT_CPEMAC);
                        response.copyWsResponse(WsResponse.ERROR_INPUT_CPEMAC);
                        return;
                    }
                    String cpeMac = WsServiceManagementHelper.getMacAddressFromString(cpeMacF);
                    RbSU su = WsServiceManagementHelper.getSU(cpeMac);
                    WsServiceManagementHelper.radioLinkStatusExecutor(su, response);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsRadioLinkStatusResponse radioLinkStatusByCPEName(final String cpeName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- radioLinkStatusbyName ---------------");
            log.debug((Object)("cpeName:    " + cpeName));
            log.debug((Object)"---------------------------------------------");
        }
        final WsRadioLinkStatusResponse response = new WsRadioLinkStatusResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        log.debug((Object)WsResponse.ERROR_WS_NOT_LICENSED);
                        response.copyWsResponse(WsResponse.ERROR_WS_NOT_LICENSED);
                        return;
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeName)) {
                        throw new WsException(WsResponse.ERROR_INPUT_CPE_NAME);
                    }
                    List<RbSU> suList = WsServiceManagementHelper.getSUbyName(cpeName);
                    if (suList == null || suList.isEmpty()) {
                        throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
                    }
                    if (suList.size() > 1) {
                        throw new WsException(WsResponse.ERROR_SU_DUPLICATE_NAME);
                    }
                    RbSU su = suList.get(0);
                    WsServiceManagementHelper.radioLinkStatusExecutor(su, response);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsResponse subscriberCreate(final String bsIP, final String subscriberId, final String subscriberFirstName, final String subscriberLastName, final String subscriberInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- subscriberCreate ---------------");
            log.debug((Object)("bsIP: \t\t\t\t\t" + bsIP));
            log.debug((Object)("subscriberId: \t\t\t" + subscriberId));
            log.debug((Object)("subscriberFirstName: \t" + subscriberFirstName));
            log.debug((Object)("subscriberLastName: \t" + subscriberLastName));
            log.debug((Object)("subscriberInfo: \t\t" + subscriberInfo));
            log.debug((Object)"----------------------------------------------");
        }
        final WsResponse[] response = new WsResponse[1];
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        log.debug((Object)WsResponse.ERROR_WS_NOT_LICENSED);
                        response[0] = WsResponse.ERROR_WS_NOT_LICENSED;
                        return;
                    }
                    WsResponse isEmptyField = WsServiceManagementHelper.isEmptyField(bsIP, "serviceName", "serviceProfileName", subscriberId, "cpeMacF");
                    if (isEmptyField != null) {
                        response[0] = isEmptyField;
                        return;
                    }
                    RbBaseStationEquipment equipment = WsServiceManagementHelper.getBaseStationByIP(bsIP);
                    if (equipment == null) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_FOUND);
                        response[0] = WsResponse.ERROR_BS_NOT_FOUND;
                        return;
                    }
                    if (!LicenseHelper.isLicensed((Object)((Object)equipment))) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_LICENSED);
                        response[0] = WsResponse.ERROR_BS_NOT_LICENSED;
                        return;
                    }
                    if (!equipment.isReachable()) {
                        log.debug((Object)WsResponse.ERROR_BS_UNREACHABLE);
                        response[0] = WsResponse.ERROR_BS_UNREACHABLE;
                        return;
                    }
                    RbSubscriberTable subscriberTable = (RbSubscriberTable)WsServiceManagementHelper.getMOFromEquipment(equipment, RbSubscriberTable.class).clone();
                    if (subscriberTable == null) {
                        log.debug((Object)("get RbSubscriberTable " + WsResponse.ERROR_BS_AGENT));
                        response[0] = WsResponse.ERROR_BS_AGENT;
                        return;
                    }
                    RbSubscriberEntry subscriber = subscriberTable.findEntryBySubscriberID(subscriberId);
                    if (subscriber == null) {
                        subscriber = new RbSubscriberEntry();
                        subscriber.setRbSubscriberIdx(-1L);
                        subscriber.setRbSubscriberID(subscriberId);
                        if (!WsServiceManagementHelper.isEmptyString(subscriberFirstName)) {
                            subscriber.setRbSubscriberFirstName(subscriberFirstName);
                        } else {
                            subscriber.setRbSubscriberFirstName("");
                        }
                        if (!WsServiceManagementHelper.isEmptyString(subscriberLastName)) {
                            subscriber.setRbSubscriberLastName(subscriberLastName);
                        } else {
                            subscriber.setRbSubscriberLastName("");
                        }
                        if (!WsServiceManagementHelper.isEmptyString(subscriberInfo)) {
                            subscriber.setRbSubscriberInfo(subscriberInfo);
                        } else {
                            subscriber.setRbSubscriberInfo("");
                        }
                        subscriber.setRbSubscriberAdminStatus(1);
                        subscriberTable.addEntry((TableRowMO)subscriber);
                        if (!WsServiceManagementHelper.submitMO((ManagedObject)subscriberTable, equipment)) {
                            log.debug((Object)WsResponse.ERROR_BS_AGENT);
                            response[0] = WsResponse.ERROR_BS_AGENT;
                            return;
                        }
                    } else {
                        log.debug((Object)WsResponse.ERROR_SUBSCRIBER_EXISTS);
                        response[0] = WsResponse.ERROR_SUBSCRIBER_EXISTS;
                        return;
                    }
                    response[0] = WsResponse.SUCCESS;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response[0] = WsResponse.ERROR;
                    return;
                }
            }
        }).run();
        return response[0];
    }

    public WsResponse subscriberModify(final String bsIP, final String subscriberId, final String adminStatus, final String subscriberFirstName, final String subscriberLastName, final String subscriberInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- subscriberModify ---------------");
            log.debug((Object)("bsIP: \t\t\t\t\t" + bsIP));
            log.debug((Object)("subscriberId: \t\t\t" + subscriberId));
            log.debug((Object)("subscriberFirstName: \t" + subscriberFirstName));
            log.debug((Object)("subscriberLastName: \t" + subscriberLastName));
            log.debug((Object)("subscriberInfo: \t\t" + subscriberInfo));
            log.debug((Object)"----------------------------------------------");
        }
        final WsResponse[] response = new WsResponse[1];
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        log.debug((Object)WsResponse.ERROR_WS_NOT_LICENSED);
                        response[0] = WsResponse.ERROR_WS_NOT_LICENSED;
                        return;
                    }
                    WsResponse isEmptyField = WsServiceManagementHelper.isEmptyField(bsIP, "serviceName", "serviceProfileName", subscriberId, "cpeMacF");
                    if (isEmptyField != null) {
                        response[0] = isEmptyField;
                        return;
                    }
                    RbBaseStationEquipment equipment = WsServiceManagementHelper.getBaseStationByIP(bsIP);
                    if (equipment == null) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_FOUND);
                        response[0] = WsResponse.ERROR_BS_NOT_FOUND;
                        return;
                    }
                    if (!LicenseHelper.isLicensed((Object)((Object)equipment))) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_LICENSED);
                        response[0] = WsResponse.ERROR_BS_NOT_LICENSED;
                        return;
                    }
                    if (!equipment.isReachable()) {
                        log.debug((Object)WsResponse.ERROR_BS_UNREACHABLE);
                        response[0] = WsResponse.ERROR_BS_UNREACHABLE;
                        return;
                    }
                    RbSubscriberTable subscriberTable = (RbSubscriberTable)WsServiceManagementHelper.getMOFromEquipment(equipment, RbSubscriberTable.class).clone();
                    if (subscriberTable == null) {
                        log.debug((Object)("get RbSubscriberTable " + WsResponse.ERROR_BS_AGENT));
                        response[0] = WsResponse.ERROR_BS_AGENT;
                        return;
                    }
                    RbSubscriberEntry subscriber = subscriberTable.findEntryBySubscriberID(subscriberId);
                    if (subscriber == null) {
                        log.debug((Object)WsResponse.ERROR_SUBSCRIBER_NOT_EXIST);
                        response[0] = WsResponse.ERROR_SUBSCRIBER_NOT_EXIST;
                        return;
                    }
                    subscriber.setRbSubscriberID(subscriberId);
                    if (!WsServiceManagementHelper.isEmptyString(subscriberFirstName)) {
                        subscriber.setRbSubscriberFirstName(subscriberFirstName);
                    }
                    if (!WsServiceManagementHelper.isEmptyString(subscriberLastName)) {
                        subscriber.setRbSubscriberLastName(subscriberLastName);
                    }
                    if (!WsServiceManagementHelper.isEmptyString(subscriberInfo)) {
                        subscriber.setRbSubscriberInfo(subscriberInfo);
                    }
                    subscriber.setRbSubscriberAdminStatus(new Boolean(adminStatus) != false ? 1 : 2);
                    if (!WsServiceManagementHelper.submitMO((ManagedObject)subscriberTable, equipment)) {
                        log.debug((Object)WsResponse.ERROR_BS_AGENT);
                        response[0] = WsResponse.ERROR_BS_AGENT;
                        return;
                    }
                    response[0] = WsResponse.SUCCESS;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response[0] = WsResponse.ERROR;
                    return;
                }
            }
        }).run();
        return response[0];
    }

    public WsResponse subscriberDelete(final String bsIP, final String subscriberId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- subscriberDelete ---------------");
            log.debug((Object)("bsIP: \t\t\t" + bsIP));
            log.debug((Object)("subscriberId: \t" + subscriberId));
            log.debug((Object)"----------------------------------------------");
        }
        final WsResponse[] response = new WsResponse[1];
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        log.debug((Object)WsResponse.ERROR_WS_NOT_LICENSED);
                        response[0] = WsResponse.ERROR_WS_NOT_LICENSED;
                        return;
                    }
                    WsResponse isEmptyField = WsServiceManagementHelper.isEmptyField(bsIP, "serviceName", "serviceProfileName", subscriberId, "cpeMacF");
                    if (isEmptyField != null) {
                        response[0] = isEmptyField;
                        return;
                    }
                    RbBaseStationEquipment equipment = WsServiceManagementHelper.getBaseStationByIP(bsIP);
                    if (equipment == null) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_FOUND);
                        response[0] = WsResponse.ERROR_BS_NOT_FOUND;
                        return;
                    }
                    if (!LicenseHelper.isLicensed((Object)((Object)equipment))) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_LICENSED);
                        response[0] = WsResponse.ERROR_BS_NOT_LICENSED;
                        return;
                    }
                    if (!equipment.isReachable()) {
                        log.debug((Object)WsResponse.ERROR_BS_UNREACHABLE);
                        response[0] = WsResponse.ERROR_BS_UNREACHABLE;
                        return;
                    }
                    RbSubscriberTable subscriberTable = (RbSubscriberTable)WsServiceManagementHelper.getMOFromEquipment(equipment, RbSubscriberTable.class).clone();
                    if (subscriberTable == null) {
                        log.debug((Object)("get RbSubscriberTable " + WsResponse.ERROR_BS_AGENT));
                        response[0] = WsResponse.ERROR_BS_AGENT;
                        return;
                    }
                    RbSubscriberEntry entry = subscriberTable.findEntryBySubscriberID(subscriberId);
                    if (entry != null) {
                        RbServiceConfigTable configTable = (RbServiceConfigTable)WsServiceManagementHelper.getMOFromEquipment(equipment, RbServiceConfigTable.class);
                        for (RbServiceConfigEntry serviceEntry : configTable.getEntries()) {
                            if (!serviceEntry.getRbSubscriberIdx().equals(entry.getRbSubscriberIdx())) continue;
                            log.debug((Object)("subscriber is used by at least 1 service " + WsResponse.ERROR_SUBSCRIBER_IS_USED));
                            response[0] = WsResponse.ERROR_SUBSCRIBER_IS_USED;
                            return;
                        }
                        subscriberTable.removeEntry(entry.getRowKey());
                        if (!WsServiceManagementHelper.submitMO((ManagedObject)subscriberTable, equipment)) {
                            log.debug((Object)("delete subscriber " + WsResponse.ERROR_BS_AGENT));
                            response[0] = WsResponse.ERROR_BS_AGENT;
                            return;
                        }
                    } else {
                        log.debug((Object)("findEntryBySubscriberId " + WsResponse.ERROR_SUBSCRIBER_NOT_EXIST));
                        response[0] = WsResponse.ERROR_SUBSCRIBER_NOT_EXIST;
                        return;
                    }
                    response[0] = WsResponse.SUCCESS;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response[0] = WsResponse.ERROR;
                    return;
                }
            }
        }).run();
        return response[0];
    }

    public WsBsListResponse baseStationList(final String bsIP) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- baseStationList ---------------");
            log.debug((Object)("bsIP: \t" + bsIP));
            log.debug((Object)"---------------------------------------------");
        }
        final WsBsListResponse response = new WsBsListResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        log.debug((Object)WsResponse.ERROR_WS_NOT_LICENSED);
                        response.copyWsResponse(WsResponse.ERROR_WS_NOT_LICENSED);
                        return;
                    }
                    List<RbBaseStationEquipment> list = WsServiceManagementHelper.getBaseStations(bsIP);
                    if (!list.isEmpty()) {
                        WsBsData[] bsList = new WsBsData[list.size()];
                        response.setBsList(bsList);
                        int i = 0;
                        for (RbBaseStationEquipment equipment : list) {
                            bsList[i] = new WsBsData(equipment.getName(), equipment.getIPAddress());
                            ++i;
                        }
                        response.copyWsResponse(WsResponse.SUCCESS);
                    } else {
                        response.copyWsResponse(WsResponse.ERROR_BS_NOT_FOUND);
                    }
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsServiceProfileListResponse serviceProfileList(final String bsIP) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- serviceProfileList ---------------");
            log.debug((Object)("bsIP: \t" + bsIP));
            log.debug((Object)"------------------------------------------------");
        }
        final WsServiceProfileListResponse response = new WsServiceProfileListResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                RbBaseStationEquipment bs = null;
                boolean errorOcurred = false;
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        log.debug((Object)WsResponse.ERROR_WS_NOT_LICENSED);
                        response.copyWsResponse(WsResponse.ERROR_WS_NOT_LICENSED);
                        return;
                    }
                    if (WsServiceManagementHelper.isEmptyString(bsIP)) {
                        response.copyWsResponse(WsResponse.ERROR_INPUT_BSIP);
                        return;
                    }
                    List<RbBaseStationEquipment> bsList = WsServiceManagementHelper.getBaseStations(bsIP);
                    bs = bsList.get(0);
                    if (!LicenseHelper.isLicensed((Object)((Object)bs))) {
                        log.debug((Object)WsResponse.ERROR_BS_NOT_LICENSED);
                        response.copyWsResponse(WsResponse.ERROR_BS_NOT_LICENSED);
                        return;
                    }
                    if (!bs.isReachable()) {
                        log.debug((Object)WsResponse.ERROR_BS_UNREACHABLE);
                        response.copyWsResponse(WsResponse.ERROR_BS_UNREACHABLE);
                        return;
                    }
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR_BS_NOT_FOUND);
                    errorOcurred = true;
                }
                if (!errorOcurred) {
                    RbServiceTemplateConfigTable serviceProfileTable = (RbServiceTemplateConfigTable)WsServiceManagementHelper.getMOFromEquipment(bs, RbServiceTemplateConfigTable.class);
                    if (serviceProfileTable == null) {
                        response.copyWsResponse(WsResponse.ERROR_BS_AGENT);
                        errorOcurred = true;
                    }
                    WsServiceProfileData[] serviceProfileList = new WsServiceProfileData[serviceProfileTable.getEntries().size()];
                    response.setServiceProfileList(serviceProfileList);
                    int i = 0;
                    for (RbServiceTemplateConfigEntry serviceProfileEntry : serviceProfileTable.getEntries()) {
                        WsServiceProfileData serviceProfileData = new WsServiceProfileData();
                        serviceProfileData.setServiceProfileName(serviceProfileEntry.getRbServiceTemplateName());
                        serviceProfileData.setBsName(bs.getName());
                        serviceProfileData.setBsIP(bs.getIPAddress());
                        serviceProfileList[i] = serviceProfileData;
                        ++i;
                    }
                }
                if (!errorOcurred) {
                    response.copyWsResponse(WsResponse.SUCCESS);
                }
            }
        }).run();
        return response;
    }

    public WsQueryServiceMACResponse queryServiceMAC(final String serviceName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- queryServiceMAC ---------------");
            log.debug((Object)("serviceName: \t" + serviceName));
            log.debug((Object)"------------------------------------------------");
        }
        final WsQueryServiceMACResponse ret = new WsQueryServiceMACResponse();
        ret.copyWsResponse(WsResponse.SUCCESS);
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        log.debug((Object)WsResponse.ERROR_WS_NOT_LICENSED);
                        ret.copyWsResponse(WsResponse.ERROR_WS_NOT_LICENSED);
                        return;
                    }
                    if (WsServiceManagementHelper.isEmptyString(serviceName)) {
                        log.debug((Object)WsResponse.ERROR_INPUT_SERVICE_NAME);
                        ret.copyWsResponse(WsResponse.ERROR_INPUT_SERVICE_NAME);
                        return;
                    }
                    List<RbServiceConfigEntry> serviceEntries = WsServiceManagementHelper.getServicesByName(serviceName);
                    if (null == serviceEntries || serviceEntries.isEmpty()) {
                        log.debug((Object)WsResponse.ERROR_SERVICE_NAME_NOT_EXIST);
                        ret.copyWsResponse(WsResponse.ERROR_SERVICE_NAME_NOT_EXIST);
                        return;
                    }
                    WsServiceMACData[] serviceMacData = new WsServiceMACData[serviceEntries.size()];
                    int i = 0;
                    for (RbServiceConfigEntry serviceEntry : serviceEntries) {
                        WsServiceMACData macData = new WsServiceMACData();
                        RbBaseStationEquipment bsEquipment = (RbBaseStationEquipment)serviceEntry.getNRConfiguration().getConfigurationEquipment();
                        macData.setBsIP(bsEquipment.getIPAddress());
                        macData.setCpeMac(serviceEntry.getRbServiceSuMacAddress());
                        serviceMacData[i++] = macData;
                    }
                    ret.setServiceMacList(serviceMacData);
                }
                catch (Exception e) {
                    log.warn((Object)e, (Throwable)e);
                    ret.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return ret;
    }

    public WsResponse makeCPETemporarybyName(final String cpeName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- makeCPETemporarybyName ---------------");
            log.debug((Object)("cpeName:\t\t\t\t" + cpeName));
            log.debug((Object)"----------------------------------------------");
        }
        final WsResponse response = new WsResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        throw new WsException(WsResponse.ERROR_WS_NOT_LICENSED);
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeName)) {
                        throw new WsException(WsResponse.ERROR_INPUT_CPE_NAME);
                    }
                    List<RbSU> suList = WsServiceManagementHelper.getSUbyName(cpeName);
                    if (suList == null || suList.isEmpty()) {
                        throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
                    }
                    if (suList.size() > 1) {
                        throw new WsException(WsResponse.ERROR_SU_DUPLICATE_NAME);
                    }
                    RbSU su = suList.get(0);
                    WsServiceManagementHelper.makeSuTemporaryExecutor(su, response);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsResponse makeCPETemporarybyMac(final String cpeMac) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- makeCPETemporarybyMac ---------------");
            log.debug((Object)("cpeMac:\t\t\t\t" + cpeMac));
            log.debug((Object)"----------------------------------------------");
        }
        final WsResponse response = new WsResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        throw new WsException(WsResponse.ERROR_WS_NOT_LICENSED);
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeMac)) {
                        throw new WsException(WsResponse.ERROR_INPUT_CPEMAC);
                    }
                    String cpeMacFormat = WsServiceManagementHelper.getMacAddressFromString(cpeMac);
                    RbSU su = WsServiceManagementHelper.getSU(cpeMacFormat);
                    if (su == null) {
                        throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
                    }
                    WsServiceManagementHelper.makeSuTemporaryExecutor(su, response);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsResponse resetCPEbyName(final String cpeName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- resetCPEbyName ---------------");
            log.debug((Object)("cpeName:\t\t\t\t" + cpeName));
            log.debug((Object)"----------------------------------------------");
        }
        final WsResponse response = new WsResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        throw new WsException(WsResponse.ERROR_WS_NOT_LICENSED);
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeName)) {
                        throw new WsException(WsResponse.ERROR_INPUT_CPE_NAME);
                    }
                    List<RbSU> suList = WsServiceManagementHelper.getSUbyName(cpeName);
                    if (suList == null || suList.isEmpty()) {
                        throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
                    }
                    if (suList.size() > 1) {
                        throw new WsException(WsResponse.ERROR_SU_DUPLICATE_NAME);
                    }
                    RbSU su = suList.get(0);
                    WsServiceManagementHelper.resetCpeExecutor(su, response);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsResponse resetCPEbyMac(final String cpeMac) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- resetCPEbyMac ---------------");
            log.debug((Object)("cpeMac:\t\t\t\t" + cpeMac));
            log.debug((Object)"----------------------------------------------");
        }
        final WsResponse response = new WsResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        throw new WsException(WsResponse.ERROR_WS_NOT_LICENSED);
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeMac)) {
                        throw new WsException(WsResponse.ERROR_INPUT_CPEMAC);
                    }
                    String cpeMacFormat = WsServiceManagementHelper.getMacAddressFromString(cpeMac);
                    RbSU su = WsServiceManagementHelper.getSU(cpeMacFormat);
                    if (su == null) {
                        throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
                    }
                    WsServiceManagementHelper.resetCpeExecutor(su, response);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsServiceListResponse serviceListbyCPEMac(final String cpeMac) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- serviceListbyCPEMac ---------------");
            log.debug((Object)("cpeMac: \t" + cpeMac));
            log.debug((Object)"------------------------------------------------");
        }
        final WsServiceListResponse response = new WsServiceListResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        throw new WsException(WsResponse.ERROR_WS_NOT_LICENSED);
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeMac)) {
                        throw new WsException(WsResponse.ERROR_INPUT_CPEMAC);
                    }
                    String cpeMacFormat = WsServiceManagementHelper.getMacAddressFromString(cpeMac);
                    RbSU su = WsServiceManagementHelper.getSU(cpeMacFormat);
                    WsServiceManagementHelper.serviceListExecutor(su, response);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsServiceListResponse serviceListbyCPEName(final String cpeName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- serviceListbyCPEName ---------------");
            log.debug((Object)("cpeName: \t" + cpeName));
            log.debug((Object)"------------------------------------------------");
        }
        final WsServiceListResponse response = new WsServiceListResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        throw new WsException(WsResponse.ERROR_WS_NOT_LICENSED);
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeName)) {
                        throw new WsException(WsResponse.ERROR_INPUT_CPE_NAME);
                    }
                    List<RbSU> suList = WsServiceManagementHelper.getSUbyName(cpeName);
                    if (suList == null || suList.isEmpty()) {
                        throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
                    }
                    if (suList.size() > 1) {
                        throw new WsException(WsResponse.ERROR_SU_DUPLICATE_NAME);
                    }
                    RbSU su = suList.get(0);
                    WsServiceManagementHelper.serviceListExecutor(su, response);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsResponse suCreate(final String bsIP, final String cpeMac, final String cpeName, String swFileName, String swUpgradeAction) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- suCreate ---------------");
            log.debug((Object)("bsIP: \t         " + bsIP));
            log.debug((Object)("cpeMac: \t     " + cpeMac));
            log.debug((Object)("cpeName:     \t " + cpeName));
            log.debug((Object)("swFileName: \t " + swFileName));
            log.debug((Object)("swUpgradeAction: " + swUpgradeAction));
            log.debug((Object)"------------------------------------------------");
        }
        final WsResponse response = new WsResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        throw new WsException(WsResponse.ERROR_WS_NOT_LICENSED);
                    }
                    if (WsServiceManagementHelper.isEmptyString(bsIP)) {
                        throw new WsException(WsResponse.ERROR_INPUT_BSIP);
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeMac)) {
                        throw new WsException(WsResponse.ERROR_INPUT_CPEMAC);
                    }
                    RbBaseStationEquipment bs = WsServiceManagementHelper.getBaseStationByIP(bsIP);
                    if (bs == null) {
                        throw new WsException(WsResponse.ERROR_BS_NOT_FOUND);
                    }
                    if (bs.isIPCSSwitchingMode()) {
                        throw new WsException(WsResponse.ERROR_SU_BS_IS_IPCSMODE);
                    }
                    RbRegisteredSuTable suTable = (RbRegisteredSuTable)WsServiceManagementHelper.getMOFromEquipment(bs, RbRegisteredSuTable.class);
                    if (suTable == null) {
                        throw new WsException(WsResponse.ERROR_BS_AGENT);
                    }
                    RbRegisteredSuEntry entry = new RbRegisteredSuEntry();
                    String cpeMacFormat = WsServiceManagementHelper.getMacAddressFromString(cpeMac);
                    try {
                        entry.setRbSuMacAddr(MacAddress.fromSimpleString((String)cpeMacFormat).toOctetString());
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)e, (Throwable)e);
                        response.copyWsResponse(WsResponse.ERROR_INPUT_CPEMAC);
                    }
                    if (!WsServiceManagementHelper.isEmptyString(cpeName)) {
                        entry.setRbSuSysName(cpeName);
                    }
                    try {
                        suTable.addEntry((TableRowMO)entry);
                    }
                    catch (DuplicateEntryException e) {
                        throw new WsException(WsResponse.ERROR_SU_ALREADY_EXISTS);
                    }
                    if (!WsServiceManagementHelper.submitMO((ManagedObject)suTable, bs)) {
                        throw new WsException(WsResponse.ERROR_BS_AGENT);
                    }
                    response.copyWsResponse(WsResponse.SUCCESS);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsCPEDetailsResponse cpeDetailsbyMac(final String cpeMac) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- cpeDetailsbyMac ---------------");
            log.debug((Object)("cpeMac:\t         " + cpeMac));
            log.debug((Object)"------------------------------------------------");
        }
        final WsCPEDetailsResponse response = new WsCPEDetailsResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        throw new WsException(WsResponse.ERROR_WS_NOT_LICENSED);
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeMac)) {
                        throw new WsException(WsResponse.ERROR_INPUT_CPEMAC);
                    }
                    String cpeMacFormat = WsServiceManagementHelper.getMacAddressFromString(cpeMac);
                    RbSU su = WsServiceManagementHelper.getSU(cpeMacFormat);
                    WsServiceManagementHelper.cpeDetailsExecutor(su, response);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsCPEDetailsResponse cpeDetailsbyName(final String cpeName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- cpeDetailsbyName ---------------");
            log.debug((Object)("cpeName:\t         " + cpeName));
            log.debug((Object)"------------------------------------------------");
        }
        final WsCPEDetailsResponse response = new WsCPEDetailsResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        throw new WsException(WsResponse.ERROR_WS_NOT_LICENSED);
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeName)) {
                        throw new WsException(WsResponse.ERROR_INPUT_CPE_NAME);
                    }
                    List<RbSU> suList = WsServiceManagementHelper.getSUbyName(cpeName);
                    if (suList == null || suList.isEmpty()) {
                        throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
                    }
                    if (suList.size() > 1) {
                        throw new WsException(WsResponse.ERROR_SU_DUPLICATE_NAME);
                    }
                    RbSU su = suList.get(0);
                    WsServiceManagementHelper.cpeDetailsExecutor(su, response);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsResponse deleteCPEbyMac(final String cpeMac) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- deleteCPEbyMac ---------------");
            log.debug((Object)("cpeMac:\t\t\t\t" + cpeMac));
            log.debug((Object)"----------------------------------------------");
        }
        final WsResponse response = new WsResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        throw new WsException(WsResponse.ERROR_WS_NOT_LICENSED);
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeMac)) {
                        throw new WsException(WsResponse.ERROR_INPUT_CPEMAC);
                    }
                    String cpeMacFormat = WsServiceManagementHelper.getMacAddressFromString(cpeMac);
                    RbSU su = WsServiceManagementHelper.getSU(cpeMacFormat);
                    if (su == null) {
                        throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
                    }
                    WsServiceManagementHelper.deleteCpeExecutor(su, response);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }

    public WsResponse deleteCPEbyName(final String cpeName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"------------- deleteCPEbyName ---------------");
            log.debug((Object)("cpeName:\t\t\t\t" + cpeName));
            log.debug((Object)"----------------------------------------------");
        }
        final WsResponse response = new WsResponse();
        new RunnableDatastoreDecorator(new Runnable(){

            public void run() {
                try {
                    if (!WsLicenseHelper.isLicensedWS()) {
                        throw new WsException(WsResponse.ERROR_WS_NOT_LICENSED);
                    }
                    if (WsServiceManagementHelper.isEmptyString(cpeName)) {
                        throw new WsException(WsResponse.ERROR_INPUT_CPE_NAME);
                    }
                    List<RbSU> suList = WsServiceManagementHelper.getSUbyName(cpeName);
                    if (suList == null || suList.isEmpty()) {
                        throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
                    }
                    if (suList.size() > 1) {
                        throw new WsException(WsResponse.ERROR_SU_DUPLICATE_NAME);
                    }
                    RbSU su = suList.get(0);
                    WsServiceManagementHelper.deleteCpeExecutor(su, response);
                }
                catch (WsException wse) {
                    log.debug((Object)"WS Error: ", (Throwable)wse);
                    response.copyWsResponse(wse.getResponse());
                    return;
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    response.copyWsResponse(WsResponse.ERROR);
                }
            }
        }).run();
        return response;
    }
}

