/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.ws.impl;

import com.bwanms.domain.logic.Helpers;
import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.mediation.MediationException;
import com.bwanms.mo.ManagedObject;
import com.bwanms.model.Equipment;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.rb.command.RbSuCommand;
import com.bwanms.rb.gui.configuration.services.RbServiceConfigEntryEditorPanelController;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbRegisteredSuTable;
import com.bwanms.rb.mo.pm.RbBsServiceOperStatusEntry;
import com.bwanms.rb.mo.pm.RbSuMultirateCountersGroup;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigTable;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigTable;
import com.bwanms.rb.mo.services.RbSubscriberTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.ws.WsCPEDetailsResponse;
import com.bwanms.rb.ws.WsRadioLinkStatusResponse;
import com.bwanms.rb.ws.WsResponse;
import com.bwanms.rb.ws.WsServiceData;
import com.bwanms.rb.ws.WsServiceListResponse;
import com.bwanms.rb.ws.impl.WsException;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.MacAddress;
import com.bwanms.util.OctetString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsServiceManagementHelper {
    private static final Logger log = Logger.getLogger(WsServiceManagementHelper.class);

    public static RbBaseStationEquipment getBaseStationByIP(String bsIP) throws Exception {
        try {
            LightQuery query = new LightQuery(RbBaseStationEquipment.class);
            query.addParameter("IPAddress", (Object)bsIP);
            List temps = query.execute();
            return (RbBaseStationEquipment)((Object)temps.get(0));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public static List<RbBaseStationEquipment> getBaseStations(String bsIP) throws Exception {
        try {
            LightQuery query = new LightQuery(RbBaseStationEquipment.class);
            if (!WsServiceManagementHelper.isEmptyString(bsIP)) {
                query.addParameter("IPAddress", (Object)bsIP);
            }
            List temps = query.execute();
            return temps;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return new ArrayList<RbBaseStationEquipment>();
        }
    }

    public static RbSU getSU(String cpeMac) {
        try {
            LightQuery query = new LightQuery(RbSU.class);
            query.addParameter("macAddress", (Object)cpeMac);
            List temps = query.execute();
            return (RbSU)((Object)temps.get(0));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public static List<RbSU> getSUbyName(String cpeName) {
        LightQuery query = new LightQuery(RbSU.class);
        query.addParameter("name", (Object)cpeName);
        List temps = query.execute();
        System.out.println();
        return temps;
    }

    public static List<RbServiceConfigEntry> getServicesByName(String serviceName) throws Exception {
        LightQuery query = new LightQuery(RbServiceConfigEntry.class);
        query.addParameter("rbServiceName", (Object)serviceName);
        return query.execute();
    }

    public static List<ManagedObject> getMOs(Equipment equipment) {
        ArrayList<Class<? extends ManagedObject>> moClasses = new ArrayList<Class<? extends ManagedObject>>();
        moClasses.add(RbSubscriberTable.class);
        moClasses.add(RbServiceConfigTable.class);
        moClasses.add(RbServiceTemplateConfigTable.class);
        moClasses.add(RbRegisteredSuTable.class);
        return WsServiceManagementHelper.getMOsFromEquipment(equipment, moClasses);
    }

    public static List<ManagedObject> getMOsFromEquipment(Equipment equipment, List<Class<? extends ManagedObject>> moClasses) {
        try {
            return Helpers.getConfigurationHelper().retrieveCurrentConfiguration(equipment.getId(), "BS", moClasses, false);
        }
        catch (MediationException ex) {
            log.error((Object)"getMOsFromEquipment", (Throwable)ex);
            return null;
        }
    }

    public static ManagedObject getMOFromEquipment(Equipment equipment, Class<? extends ManagedObject> moClass) {
        ArrayList<Class<? extends ManagedObject>> moClasses = new ArrayList<Class<? extends ManagedObject>>();
        moClasses.add(moClass);
        try {
            return (ManagedObject)Helpers.getConfigurationHelper().retrieveCurrentConfiguration(equipment.getId(), "BS", moClasses, false).get(0);
        }
        catch (MediationException ex) {
            log.error((Object)"getMOFromEquipment", (Throwable)ex);
            return null;
        }
    }

    public static List<Object> getRadioLinkMOs(Equipment equipment) {
        ArrayList<Object> results = new ArrayList<Object>();
        ArrayList<Class<RbSuMultirateCountersGroup>> dataClasses = new ArrayList<Class<RbSuMultirateCountersGroup>>();
        dataClasses.add(RbSuMultirateCountersGroup.class);
        try {
            results.addAll(Helpers.getConfigurationHelper().retrieveData(equipment.getId(), dataClasses));
        }
        catch (MediationException ex) {
            log.error((Object)"getMOFromEquipment", (Throwable)ex);
        }
        return results;
    }

    public static WsResponse getOperationalStatus(Equipment equipment, Long rbServiceIdx, Long rbSubscriberIdx, int retry, Long timeout) {
        while (retry-- >= 0) {
            try {
                int status = ((RbBsServiceOperStatusEntry)ServiceRegistry.getConfigurationService().retrieveData(equipment.getId(), "BS", RbBsServiceOperStatusEntry.class, rbSubscriberIdx.toString() + "." + rbServiceIdx.toString()).get(0)).getRbServiceOperStatus();
                if (status == 1) {
                    return WsResponse.SUCCESS;
                }
            }
            catch (Exception e) {
                log.debug((Object)"getOperationalStatus", (Throwable)e);
            }
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException e) {
                log.debug((Object)"getOperationalStatus thread interrupted", (Throwable)e);
            }
        }
        return WsResponse.ERROR_SERVICE_OPERATIONAL_STATUS;
    }

    public static WsResponse configureEntity(RbServiceConfigEntry entity, List<RbServiceTemplateConfigEntry> serviceTemplates) {
        if (entity.getRbServiceAccessVLAN() != null) {
            if (entity.getRbServiceAccessVLAN() < 4095) {
                if (entity.getRbServiceVLANHybridMode() == 2 && entity.getRbServiceClientSiteVLANListCount() == 0 && entity.getRbServiceVLANClassificationMode() == 2) {
                    return WsResponse.ERROR_INPUT_VLAN_MUST_DEFINE;
                }
                if (entity.getRbServiceVLANHybridMode() == 2 && entity.getRbServiceClientSiteVLANListCount() > 0 && entity.getRbServiceVLANClassificationMode() == 2) {
                    return WsResponse.ERROR_INPUT_VLAN_MUST_BE_EMPTY;
                }
                if (entity.getRbServiceVLANHybridMode() == 1 && entity.getRbServiceClientSiteVLANListCount() > 1 && entity.getRbServiceVLANClassificationMode() == 2) {
                    return WsResponse.ERROR_INPUT_VLAN_ONLY_ONE;
                }
                if (entity.getRbServiceVLANHybridMode() == 2 && entity.getRbServiceClientSiteVLANListCount() > 0 && entity.getRbServiceVLANClassificationMode() == 1) {
                    return WsResponse.ERROR_INPUT_VLAN_MUST_BE_EMPTY;
                }
                if (new RbServiceConfigEntryEditorPanelController(null, null).checkVLANList(OctetString.fromOctetString((String)entity.getRbServiceClientSiteVLANList()), entity.getRbServiceAccessVLAN())) {
                    return WsResponse.ERROR_INPUT_VLAN_ACCESS_LIST_MISMATCH;
                }
            } else {
                if (entity.getRbServiceVLANHybridMode() == 2 && entity.getRbServiceClientSiteVLANListCount() == 0 && entity.getRbServiceVLANClassificationMode() == 2) {
                    return WsResponse.ERROR_INPUT_VLAN_MUST_DEFINE;
                }
                if (entity.getRbServiceVLANHybridMode() == 2 && entity.getRbServiceClientSiteVLANListCount() > 1 && entity.getRbServiceVLANClassificationMode() == 2) {
                    return WsResponse.ERROR_INPUT_VLAN_ONLY_ONE;
                }
                if (entity.getRbServiceVLANHybridMode() == 1 && entity.getRbServiceClientSiteVLANListCount() > 1 && entity.getRbServiceVLANClassificationMode() == 2) {
                    return WsResponse.ERROR_INPUT_VLAN_ONLY_ONE;
                }
            }
            if (WsServiceManagementHelper.checkVPLId(entity.getRbServiceAccessVLAN(), OctetString.fromOctetString((String)entity.getRbServiceClientSiteVLANList()), WsServiceManagementHelper.isTransparent(entity, serviceTemplates), entity.getRbServiceVLANHybridMode() == 1, serviceTemplates)) {
                return WsResponse.ERROR_INPUT_VLAN_ACCESS_LIST_MISMATCH;
            }
        }
        return WsResponse.SUCCESS;
    }

    public static boolean checkVPLId(Integer vlanId, int[] vlanList, boolean transparent, boolean hybrid, List<RbServiceTemplateConfigEntry> serviceTemplates) {
        for (RbServiceTemplateConfigEntry serviceProfile : serviceTemplates) {
            if (!transparent && serviceProfile.getRbServiceTemplateBaseVLAN().equals(4095) || transparent && serviceProfile.getRbServiceTemplateBaseVLAN().equals(4095) && (!hybrid && vlanId == 4095 || hybrid && vlanId != 4095) || !serviceProfile.getRbServiceTemplateBaseVLAN().equals(vlanId) && (!transparent || !new RbServiceConfigEntryEditorPanelController(null, null).checkVLANList(vlanList, serviceProfile.getRbServiceTemplateBaseVLAN()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isTransparent(RbServiceConfigEntry entity, List<RbServiceTemplateConfigEntry> serviceTemplates) {
        for (RbServiceTemplateConfigEntry serviceProfile : serviceTemplates) {
            if (!serviceProfile.getRbServiceTemplateIdx().equals(entity.getRbServiceServiceTemplateIdx()) || serviceProfile.getRbServiceTemplateVLANTransparencyMode() != 1) continue;
            return true;
        }
        return false;
    }

    public static boolean submitMO(ManagedObject mo, RbBaseStationEquipment equipment) {
        ArrayList<ManagedObject> newManagedObjects = new ArrayList<ManagedObject>();
        newManagedObjects.add(mo);
        boolean success = false;
        try {
            Helpers.getConfigurationHelper().updateCurrentConfiguration(equipment.getId(), newManagedObjects);
            success = true;
        }
        catch (MediationException ex) {
            log.error((Object)"submitMO", (Throwable)ex);
        }
        return success;
    }

    public static boolean setVLANListFromCommaSeparated(RbServiceConfigEntry entity, String vlanList) {
        int i;
        HashSet<String> valuesSet = new HashSet<String>();
        StringBuffer buf = new StringBuffer();
        int counter = 0;
        String[] model = vlanList.split(",");
        for (i = 0; i < model.length; ++i) {
            if (model[i] == null || model[i].equals("0") || model[i].equals("")) continue;
            int value = 0;
            try {
                value = Integer.parseInt(model[i]);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            if (value < 0 || value > 4094) {
                return false;
            }
            if (valuesSet.contains(model[i])) {
                return false;
            }
            valuesSet.add(model[i]);
            buf.append(model[i]);
            buf.append(",");
            ++counter;
        }
        if (entity.getRbServiceVLANHybridMode() == 1) {
            buf.append("4095,");
            ++counter;
        }
        if (counter > 16) {
            return false;
        }
        entity.setRbServiceClientSiteVLANListCount(counter);
        if (counter < 16) {
            for (i = counter; i < 16; ++i) {
                buf.append("0,");
            }
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        entity.setRbServiceClientSiteVLANListAsString(buf.toString());
        return true;
    }

    public static WsResponse checkMacAddress(RbBaseStationEquipment equipment, RbServiceConfigEntry entry, RbRegisteredSuTable registeredSuTable) {
        try {
            for (RbRegisteredSuEntry entry2 : registeredSuTable.getEntries()) {
                if (!entry2.getRbSuMacAddr().toLowerCase().equals(entry.getRbServiceSuMacAddress().toLowerCase())) continue;
                if (entry2.getRbSuPersistence() == 1) {
                    RbRegisteredSuTable registeredSuTableClone = (RbRegisteredSuTable)registeredSuTable.clone();
                    RbRegisteredSuEntry suEntry = (RbRegisteredSuEntry)registeredSuTableClone.findEntry(entry2.getRowKey());
                    suEntry.setRbSuPersistence(2);
                    if (WsServiceManagementHelper.submitMO((ManagedObject)registeredSuTableClone, equipment)) {
                        return WsResponse.SUCCESS;
                    }
                    return WsResponse.ERROR_SU_PERSISTANCE;
                }
                return WsResponse.SUCCESS;
            }
            return WsResponse.ERROR_BS_SU_NOT_FOUND;
        }
        catch (Exception e) {
            log.debug((Object)"checkMackAddress", (Throwable)e);
            return WsResponse.ERROR;
        }
    }

    public static String getMacAddressFromString(String mac) {
        return mac.trim().replaceAll("[ :-]+", " ").toUpperCase();
    }

    public static WsResponse isEmptyField(String bsIP, String serviceName, String serviceProfileName, String subscriberId, String cpeMacF) {
        if (WsServiceManagementHelper.isEmptyString(bsIP)) {
            log.debug((Object)WsResponse.ERROR_INPUT_BSIP);
            return WsResponse.ERROR_INPUT_BSIP;
        }
        if (WsServiceManagementHelper.isEmptyString(cpeMacF)) {
            log.debug((Object)WsResponse.ERROR_INPUT_CPEMAC);
            return WsResponse.ERROR_INPUT_CPEMAC;
        }
        if (WsServiceManagementHelper.isEmptyString(subscriberId)) {
            log.debug((Object)WsResponse.ERROR_INPUT_SUBSCRIBER_ID);
            return WsResponse.ERROR_INPUT_SUBSCRIBER_ID;
        }
        if (WsServiceManagementHelper.isEmptyString(serviceName)) {
            log.debug((Object)WsResponse.ERROR_INPUT_SERVICE_NAME);
            return WsResponse.ERROR_INPUT_SERVICE_NAME;
        }
        if (WsServiceManagementHelper.isEmptyString(serviceProfileName)) {
            log.debug((Object)WsResponse.ERROR_INPUT_SERVICE_PROFILE_NAME);
            return WsResponse.ERROR_INPUT_SERVICE_PROFILE_NAME;
        }
        return null;
    }

    public static WsResponse validateServiceCreateModifyInput(String bsIP, String serviceName, String subscriberId, String cpeMacF, String vlans, String serviceProfileName, String hybridVlanModeF, String vlanClasificationModeF, String accessVlanF, String adminStatusF) {
        if (WsServiceManagementHelper.isEmptyString(bsIP)) {
            log.debug((Object)WsResponse.ERROR_INPUT_BSIP);
            return WsResponse.ERROR_INPUT_BSIP;
        }
        if (WsServiceManagementHelper.isEmptyString(serviceName)) {
            log.debug((Object)WsResponse.ERROR_INPUT_SERVICE_NAME);
            return WsResponse.ERROR_INPUT_SERVICE_NAME;
        }
        if (WsServiceManagementHelper.isEmptyString(subscriberId)) {
            log.debug((Object)WsResponse.ERROR_INPUT_SUBSCRIBER_ID);
            return WsResponse.ERROR_INPUT_SUBSCRIBER_ID;
        }
        if (vlans != null) {
            StringTokenizer vlanTokens = new StringTokenizer(vlans, ",");
            while (vlanTokens.hasMoreTokens()) {
                try {
                    int vlanValue = Integer.parseInt(vlanTokens.nextToken());
                    if (vlanValue >= 0 && vlanValue <= 4095) continue;
                    throw new NumberFormatException();
                }
                catch (NumberFormatException e) {
                    log.debug((Object)WsResponse.ERROR_INPUT_VLAN);
                    return WsResponse.ERROR_INPUT_VLAN;
                }
            }
        }
        if (WsServiceManagementHelper.isEmptyString(cpeMacF)) {
            log.debug((Object)WsResponse.ERROR_INPUT_CPEMAC);
            return WsResponse.ERROR_INPUT_CPEMAC;
        }
        if (WsServiceManagementHelper.isEmptyString(serviceProfileName)) {
            log.debug((Object)WsResponse.ERROR_INPUT_SERVICE_PROFILE_NAME);
            return WsResponse.ERROR_INPUT_SERVICE_PROFILE_NAME;
        }
        if (WsServiceManagementHelper.isEmptyString(hybridVlanModeF) || !hybridVlanModeF.equalsIgnoreCase("on") && !hybridVlanModeF.equalsIgnoreCase("off") && !hybridVlanModeF.equalsIgnoreCase("true") && !hybridVlanModeF.equalsIgnoreCase("false")) {
            log.debug((Object)WsResponse.ERROR_INPUT_HYBRID_VLAN);
            return WsResponse.ERROR_INPUT_HYBRID_VLAN;
        }
        if (WsServiceManagementHelper.isEmptyString(vlanClasificationModeF) || !vlanClasificationModeF.equalsIgnoreCase("on") && !vlanClasificationModeF.equalsIgnoreCase("off") && !vlanClasificationModeF.equalsIgnoreCase("true") && !vlanClasificationModeF.equalsIgnoreCase("false")) {
            log.debug((Object)WsResponse.ERROR_INPUT_VLAN_CLASSIFICATION_MODE);
            return WsResponse.ERROR_INPUT_VLAN_CLASSIFICATION_MODE;
        }
        if (!WsServiceManagementHelper.isEmptyString(accessVlanF) && !accessVlanF.equalsIgnoreCase("none")) {
            try {
                int av = Integer.parseInt(accessVlanF);
                if (av < 0 || av > 4096) {
                    log.debug((Object)WsResponse.ERROR_INPUT_ACCESS_VLAN);
                    return WsResponse.ERROR_INPUT_ACCESS_VLAN;
                }
            }
            catch (NumberFormatException nfe) {
                log.debug((Object)WsResponse.ERROR_INPUT_ACCESS_VLAN);
                return WsResponse.ERROR_INPUT_ACCESS_VLAN;
            }
        }
        if (!(!WsServiceManagementHelper.isEmptyString(adminStatusF) && (adminStatusF.equalsIgnoreCase("enable") || adminStatusF.equalsIgnoreCase("disable") || adminStatusF.equalsIgnoreCase("enabled") || adminStatusF.equalsIgnoreCase("disabled") || adminStatusF.equalsIgnoreCase("true") || adminStatusF.equalsIgnoreCase("false")))) {
            log.debug((Object)WsResponse.ERROR_INPUT_ADMIN_STATUS);
            return WsResponse.ERROR_INPUT_ADMIN_STATUS;
        }
        return null;
    }

    public static boolean isEmptyString(String str) {
        return str == null || str.equals("");
    }

    public static void radioLinkStatusExecutor(RbSU su, WsRadioLinkStatusResponse response) throws WsException {
        if (null == su) {
            throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
        }
        if (!LicenseHelper.isLicensed((Object)((Object)su))) {
            throw new WsException(WsResponse.ERROR_SU_NOT_LICENSED);
        }
        RbBaseStationEquipment baseStation = su.getManagerBS();
        if (null == baseStation) {
            throw new WsException(WsResponse.ERROR_BS_NOT_FOUND);
        }
        RbSuMultirateCountersGroup radioParameters = (RbSuMultirateCountersGroup)WsServiceManagementHelper.getRadioLinkMOs(su).get(0);
        if (radioParameters == null) {
            log.debug((Object)("radio link parameters not found " + WsResponse.ERROR_BS_RADIO_LINK_PARAMETERS_NOT_FOUND));
            response.copyWsResponse(WsResponse.ERROR_BS_RADIO_LINK_PARAMETERS_NOT_FOUND);
            return;
        }
        response.setBsIP(baseStation.getIPAddress());
        response.setRssiDL(radioParameters.getRbSuDlRSSI());
        response.setRssiUL(radioParameters.getRbSuUlRSSI());
        response.setSnrDL(radioParameters.getRbSuDlSNR());
        response.setSnrUL(radioParameters.getRbSuUlSNR());
        response.setRateUL(RbSuMultirateCountersGroup.toStringRbSuUlCurrentRate(radioParameters.getRbSuUlCurrentRate()));
        response.setRateDL(RbSuMultirateCountersGroup.toStringRbSuDlCurrentRate(radioParameters.getRbSuDlCurrentRate()));
        response.setCpeSoftwareVersion(su.getRunningSoftwareVersion());
        response.setBerTest("0");
        if (!su.getServingAUId().toString().equalsIgnoreCase("255")) {
            response.setSlotID(su.getServingAUId().toString());
        } else {
            response.setSlotID("0");
        }
        response.copyWsResponse(WsResponse.SUCCESS);
    }

    public static void resetCpeExecutor(RbSU su, WsResponse response) throws WsException {
        if (!LicenseHelper.isLicensed((Object)((Object)su))) {
            throw new WsException(WsResponse.ERROR_SU_NOT_LICENSED);
        }
        if (!su.isReachable() || su.getState() == 1) {
            throw new WsException(WsResponse.ERROR_BS_SU_UNREACHABLE);
        }
        ArrayList<RbSuCommand> list = new ArrayList<RbSuCommand>();
        list.add(su.createResetCommand());
        try {
            ServiceRegistry.getConfigurationService().sendData(su.getId(), list);
            response.copyWsResponse(WsResponse.SUCCESS);
        }
        catch (ServiceException se) {
            log.debug((Object)se, (Throwable)se);
            response = WsResponse.ERROR_SU_COULD_NOT_RESET;
            return;
        }
    }

    public static void serviceListExecutor(RbSU su, WsServiceListResponse response) throws WsException {
        if (su == null) {
            throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
        }
        if (!LicenseHelper.isLicensed((Object)((Object)su))) {
            throw new WsException(WsResponse.ERROR_SU_NOT_LICENSED);
        }
        RbBaseStationEquipment bs = su.getManagerBS();
        if (!bs.isReachable()) {
            throw new WsException(WsResponse.ERROR_BS_UNREACHABLE);
        }
        RbServiceConfigTable serviceTable = (RbServiceConfigTable)WsServiceManagementHelper.getMOFromEquipment(bs, RbServiceConfigTable.class);
        if (serviceTable == null) {
            throw new WsException(WsResponse.ERROR_BS_AGENT);
        }
        ArrayList<WsServiceData> serviceList = new ArrayList<WsServiceData>();
        for (RbServiceConfigEntry serviceEntry : serviceTable.getEntries()) {
            String suMac = WsServiceManagementHelper.getMacAddressFromString(su.getMacAddress());
            String entryMac = WsServiceManagementHelper.getMacAddressFromString(serviceEntry.getRbServiceSuMacAddress());
            if (!entryMac.equalsIgnoreCase(suMac)) continue;
            WsServiceData service = new WsServiceData();
            service.setBsIP(bs.getIPAddress());
            service.setAdminStatus(WsServiceManagementHelper.toStringAdminStatus(serviceEntry.getRbServiceAdminStatus()));
            service.setHybridVlanMode(WsServiceManagementHelper.toStringVLANHybridMode(serviceEntry.getRbServiceVLANHybridMode()));
            service.setServiceName(serviceEntry.getRbServiceName());
            service.setSubscriberId(serviceEntry.getRbSubscriberID());
            service.setServiceProfileName(serviceEntry.getRbServiceServiceTemplateName());
            service.setVlanClasificationMode(WsServiceManagementHelper.toStringVLANClassificationMode(serviceEntry.getRbServiceVLANClassificationMode()));
            if (su.getManagerBS().isIPCSSwitchingMode()) {
                service.setVlanList(serviceEntry.getRbSuServiceVPLID().toString());
                service.setAccessVlan("NA");
            } else {
                service.setAccessVlan(serviceEntry.getRbServiceAccessVLAN().toString());
                String vlanList = serviceEntry.getRbServiceClientSiteVLANListAsString();
                if (vlanList.contains("4095,")) {
                    vlanList = vlanList.replace("4095,", "");
                } else if (vlanList.contains(",4095")) {
                    vlanList = vlanList.replace(",4095", "");
                }
                service.setVlanList(vlanList);
            }
            service.setOperationalStatus(WsServiceManagementHelper.toStringOperationalStatus(serviceEntry.getRbServiceOperStatus()));
            serviceList.add(service);
        }
        WsServiceData[] serviceData = new WsServiceData[serviceList.size()];
        for (int i = 0; i < serviceData.length; ++i) {
            serviceData[i] = (WsServiceData)serviceList.get(i);
        }
        response.copyWsResponse(WsResponse.SUCCESS);
        response.setServiceList(serviceData);
    }

    public static void cpeDetailsExecutor(RbSU su, WsCPEDetailsResponse response) throws WsException {
        if (su == null) {
            throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
        }
        if (!LicenseHelper.isLicensed((Object)((Object)su))) {
            throw new WsException(WsResponse.ERROR_SU_NOT_LICENSED);
        }
        response.setBsIP(su.getIPAddress());
        response.setCpeMac(su.getMacAddress());
        response.setCpeName(su.getName());
        response.setCpeSerialNumber(su.getSerialNumber());
        response.setCpeSoftwareVersion(su.getOperationalSoftwareVersion());
        response.copyWsResponse(WsResponse.SUCCESS);
    }

    public static String toStringVLANHybridMode(Integer value) {
        switch (value) {
            case 1: {
                return "On";
            }
            case 2: {
                return "Off";
            }
        }
        return "NA";
    }

    public static String toStringVLANClassificationMode(Integer value) {
        switch (value) {
            case 1: {
                return "Off";
            }
            case 2: {
                return "On";
            }
        }
        return "NA";
    }

    public static String toStringAdminStatus(Integer value) {
        switch (value) {
            case 1: {
                return "Enabled";
            }
            case 2: {
                return "Disabled";
            }
        }
        return "NA";
    }

    public static String toStringOperationalStatus(Integer value) {
        switch (value) {
            case 1: {
                return "Up";
            }
            case 2: {
                return "Down";
            }
            case 3: {
                return "Unknown";
            }
        }
        return "NA";
    }

    public static void makeSuTemporaryExecutor(RbSU su, WsResponse response) throws WsException {
        if (!LicenseHelper.isLicensed((Object)((Object)su))) {
            throw new WsException(WsResponse.ERROR_SU_NOT_LICENSED);
        }
        if (!su.isReachable() || su.getState() == 1) {
            throw new WsException(WsResponse.ERROR_BS_SU_UNREACHABLE);
        }
        RbBaseStationEquipment bs = su.getManagerBS();
        if (bs == null || !bs.isReachable()) {
            throw new WsException(WsResponse.ERROR_BS_UNREACHABLE);
        }
        RbServiceConfigTable serviceTable = (RbServiceConfigTable)WsServiceManagementHelper.getMOFromEquipment(bs, RbServiceConfigTable.class);
        if (serviceTable == null) {
            throw new WsException(WsResponse.ERROR_BS_AGENT);
        }
        RbRegisteredSuTable suTable = (RbRegisteredSuTable)WsServiceManagementHelper.getMOFromEquipment(bs, RbRegisteredSuTable.class).clone();
        if (suTable == null) {
            throw new WsException(WsResponse.ERROR_BS_AGENT);
        }
        RbRegisteredSuEntry suEntry = (RbRegisteredSuEntry)suTable.findEntry(MacAddress.fromSimpleString((String)su.getMacAddress()).toOctetString());
        if (suEntry == null) {
            throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
        }
        for (RbServiceConfigEntry service : serviceTable.getEntries()) {
            if (!service.getRbServiceSuMacAddress().toLowerCase().equals(suEntry.getRbSuMacAddr().toLowerCase())) continue;
            throw new WsException(WsResponse.ERROR_SU_HAS_SERVICES_DEFINED);
        }
        suEntry.setRbSuPersistence(1);
        if (!WsServiceManagementHelper.submitMO((ManagedObject)suTable, bs)) {
            throw new WsException(WsResponse.ERROR_BS_AGENT);
        }
        response.copyWsResponse(WsResponse.SUCCESS);
    }

    public static void deleteCpeExecutor(RbSU su, WsResponse response) throws WsException {
        if (!LicenseHelper.isLicensed((Object)((Object)su))) {
            throw new WsException(WsResponse.ERROR_SU_NOT_LICENSED);
        }
        if (!su.isReachable()) {
            throw new WsException(WsResponse.ERROR_BS_SU_UNREACHABLE);
        }
        RbBaseStationEquipment bs = su.getManagerBS();
        if (bs == null || !bs.isReachable()) {
            throw new WsException(WsResponse.ERROR_BS_UNREACHABLE);
        }
        RbServiceConfigTable serviceTable = (RbServiceConfigTable)WsServiceManagementHelper.getMOFromEquipment(bs, RbServiceConfigTable.class);
        if (serviceTable == null) {
            throw new WsException(WsResponse.ERROR_BS_AGENT);
        }
        RbRegisteredSuTable suTable = (RbRegisteredSuTable)WsServiceManagementHelper.getMOFromEquipment(bs, RbRegisteredSuTable.class).clone();
        if (suTable == null) {
            throw new WsException(WsResponse.ERROR_BS_AGENT);
        }
        RbRegisteredSuEntry suEntry = (RbRegisteredSuEntry)suTable.findEntry(MacAddress.fromSimpleString((String)su.getMacAddress()).toOctetString());
        if (suEntry == null) {
            throw new WsException(WsResponse.ERROR_BS_SU_NOT_FOUND);
        }
        for (RbServiceConfigEntry service : serviceTable.getEntries()) {
            if (!service.getRbServiceSuMacAddress().toLowerCase().equals(suEntry.getRbSuMacAddr().toLowerCase())) continue;
            throw new WsException(WsResponse.ERROR_SU_HAS_SERVICES_DEFINED);
        }
        if (Integer.valueOf(suEntry.getRbSuPersistence()).equals(2)) {
            suEntry.setRbSuPersistence(1);
        } else {
            suTable.removeEntry(suEntry.getRowKey());
        }
        if (!WsServiceManagementHelper.submitMO((ManagedObject)suTable, bs)) {
            throw new WsException(WsResponse.ERROR_BS_AGENT);
        }
        response.copyWsResponse(WsResponse.SUCCESS);
    }
}

