/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.util;

import com.bwanms.gui.Internationalizer;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorUtil {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer((String)"com.bwanms.rb.util");

    public static boolean isIPFormat(String str) {
        try {
            ValidatorUtil.getIPTokens(str);
        }
        catch (Exception ave) {
            return false;
        }
        return true;
    }

    private static int[] getIPTokens(String str) throws Exception {
        if (str.endsWith(".")) {
            throw new Exception("IP Address ends with .");
        }
        String newStr = ValidatorUtil.stripCharFromString(str, ' ');
        String[] tokens = ValidatorUtil.splitString(newStr, ".");
        if (tokens.length != 4 && tokens.length != 6) {
            throw new Exception("Wrong Number of tokens: " + tokens.length);
        }
        int[] _result = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (!ValidatorUtil.isNumeric(token)) {
                throw new Exception("Token is not numeric: " + token);
            }
            int value = Integer.parseInt(token);
            if (value < 0 || value > 255) {
                throw new Exception("Wrong token value: " + value);
            }
            _result[i] = value;
        }
        return _result;
    }

    public static boolean isIPSubnetMaskFormat(String str) {
        try {
            int[] tokens = ValidatorUtil.getIPTokens(str);
            boolean bZeroFound = false;
            int oneCount = 0;
            for (int i = 0; i < tokens.length; ++i) {
                int value = tokens[i];
                for (int k = 128; k > 0; k /= 2) {
                    boolean bSet;
                    boolean bl = bSet = 0 != (value & k);
                    if (bSet) {
                        if (bZeroFound) {
                            throw new Exception("Not a Subnet Mask - Format Error at Byte " + (1 + i));
                        }
                        ++oneCount;
                        continue;
                    }
                    bZeroFound = true;
                }
            }
            if (oneCount < 1) {
                throw new Exception("Not a Subnet Mask - Not class A, B or C Subnet.");
            }
        }
        catch (Exception ave) {
            return false;
        }
        return true;
    }

    public static final String stripCharFromString(String s, char c) {
        char[] ac = s.toCharArray();
        StringBuffer stringbuffer = new StringBuffer();
        for (int i = 0; i < ac.length; ++i) {
            if (ac[i] == c) continue;
            stringbuffer.append(ac[i]);
        }
        return stringbuffer.toString();
    }

    public static final String[] splitString(String s, String s1) {
        StringTokenizer stringtokenizer = new StringTokenizer(s, s1);
        String[] as = new String[stringtokenizer.countTokens()];
        for (int i = 0; i < as.length; ++i) {
            as[i] = stringtokenizer.nextToken();
        }
        return as;
    }

    public static final boolean isNumeric(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s can't be null.");
        }
        if (s.trim().length() == 0) {
            return false;
        }
        byte[] abyte0 = s.getBytes();
        for (int i = 0; i < abyte0.length; ++i) {
            if (Character.isDigit((char)abyte0[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean validate(Object value, Integer min, Integer max, String errMessage, JComponent comp, String fieldLabel, List<InvalidValue> invalidValues) {
        boolean isValid = false;
        if (null == min) {
            throw new IllegalArgumentException("min cannot be null");
        }
        if (null == max) {
            throw new IllegalArgumentException("max cannot be null");
        }
        if (errMessage == null) {
            if (value instanceof Integer) {
                errMessage = i18n.translateString("RangeValidator.valueNotInRange", new Object[]{min, max});
            } else if (value instanceof String) {
                errMessage = i18n.translateString("RangeValidator.lengthNotInRange", new Object[]{max});
            }
        } else {
            errMessage = i18n.translateString(errMessage, new Object[]{min, max});
        }
        try {
            if (value instanceof String) {
                if (ValidatorUtil.notInRange(value.toString().length(), min, max)) {
                    ValidatorUtil.generateInvalidValue(value, min, max, errMessage, comp, fieldLabel, invalidValues);
                } else {
                    isValid = true;
                }
            } else if (value instanceof Integer) {
                if (ValidatorUtil.notInRange((Integer)value, min, max)) {
                    ValidatorUtil.generateInvalidValue(value, min, max, errMessage, comp, fieldLabel, invalidValues);
                } else {
                    isValid = true;
                }
            }
        }
        catch (NumberFormatException e) {
            ValidatorUtil.generateInvalidValue(value, min, max, errMessage, comp, fieldLabel, invalidValues);
        }
        return isValid;
    }

    private static void generateInvalidValue(Object value, Integer min, Integer max, String errMessage, JComponent comp, String fieldLabel, List<InvalidValue> invalidValues) {
        InvalidValue invalidValue = new InvalidValue(errMessage, comp.getClass(), fieldLabel, value, (Object)comp);
        invalidValues.add(invalidValue);
    }

    public static boolean validateNumber(String value, Integer min, Integer max, String errMessage, JComponent comp, String fieldLabel, List<InvalidValue> invalidValues) {
        boolean isValid = false;
        if (null == min) {
            throw new IllegalArgumentException("min cannot be null");
        }
        if (null == max) {
            throw new IllegalArgumentException("max cannot be null");
        }
        if (errMessage == null) {
            errMessage = i18n.translateString("RangeValidator.valueNotInRange", new Object[]{min, max});
        }
        try {
            if (ValidatorUtil.notInRange(Integer.parseInt(value), min, max)) {
                ValidatorUtil.generateInvalidValue(value, min, max, errMessage, comp, fieldLabel, invalidValues);
            } else {
                isValid = true;
            }
        }
        catch (NumberFormatException e) {
            ValidatorUtil.generateInvalidValue(value, min, max, i18n.translateString("InvalidNumberFormat"), comp, fieldLabel, invalidValues);
        }
        return isValid;
    }

    private static boolean notInRange(Integer value, Integer min, Integer max) {
        return min.compareTo(value) > 0 || max.compareTo(value) < 0;
    }
}

