/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.util;

import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.util.RbVersions;

public class RbFeatures {
    public static boolean isSipAwareAvailable(RbBaseStationEquipment rbBS) {
        return rbBS != null && (RbVersions.V_4_2.isSupersetOf(rbBS.getSoftwareVersion()) || RbVersions.V_4_5.isSupersetOf(rbBS.getSoftwareVersion()) && rbBS.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) || RbVersions.V_4_5.isSupersetOf(rbBS.getSoftwareVersion()) && rbBS instanceof RbMBS;
    }

    public static boolean isServiceGroupAvailable(RbBaseStationEquipment rbBaseStationEquipment) {
        boolean result = false;
        if (rbBaseStationEquipment != null) {
            boolean switchingIpCSMode = rbBaseStationEquipment.getSwitchingMode().equals(RbBaseStationEquipment.SWITCHING_MODE_IP_CS);
            boolean olderVersion = RbVersions.V_4_5.isOlderOrEqualWith(rbBaseStationEquipment.getSoftwareVersion());
            result = olderVersion && switchingIpCSMode;
        }
        return result;
    }

    public static boolean isNewLimitInVD(RbBaseStationEquipment rbBaseStationEquipment) {
        boolean result = false;
        boolean isVersHigher45 = RbVersions.V_4_5.isOlderOrEqualWith(rbBaseStationEquipment.getSoftwareVersion());
        boolean isMacro = rbBaseStationEquipment instanceof RbBS;
        if (isVersHigher45 && isMacro) {
            result = true;
        }
        return result;
    }
}

